/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.graphics;

import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.util.SparseArray;

public final class ColorFilterCache {
    private static final SparseArray<ColorFilterCache> sColorToFiltersMap = new SparseArray();
    private final PorterDuffColorFilter[] mFilters = new PorterDuffColorFilter[256];

    public static ColorFilterCache getColorFilterCache(int color2) {
        int b;
        int g;
        int r = Color.red((int)color2);
        ColorFilterCache filters = (ColorFilterCache)sColorToFiltersMap.get(color2 = Color.rgb((int)r, (int)(g = Color.green((int)color2)), (int)(b = Color.blue((int)color2))));
        if (filters == null) {
            filters = new ColorFilterCache(r, g, b);
            sColorToFiltersMap.put(color2, (Object)filters);
        }
        return filters;
    }

    private ColorFilterCache(int r, int g, int b) {
        for (int i = 0; i <= 255; ++i) {
            int color2 = Color.argb((int)i, (int)r, (int)g, (int)b);
            this.mFilters[i] = new PorterDuffColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
        }
    }

    public ColorFilter getFilterForLevel(float level) {
        if (level >= 0.0f && (double)level <= 1.0) {
            int filterIndex = (int)(255.0f * level);
            return this.mFilters[filterIndex];
        }
        return null;
    }
}

