/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.graphics;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.support.v17.leanback.R;
import android.view.View;

public final class ColorOverlayDimmer {
    private final float mActiveLevel;
    private final float mDimmedLevel;
    private final Paint mPaint;
    private int mAlpha;
    private float mAlphaFloat;

    public static ColorOverlayDimmer createDefault(Context context) {
        TypedArray a = context.obtainStyledAttributes(R.styleable.LeanbackTheme);
        int dimColor = a.getColor(R.styleable.LeanbackTheme_overlayDimMaskColor, context.getResources().getColor(R.color.lb_view_dim_mask_color));
        float activeLevel = a.getFraction(R.styleable.LeanbackTheme_overlayDimActiveLevel, 1, 1, context.getResources().getFraction(R.fraction.lb_view_active_level, 1, 0));
        float dimmedLevel = a.getFraction(R.styleable.LeanbackTheme_overlayDimDimmedLevel, 1, 1, context.getResources().getFraction(R.fraction.lb_view_dimmed_level, 1, 1));
        a.recycle();
        return new ColorOverlayDimmer(dimColor, activeLevel, dimmedLevel);
    }

    public static ColorOverlayDimmer createColorOverlayDimmer(int dimColor, float activeLevel, float dimmedLevel) {
        return new ColorOverlayDimmer(dimColor, activeLevel, dimmedLevel);
    }

    private ColorOverlayDimmer(int dimColor, float activeLevel, float dimmedLevel) {
        if (activeLevel > 1.0f) {
            activeLevel = 1.0f;
        }
        if (activeLevel < 0.0f) {
            activeLevel = 0.0f;
        }
        if (dimmedLevel > 1.0f) {
            dimmedLevel = 1.0f;
        }
        if (dimmedLevel < 0.0f) {
            dimmedLevel = 0.0f;
        }
        this.mPaint = new Paint();
        dimColor = Color.rgb((int)Color.red((int)dimColor), (int)Color.green((int)dimColor), (int)Color.blue((int)dimColor));
        this.mPaint.setColor(dimColor);
        this.mActiveLevel = activeLevel;
        this.mDimmedLevel = dimmedLevel;
        this.setActiveLevel(1.0f);
    }

    public void setActiveLevel(float level) {
        this.mAlphaFloat = this.mDimmedLevel + level * (this.mActiveLevel - this.mDimmedLevel);
        this.mAlpha = (int)(255.0f * this.mAlphaFloat);
        this.mPaint.setAlpha(this.mAlpha);
    }

    public boolean needsDraw() {
        return this.mAlpha != 0;
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public float getAlphaFloat() {
        return this.mAlphaFloat;
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    public int applyToColor(int color2) {
        float f = 1.0f - this.mAlphaFloat;
        return Color.argb((int)Color.alpha((int)color2), (int)((int)((float)Color.red((int)color2) * f)), (int)((int)((float)Color.green((int)color2) * f)), (int)((int)((float)Color.blue((int)color2) * f)));
    }

    public void drawColorOverlay(Canvas c, View v, boolean includePadding) {
        c.save();
        float dx = (float)v.getLeft() + v.getTranslationX();
        float dy = (float)v.getTop() + v.getTranslationY();
        c.translate(dx, dy);
        c.concat(v.getMatrix());
        c.translate(-dx, -dy);
        if (includePadding) {
            c.drawRect((float)v.getLeft(), (float)v.getTop(), (float)v.getRight(), (float)v.getBottom(), this.mPaint);
        } else {
            c.drawRect((float)(v.getLeft() + v.getPaddingLeft()), (float)(v.getTop() + v.getPaddingTop()), (float)(v.getRight() - v.getPaddingRight()), (float)(v.getBottom() - v.getPaddingBottom()), this.mPaint);
        }
        c.restore();
    }
}

