/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v17.leanback.R;
import android.transition.TransitionValues;
import android.transition.Visibility;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;

class SlideKitkat
extends Visibility {
    private static final String TAG = "SlideKitkat";
    private static final TimeInterpolator sDecelerate = new DecelerateInterpolator();
    private static final TimeInterpolator sAccelerate = new AccelerateInterpolator();
    private int mSlideEdge;
    private CalculateSlide mSlideCalculator;
    private static final CalculateSlide sCalculateLeft = new CalculateSlideHorizontal(){

        @Override
        public float getGone(View view) {
            return view.getTranslationX() - (float)view.getWidth();
        }
    };
    private static final CalculateSlide sCalculateTop = new CalculateSlideVertical(){

        @Override
        public float getGone(View view) {
            return view.getTranslationY() - (float)view.getHeight();
        }
    };
    private static final CalculateSlide sCalculateRight = new CalculateSlideHorizontal(){

        @Override
        public float getGone(View view) {
            return view.getTranslationX() + (float)view.getWidth();
        }
    };
    private static final CalculateSlide sCalculateBottom = new CalculateSlideVertical(){

        @Override
        public float getGone(View view) {
            return view.getTranslationY() + (float)view.getHeight();
        }
    };
    private static final CalculateSlide sCalculateStart = new CalculateSlideHorizontal(){

        @Override
        public float getGone(View view) {
            if (view.getLayoutDirection() == 1) {
                return view.getTranslationX() + (float)view.getWidth();
            }
            return view.getTranslationX() - (float)view.getWidth();
        }
    };
    private static final CalculateSlide sCalculateEnd = new CalculateSlideHorizontal(){

        @Override
        public float getGone(View view) {
            if (view.getLayoutDirection() == 1) {
                return view.getTranslationX() - (float)view.getWidth();
            }
            return view.getTranslationX() + (float)view.getWidth();
        }
    };

    public SlideKitkat() {
        this.setSlideEdge(80);
    }

    public SlideKitkat(Context context, AttributeSet attrs) {
        int resID;
        long startDelay;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.lbSlide);
        int edge = a.getInt(R.styleable.lbSlide_lb_slideEdge, 80);
        this.setSlideEdge(edge);
        long duration = a.getInt(R.styleable.lbSlide_android_duration, -1);
        if (duration >= 0L) {
            this.setDuration(duration);
        }
        if ((startDelay = (long)a.getInt(R.styleable.lbSlide_android_startDelay, -1)) > 0L) {
            this.setStartDelay(startDelay);
        }
        if ((resID = a.getResourceId(R.styleable.lbSlide_android_interpolator, 0)) > 0) {
            this.setInterpolator((TimeInterpolator)AnimationUtils.loadInterpolator((Context)context, (int)resID));
        }
        a.recycle();
    }

    public void setSlideEdge(int slideEdge) {
        switch (slideEdge) {
            case 3: {
                this.mSlideCalculator = sCalculateLeft;
                break;
            }
            case 48: {
                this.mSlideCalculator = sCalculateTop;
                break;
            }
            case 5: {
                this.mSlideCalculator = sCalculateRight;
                break;
            }
            case 80: {
                this.mSlideCalculator = sCalculateBottom;
                break;
            }
            case 0x800003: {
                this.mSlideCalculator = sCalculateStart;
                break;
            }
            case 0x800005: {
                this.mSlideCalculator = sCalculateEnd;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid slide direction");
            }
        }
        this.mSlideEdge = slideEdge;
    }

    public int getSlideEdge() {
        return this.mSlideEdge;
    }

    private Animator createAnimation(View view, Property<View, Float> property, float start, float end, float terminalValue, TimeInterpolator interpolator, int finalVisibility) {
        float[] startPosition = (float[])view.getTag(R.id.lb_slide_transition_value);
        if (startPosition != null) {
            start = View.TRANSLATION_Y == property ? startPosition[1] : startPosition[0];
            view.setTag(R.id.lb_slide_transition_value, null);
        }
        ObjectAnimator anim = ObjectAnimator.ofFloat((Object)view, property, (float[])new float[]{start, end});
        SlideAnimatorListener listener = new SlideAnimatorListener(view, property, terminalValue, end, finalVisibility);
        anim.addListener((Animator.AnimatorListener)listener);
        anim.addPauseListener((Animator.AnimatorPauseListener)listener);
        anim.setInterpolator(interpolator);
        return anim;
    }

    public Animator onAppear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        View view;
        View view2 = view = endValues != null ? endValues.view : null;
        if (view == null) {
            return null;
        }
        float end = this.mSlideCalculator.getHere(view);
        float start = this.mSlideCalculator.getGone(view);
        return this.createAnimation(view, this.mSlideCalculator.getProperty(), start, end, end, sDecelerate, 0);
    }

    public Animator onDisappear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        View view;
        View view2 = view = startValues != null ? startValues.view : null;
        if (view == null) {
            return null;
        }
        float start = this.mSlideCalculator.getHere(view);
        float end = this.mSlideCalculator.getGone(view);
        return this.createAnimation(view, this.mSlideCalculator.getProperty(), start, end, start, sAccelerate, 4);
    }

    private static class SlideAnimatorListener
    extends AnimatorListenerAdapter {
        private boolean mCanceled = false;
        private float mPausedValue;
        private final View mView;
        private final float mEndValue;
        private final float mTerminalValue;
        private final int mFinalVisibility;
        private final Property<View, Float> mProp;

        public SlideAnimatorListener(View view, Property<View, Float> prop, float terminalValue, float endValue, int finalVisibility) {
            this.mProp = prop;
            this.mView = view;
            this.mTerminalValue = terminalValue;
            this.mEndValue = endValue;
            this.mFinalVisibility = finalVisibility;
            view.setVisibility(0);
        }

        public void onAnimationCancel(Animator animator2) {
            float[] transitionPosition = new float[]{this.mView.getTranslationX(), this.mView.getTranslationY()};
            this.mView.setTag(R.id.lb_slide_transition_value, (Object)transitionPosition);
            this.mProp.set((Object)this.mView, (Object)Float.valueOf(this.mTerminalValue));
            this.mCanceled = true;
        }

        public void onAnimationEnd(Animator animator2) {
            if (!this.mCanceled) {
                this.mProp.set((Object)this.mView, (Object)Float.valueOf(this.mTerminalValue));
            }
            this.mView.setVisibility(this.mFinalVisibility);
        }

        public void onAnimationPause(Animator animator2) {
            this.mPausedValue = ((Float)this.mProp.get((Object)this.mView)).floatValue();
            this.mProp.set((Object)this.mView, (Object)Float.valueOf(this.mEndValue));
            this.mView.setVisibility(this.mFinalVisibility);
        }

        public void onAnimationResume(Animator animator2) {
            this.mProp.set((Object)this.mView, (Object)Float.valueOf(this.mPausedValue));
            this.mView.setVisibility(0);
        }
    }

    private static abstract class CalculateSlideVertical
    implements CalculateSlide {
        private CalculateSlideVertical() {
        }

        @Override
        public float getHere(View view) {
            return view.getTranslationY();
        }

        @Override
        public Property<View, Float> getProperty() {
            return View.TRANSLATION_Y;
        }
    }

    private static abstract class CalculateSlideHorizontal
    implements CalculateSlide {
        private CalculateSlideHorizontal() {
        }

        @Override
        public float getHere(View view) {
            return view.getTranslationX();
        }

        @Override
        public Property<View, Float> getProperty() {
            return View.TRANSLATION_X;
        }
    }

    private static interface CalculateSlide {
        public float getGone(View var1);

        public float getHere(View var1);

        public Property<View, Float> getProperty();
    }
}

