/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.transition;

import android.content.Context;
import android.os.Build;
import android.support.v17.leanback.transition.TransitionHelperApi21;
import android.support.v17.leanback.transition.TransitionHelperKitkat;
import android.support.v17.leanback.transition.TransitionListener;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;

public final class TransitionHelper {
    public static final int FADE_IN = 1;
    public static final int FADE_OUT = 2;
    public static final int SLIDE_LEFT = 3;
    public static final int SLIDE_TOP = 48;
    public static final int SLIDE_RIGHT = 5;
    public static final int SLIDE_BOTTOM = 80;
    private static final TransitionHelper sHelper = new TransitionHelper();
    TransitionHelperVersionImpl mImpl = Build.VERSION.SDK_INT >= 21 ? new TransitionHelperApi21Impl() : (TransitionHelper.systemSupportsTransitions() ? new TransitionHelperKitkatImpl() : new TransitionHelperStubImpl());

    public static boolean systemSupportsTransitions() {
        return Build.VERSION.SDK_INT >= 19;
    }

    public static boolean systemSupportsEntranceTransitions() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static TransitionHelper getInstance() {
        return sHelper;
    }

    private TransitionHelper() {
    }

    public Object getSharedElementEnterTransition(Window window) {
        return this.mImpl.getSharedElementEnterTransition(window);
    }

    public Object getSharedElementReturnTransition(Window window) {
        return this.mImpl.getSharedElementReturnTransition(window);
    }

    public Object getSharedElementExitTransition(Window window) {
        return this.mImpl.getSharedElementExitTransition(window);
    }

    public Object getSharedElementReenterTransition(Window window) {
        return this.mImpl.getSharedElementReenterTransition(window);
    }

    public Object getEnterTransition(Window window) {
        return this.mImpl.getEnterTransition(window);
    }

    public Object getReturnTransition(Window window) {
        return this.mImpl.getReturnTransition(window);
    }

    public Object getExitTransition(Window window) {
        return this.mImpl.getExitTransition(window);
    }

    public Object getReenterTransition(Window window) {
        return this.mImpl.getReenterTransition(window);
    }

    public Object createScene(ViewGroup sceneRoot, Runnable r) {
        return this.mImpl.createScene(sceneRoot, r);
    }

    public Object createChangeBounds(boolean reparent) {
        return this.mImpl.createChangeBounds(reparent);
    }

    public void setChangeBoundsStartDelay(Object changeBounds, View view, int startDelay) {
        this.mImpl.setChangeBoundsStartDelay(changeBounds, view, startDelay);
    }

    public void setChangeBoundsStartDelay(Object changeBounds, int viewId, int startDelay) {
        this.mImpl.setChangeBoundsStartDelay(changeBounds, viewId, startDelay);
    }

    public void setChangeBoundsStartDelay(Object changeBounds, String className, int startDelay) {
        this.mImpl.setChangeBoundsStartDelay(changeBounds, className, startDelay);
    }

    public void setChangeBoundsDefaultStartDelay(Object changeBounds, int startDelay) {
        this.mImpl.setChangeBoundsDefaultStartDelay(changeBounds, startDelay);
    }

    public Object createTransitionSet(boolean sequential) {
        return this.mImpl.createTransitionSet(sequential);
    }

    public Object createSlide(int slideEdge) {
        return this.mImpl.createSlide(slideEdge);
    }

    public Object createScale() {
        return this.mImpl.createScale();
    }

    public void addTransition(Object transitionSet, Object transition2) {
        this.mImpl.addTransition(transitionSet, transition2);
    }

    public void exclude(Object transition2, int targetId, boolean exclude) {
        this.mImpl.exclude(transition2, targetId, exclude);
    }

    public void exclude(Object transition2, View targetView, boolean exclude) {
        this.mImpl.exclude(transition2, targetView, exclude);
    }

    public void excludeChildren(Object transition2, int targetId, boolean exclude) {
        this.mImpl.excludeChildren(transition2, targetId, exclude);
    }

    public void excludeChildren(Object transition2, View targetView, boolean exclude) {
        this.mImpl.excludeChildren(transition2, targetView, exclude);
    }

    public void include(Object transition2, int targetId) {
        this.mImpl.include(transition2, targetId);
    }

    public void include(Object transition2, View targetView) {
        this.mImpl.include(transition2, targetView);
    }

    public void setStartDelay(Object transition2, long startDelay) {
        this.mImpl.setStartDelay(transition2, startDelay);
    }

    public void setDuration(Object transition2, long duration) {
        this.mImpl.setDuration(transition2, duration);
    }

    public Object createAutoTransition() {
        return this.mImpl.createAutoTransition();
    }

    public Object createFadeTransition(int fadeMode) {
        return this.mImpl.createFadeTransition(fadeMode);
    }

    public void setTransitionListener(Object transition2, TransitionListener listener) {
        this.mImpl.setTransitionListener(transition2, listener);
    }

    public void runTransition(Object scene, Object transition2) {
        this.mImpl.runTransition(scene, transition2);
    }

    public void setInterpolator(Object transition2, Object timeInterpolator) {
        this.mImpl.setInterpolator(transition2, timeInterpolator);
    }

    public void addTarget(Object transition2, View view) {
        this.mImpl.addTarget(transition2, view);
    }

    public Object createDefaultInterpolator(Context context) {
        return this.mImpl.createDefaultInterpolator(context);
    }

    public Object loadTransition(Context context, int resId) {
        return this.mImpl.loadTransition(context, resId);
    }

    private static final class TransitionHelperApi21Impl
    extends TransitionHelperKitkatImpl {
        private TransitionHelperApi21Impl() {
        }

        @Override
        public Object getSharedElementEnterTransition(Window window) {
            return TransitionHelperApi21.getSharedElementEnterTransition(window);
        }

        @Override
        public Object getSharedElementReturnTransition(Window window) {
            return TransitionHelperApi21.getSharedElementReturnTransition(window);
        }

        @Override
        public Object getSharedElementExitTransition(Window window) {
            return TransitionHelperApi21.getSharedElementExitTransition(window);
        }

        @Override
        public Object getSharedElementReenterTransition(Window window) {
            return TransitionHelperApi21.getSharedElementReenterTransition(window);
        }

        @Override
        public Object getEnterTransition(Window window) {
            return TransitionHelperApi21.getEnterTransition(window);
        }

        @Override
        public Object getReturnTransition(Window window) {
            return TransitionHelperApi21.getReturnTransition(window);
        }

        @Override
        public Object getExitTransition(Window window) {
            return TransitionHelperApi21.getExitTransition(window);
        }

        @Override
        public Object getReenterTransition(Window window) {
            return TransitionHelperApi21.getReenterTransition(window);
        }

        @Override
        public Object createScale() {
            return TransitionHelperApi21.createScale();
        }

        @Override
        public Object createDefaultInterpolator(Context context) {
            return TransitionHelperApi21.createDefaultInterpolator(context);
        }
    }

    private static class TransitionHelperKitkatImpl
    implements TransitionHelperVersionImpl {
        private TransitionHelperKitkatImpl() {
        }

        @Override
        public Object getSharedElementEnterTransition(Window window) {
            return null;
        }

        @Override
        public Object getSharedElementReturnTransition(Window window) {
            return null;
        }

        @Override
        public Object getSharedElementExitTransition(Window window) {
            return null;
        }

        @Override
        public Object getSharedElementReenterTransition(Window window) {
            return null;
        }

        @Override
        public Object getEnterTransition(Window window) {
            return null;
        }

        @Override
        public Object getReturnTransition(Window window) {
            return null;
        }

        @Override
        public Object getExitTransition(Window window) {
            return null;
        }

        @Override
        public Object getReenterTransition(Window window) {
            return null;
        }

        @Override
        public Object createScene(ViewGroup sceneRoot, Runnable r) {
            return TransitionHelperKitkat.createScene(sceneRoot, r);
        }

        @Override
        public Object createAutoTransition() {
            return TransitionHelperKitkat.createAutoTransition();
        }

        @Override
        public Object createFadeTransition(int fadingMode) {
            return TransitionHelperKitkat.createFadeTransition(fadingMode);
        }

        @Override
        public Object createChangeBounds(boolean reparent) {
            return TransitionHelperKitkat.createChangeBounds(reparent);
        }

        @Override
        public Object createSlide(int slideEdge) {
            return TransitionHelperKitkat.createSlide(slideEdge);
        }

        @Override
        public Object createScale() {
            return TransitionHelperKitkat.createScale();
        }

        @Override
        public void setChangeBoundsStartDelay(Object changeBounds, View view, int startDelay) {
            TransitionHelperKitkat.setChangeBoundsStartDelay(changeBounds, view, startDelay);
        }

        @Override
        public void setChangeBoundsStartDelay(Object changeBounds, int viewId, int startDelay) {
            TransitionHelperKitkat.setChangeBoundsStartDelay(changeBounds, viewId, startDelay);
        }

        @Override
        public void setChangeBoundsStartDelay(Object changeBounds, String className, int startDelay) {
            TransitionHelperKitkat.setChangeBoundsStartDelay(changeBounds, className, startDelay);
        }

        @Override
        public void setChangeBoundsDefaultStartDelay(Object changeBounds, int startDelay) {
            TransitionHelperKitkat.setChangeBoundsDefaultStartDelay(changeBounds, startDelay);
        }

        @Override
        public Object createTransitionSet(boolean sequential) {
            return TransitionHelperKitkat.createTransitionSet(sequential);
        }

        @Override
        public void addTransition(Object transitionSet, Object transition2) {
            TransitionHelperKitkat.addTransition(transitionSet, transition2);
        }

        @Override
        public void exclude(Object transition2, int targetId, boolean exclude) {
            TransitionHelperKitkat.exclude(transition2, targetId, exclude);
        }

        @Override
        public void exclude(Object transition2, View targetView, boolean exclude) {
            TransitionHelperKitkat.exclude(transition2, targetView, exclude);
        }

        @Override
        public void excludeChildren(Object transition2, int targetId, boolean exclude) {
            TransitionHelperKitkat.excludeChildren(transition2, targetId, exclude);
        }

        @Override
        public void excludeChildren(Object transition2, View targetView, boolean exclude) {
            TransitionHelperKitkat.excludeChildren(transition2, targetView, exclude);
        }

        @Override
        public void include(Object transition2, int targetId) {
            TransitionHelperKitkat.include(transition2, targetId);
        }

        @Override
        public void include(Object transition2, View targetView) {
            TransitionHelperKitkat.include(transition2, targetView);
        }

        @Override
        public void setStartDelay(Object transition2, long startDelay) {
            TransitionHelperKitkat.setStartDelay(transition2, startDelay);
        }

        @Override
        public void setDuration(Object transition2, long duration) {
            TransitionHelperKitkat.setDuration(transition2, duration);
        }

        @Override
        public void setTransitionListener(Object transition2, TransitionListener listener) {
            TransitionHelperKitkat.setTransitionListener(transition2, listener);
        }

        @Override
        public void runTransition(Object scene, Object transition2) {
            TransitionHelperKitkat.runTransition(scene, transition2);
        }

        @Override
        public void setInterpolator(Object transition2, Object timeInterpolator) {
            TransitionHelperKitkat.setInterpolator(transition2, timeInterpolator);
        }

        @Override
        public void addTarget(Object transition2, View view) {
            TransitionHelperKitkat.addTarget(transition2, view);
        }

        @Override
        public Object createDefaultInterpolator(Context context) {
            return null;
        }

        @Override
        public Object loadTransition(Context context, int resId) {
            return TransitionHelperKitkat.loadTransition(context, resId);
        }
    }

    private static final class TransitionHelperStubImpl
    implements TransitionHelperVersionImpl {
        private TransitionHelperStubImpl() {
        }

        @Override
        public Object getSharedElementEnterTransition(Window window) {
            return null;
        }

        @Override
        public Object getSharedElementReturnTransition(Window window) {
            return null;
        }

        @Override
        public Object getSharedElementExitTransition(Window window) {
            return null;
        }

        @Override
        public Object getSharedElementReenterTransition(Window window) {
            return null;
        }

        @Override
        public Object getEnterTransition(Window window) {
            return null;
        }

        @Override
        public Object getReturnTransition(Window window) {
            return null;
        }

        @Override
        public Object getExitTransition(Window window) {
            return null;
        }

        @Override
        public Object getReenterTransition(Window window) {
            return null;
        }

        @Override
        public Object createScene(ViewGroup sceneRoot, Runnable r) {
            return r;
        }

        @Override
        public Object createAutoTransition() {
            return new TransitionStub();
        }

        @Override
        public Object createFadeTransition(int fadingMode) {
            return new TransitionStub();
        }

        @Override
        public Object createChangeBounds(boolean reparent) {
            return new TransitionStub();
        }

        @Override
        public Object createSlide(int slideEdge) {
            return new TransitionStub();
        }

        @Override
        public Object createScale() {
            return new TransitionStub();
        }

        @Override
        public void setChangeBoundsStartDelay(Object changeBounds, View view, int startDelay) {
        }

        @Override
        public void setChangeBoundsStartDelay(Object changeBounds, int viewId, int startDelay) {
        }

        @Override
        public void setChangeBoundsStartDelay(Object changeBounds, String className, int startDelay) {
        }

        @Override
        public void setChangeBoundsDefaultStartDelay(Object changeBounds, int startDelay) {
        }

        @Override
        public Object createTransitionSet(boolean sequential) {
            return new TransitionStub();
        }

        @Override
        public void addTransition(Object transitionSet, Object transition2) {
        }

        @Override
        public void exclude(Object transition2, int targetId, boolean exclude) {
        }

        @Override
        public void exclude(Object transition2, View targetView, boolean exclude) {
        }

        @Override
        public void excludeChildren(Object transition2, int targetId, boolean exclude) {
        }

        @Override
        public void excludeChildren(Object transition2, View targetView, boolean exclude) {
        }

        @Override
        public void include(Object transition2, int targetId) {
        }

        @Override
        public void include(Object transition2, View targetView) {
        }

        @Override
        public void setStartDelay(Object transition2, long startDelay) {
        }

        @Override
        public void setDuration(Object transition2, long duration) {
        }

        @Override
        public void setTransitionListener(Object transition2, TransitionListener listener) {
            ((TransitionStub)transition2).mTransitionListener = listener;
        }

        @Override
        public void runTransition(Object scene, Object transition2) {
            Runnable r;
            TransitionStub transitionStub = (TransitionStub)transition2;
            if (transitionStub != null && transitionStub.mTransitionListener != null) {
                transitionStub.mTransitionListener.onTransitionStart(transition2);
            }
            if ((r = (Runnable)scene) != null) {
                r.run();
            }
            if (transitionStub != null && transitionStub.mTransitionListener != null) {
                transitionStub.mTransitionListener.onTransitionEnd(transition2);
            }
        }

        @Override
        public void setInterpolator(Object transition2, Object timeInterpolator) {
        }

        @Override
        public void addTarget(Object transition2, View view) {
        }

        @Override
        public Object createDefaultInterpolator(Context context) {
            return null;
        }

        @Override
        public Object loadTransition(Context context, int resId) {
            return new TransitionStub();
        }

        private static class TransitionStub {
            TransitionListener mTransitionListener;

            private TransitionStub() {
            }
        }
    }

    static interface TransitionHelperVersionImpl {
        public Object getSharedElementEnterTransition(Window var1);

        public Object getSharedElementReturnTransition(Window var1);

        public Object getSharedElementExitTransition(Window var1);

        public Object getSharedElementReenterTransition(Window var1);

        public Object getEnterTransition(Window var1);

        public Object getReturnTransition(Window var1);

        public Object getExitTransition(Window var1);

        public Object getReenterTransition(Window var1);

        public Object createScene(ViewGroup var1, Runnable var2);

        public Object createAutoTransition();

        public Object createSlide(int var1);

        public Object createScale();

        public Object createFadeTransition(int var1);

        public Object createChangeBounds(boolean var1);

        public void setChangeBoundsStartDelay(Object var1, View var2, int var3);

        public void setChangeBoundsStartDelay(Object var1, int var2, int var3);

        public void setChangeBoundsStartDelay(Object var1, String var2, int var3);

        public void setChangeBoundsDefaultStartDelay(Object var1, int var2);

        public Object createTransitionSet(boolean var1);

        public void addTransition(Object var1, Object var2);

        public void setTransitionListener(Object var1, TransitionListener var2);

        public void runTransition(Object var1, Object var2);

        public void exclude(Object var1, int var2, boolean var3);

        public void exclude(Object var1, View var2, boolean var3);

        public void excludeChildren(Object var1, int var2, boolean var3);

        public void excludeChildren(Object var1, View var2, boolean var3);

        public void include(Object var1, int var2);

        public void include(Object var1, View var2);

        public void setStartDelay(Object var1, long var2);

        public void setDuration(Object var1, long var2);

        public void setInterpolator(Object var1, Object var2);

        public void addTarget(Object var1, View var2);

        public Object createDefaultInterpolator(Context var1);

        public Object loadTransition(Context var1, int var2);
    }
}

