/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.transition;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.support.v17.leanback.transition.Scale;
import android.support.v17.leanback.transition.SlideKitkat;
import android.support.v17.leanback.transition.TransitionListener;
import android.transition.AutoTransition;
import android.transition.ChangeBounds;
import android.transition.Fade;
import android.transition.Scene;
import android.transition.Transition;
import android.transition.TransitionInflater;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.transition.TransitionValues;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import java.util.HashMap;

final class TransitionHelperKitkat {
    TransitionHelperKitkat() {
    }

    static Object createScene(ViewGroup sceneRoot, Runnable enterAction) {
        Scene scene = new Scene(sceneRoot);
        scene.setEnterAction(enterAction);
        return scene;
    }

    static Object createTransitionSet(boolean sequential) {
        TransitionSet set = new TransitionSet();
        set.setOrdering(sequential ? 1 : 0);
        return set;
    }

    static void addTransition(Object transitionSet, Object transition2) {
        ((TransitionSet)transitionSet).addTransition((Transition)transition2);
    }

    static Object createAutoTransition() {
        return new AutoTransition();
    }

    static Object createSlide(int slideEdge) {
        SlideKitkat slide = new SlideKitkat();
        slide.setSlideEdge(slideEdge);
        return slide;
    }

    static Object createScale() {
        Scale scale = new Scale();
        return scale;
    }

    static Object createFadeTransition(int fadingMode) {
        Fade fade = new Fade(fadingMode);
        return fade;
    }

    static Object createChangeBounds(boolean reparent) {
        CustomChangeBounds changeBounds = new CustomChangeBounds();
        changeBounds.setReparent(reparent);
        return changeBounds;
    }

    static void setChangeBoundsStartDelay(Object changeBounds, int viewId, int startDelay) {
        ((CustomChangeBounds)((Object)changeBounds)).setStartDelay(viewId, startDelay);
    }

    static void setChangeBoundsStartDelay(Object changeBounds, View view, int startDelay) {
        ((CustomChangeBounds)((Object)changeBounds)).setStartDelay(view, startDelay);
    }

    static void setChangeBoundsStartDelay(Object changeBounds, String className, int startDelay) {
        ((CustomChangeBounds)((Object)changeBounds)).setStartDelay(className, startDelay);
    }

    static void setChangeBoundsDefaultStartDelay(Object changeBounds, int startDelay) {
        ((CustomChangeBounds)((Object)changeBounds)).setDefaultStartDelay(startDelay);
    }

    static void setStartDelay(Object transition2, long startDelay) {
        ((Transition)transition2).setStartDelay(startDelay);
    }

    static void setDuration(Object transition2, long duration) {
        ((Transition)transition2).setDuration(duration);
    }

    static void exclude(Object transition2, int targetId, boolean exclude) {
        ((Transition)transition2).excludeTarget(targetId, exclude);
    }

    static void exclude(Object transition2, View targetView, boolean exclude) {
        ((Transition)transition2).excludeTarget(targetView, exclude);
    }

    static void excludeChildren(Object transition2, int targetId, boolean exclude) {
        ((Transition)transition2).excludeChildren(targetId, exclude);
    }

    static void excludeChildren(Object transition2, View targetView, boolean exclude) {
        ((Transition)transition2).excludeChildren(targetView, exclude);
    }

    static void include(Object transition2, int targetId) {
        ((Transition)transition2).addTarget(targetId);
    }

    static void include(Object transition2, View targetView) {
        ((Transition)transition2).addTarget(targetView);
    }

    static void setTransitionListener(Object transition2, final TransitionListener listener) {
        Transition t = (Transition)transition2;
        t.addListener(new Transition.TransitionListener(){

            public void onTransitionStart(Transition transition2) {
                listener.onTransitionStart(transition2);
            }

            public void onTransitionResume(Transition transition2) {
            }

            public void onTransitionPause(Transition transition2) {
            }

            public void onTransitionEnd(Transition transition2) {
                listener.onTransitionEnd(transition2);
            }

            public void onTransitionCancel(Transition transition2) {
            }
        });
    }

    static void runTransition(Object scene, Object transition2) {
        TransitionManager.go((Scene)((Scene)scene), (Transition)((Transition)transition2));
    }

    static void setInterpolator(Object transition2, Object timeInterpolator) {
        ((Transition)transition2).setInterpolator((TimeInterpolator)timeInterpolator);
    }

    static void addTarget(Object transition2, View view) {
        ((Transition)transition2).addTarget(view);
    }

    static Object loadTransition(Context context, int resId) {
        return TransitionInflater.from((Context)context).inflateTransition(resId);
    }

    static class CustomChangeBounds
    extends ChangeBounds {
        int mDefaultStartDelay;
        final HashMap<View, Integer> mViewStartDelays = new HashMap();
        final SparseIntArray mIdStartDelays = new SparseIntArray();
        final HashMap<String, Integer> mClassStartDelays = new HashMap();

        CustomChangeBounds() {
        }

        private int getDelay(View view) {
            Integer delay = this.mViewStartDelays.get(view);
            if (delay != null) {
                return delay;
            }
            int idStartDelay = this.mIdStartDelays.get(view.getId(), -1);
            if (idStartDelay != -1) {
                return idStartDelay;
            }
            delay = this.mClassStartDelays.get(view.getClass().getName());
            if (delay != null) {
                return delay;
            }
            return this.mDefaultStartDelay;
        }

        public Animator createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
            Animator animator2 = super.createAnimator(sceneRoot, startValues, endValues);
            if (animator2 != null && endValues != null && endValues.view != null) {
                animator2.setStartDelay((long)this.getDelay(endValues.view));
            }
            return animator2;
        }

        public void setStartDelay(View view, int startDelay) {
            this.mViewStartDelays.put(view, startDelay);
        }

        public void setStartDelay(int viewId, int startDelay) {
            this.mIdStartDelays.put(viewId, startDelay);
        }

        public void setStartDelay(String className, int startDelay) {
            this.mClassStartDelays.put(className, startDelay);
        }

        public void setDefaultStartDelay(int startDelay) {
            this.mDefaultStartDelay = startDelay;
        }
    }
}

