/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.graphics.Paint;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.Presenter;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.TextView;

public abstract class AbstractDetailsDescriptionPresenter
extends Presenter {
    @Override
    public final ViewHolder onCreateViewHolder(ViewGroup parent) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.lb_details_description, parent, false);
        return new ViewHolder(v);
    }

    @Override
    public final void onBindViewHolder(Presenter.ViewHolder viewHolder, Object item) {
        ViewHolder vh = (ViewHolder)viewHolder;
        this.onBindDescription(vh, item);
        boolean hasTitle = true;
        if (TextUtils.isEmpty((CharSequence)vh.mTitle.getText())) {
            vh.mTitle.setVisibility(8);
            hasTitle = false;
        } else {
            vh.mTitle.setVisibility(0);
            vh.mTitle.setLineSpacing((float)(vh.mTitleLineSpacing - vh.mTitle.getLineHeight()) + vh.mTitle.getLineSpacingExtra(), vh.mTitle.getLineSpacingMultiplier());
            vh.mTitle.setMaxLines(vh.mTitleMaxLines);
        }
        this.setTopMargin(vh.mTitle, vh.mTitleMargin);
        boolean hasSubtitle = true;
        if (TextUtils.isEmpty((CharSequence)vh.mSubtitle.getText())) {
            vh.mSubtitle.setVisibility(8);
            hasSubtitle = false;
        } else {
            vh.mSubtitle.setVisibility(0);
            if (hasTitle) {
                this.setTopMargin(vh.mSubtitle, vh.mUnderTitleBaselineMargin + ((ViewHolder)vh).mSubtitleFontMetricsInt.ascent - ((ViewHolder)vh).mTitleFontMetricsInt.descent);
            } else {
                this.setTopMargin(vh.mSubtitle, 0);
            }
        }
        if (TextUtils.isEmpty((CharSequence)vh.mBody.getText())) {
            vh.mBody.setVisibility(8);
        } else {
            vh.mBody.setVisibility(0);
            vh.mBody.setLineSpacing((float)(vh.mBodyLineSpacing - vh.mBody.getLineHeight()) + vh.mBody.getLineSpacingExtra(), vh.mBody.getLineSpacingMultiplier());
            if (hasSubtitle) {
                this.setTopMargin(vh.mBody, vh.mUnderSubtitleBaselineMargin + ((ViewHolder)vh).mBodyFontMetricsInt.ascent - ((ViewHolder)vh).mSubtitleFontMetricsInt.descent);
            } else if (hasTitle) {
                this.setTopMargin(vh.mBody, vh.mUnderTitleBaselineMargin + ((ViewHolder)vh).mBodyFontMetricsInt.ascent - ((ViewHolder)vh).mTitleFontMetricsInt.descent);
            } else {
                this.setTopMargin(vh.mBody, 0);
            }
        }
    }

    protected abstract void onBindDescription(ViewHolder var1, Object var2);

    @Override
    public void onUnbindViewHolder(Presenter.ViewHolder viewHolder) {
    }

    @Override
    public void onViewAttachedToWindow(Presenter.ViewHolder holder) {
        ViewHolder vh = (ViewHolder)holder;
        vh.addPreDrawListener();
        super.onViewAttachedToWindow(holder);
    }

    @Override
    public void onViewDetachedFromWindow(Presenter.ViewHolder holder) {
        ViewHolder vh = (ViewHolder)holder;
        vh.removePreDrawListener();
        super.onViewDetachedFromWindow(holder);
    }

    private void setTopMargin(TextView textView, int topMargin) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)textView.getLayoutParams();
        lp.topMargin = topMargin;
        textView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public static class ViewHolder
    extends Presenter.ViewHolder {
        private final TextView mTitle;
        private final TextView mSubtitle;
        private final TextView mBody;
        private final int mTitleMargin;
        private final int mUnderTitleBaselineMargin;
        private final int mUnderSubtitleBaselineMargin;
        private final int mTitleLineSpacing;
        private final int mBodyLineSpacing;
        private final int mBodyMaxLines;
        private final int mBodyMinLines;
        private final Paint.FontMetricsInt mTitleFontMetricsInt;
        private final Paint.FontMetricsInt mSubtitleFontMetricsInt;
        private final Paint.FontMetricsInt mBodyFontMetricsInt;
        private final int mTitleMaxLines;
        private ViewTreeObserver.OnPreDrawListener mPreDrawListener;

        public ViewHolder(View view) {
            super(view);
            this.mTitle = (TextView)view.findViewById(R.id.lb_details_description_title);
            this.mSubtitle = (TextView)view.findViewById(R.id.lb_details_description_subtitle);
            this.mBody = (TextView)view.findViewById(R.id.lb_details_description_body);
            Paint.FontMetricsInt titleFontMetricsInt = this.getFontMetricsInt(this.mTitle);
            int titleAscent = view.getResources().getDimensionPixelSize(R.dimen.lb_details_description_title_baseline);
            this.mTitleMargin = titleAscent + titleFontMetricsInt.ascent;
            this.mUnderTitleBaselineMargin = view.getResources().getDimensionPixelSize(R.dimen.lb_details_description_under_title_baseline_margin);
            this.mUnderSubtitleBaselineMargin = view.getResources().getDimensionPixelSize(R.dimen.lb_details_description_under_subtitle_baseline_margin);
            this.mTitleLineSpacing = view.getResources().getDimensionPixelSize(R.dimen.lb_details_description_title_line_spacing);
            this.mBodyLineSpacing = view.getResources().getDimensionPixelSize(R.dimen.lb_details_description_body_line_spacing);
            this.mBodyMaxLines = view.getResources().getInteger(R.integer.lb_details_description_body_max_lines);
            this.mBodyMinLines = view.getResources().getInteger(R.integer.lb_details_description_body_min_lines);
            this.mTitleMaxLines = this.mTitle.getMaxLines();
            this.mTitleFontMetricsInt = this.getFontMetricsInt(this.mTitle);
            this.mSubtitleFontMetricsInt = this.getFontMetricsInt(this.mSubtitle);
            this.mBodyFontMetricsInt = this.getFontMetricsInt(this.mBody);
            this.mTitle.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    ViewHolder.this.addPreDrawListener();
                }
            });
        }

        void addPreDrawListener() {
            if (this.mPreDrawListener != null) {
                return;
            }
            this.mPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    int maxLines;
                    if (ViewHolder.this.mSubtitle.getVisibility() == 0 && ViewHolder.this.mSubtitle.getTop() > ViewHolder.this.view.getHeight() && ViewHolder.this.mTitle.getLineCount() > 1) {
                        ViewHolder.this.mTitle.setMaxLines(ViewHolder.this.mTitle.getLineCount() - 1);
                        return false;
                    }
                    int titleLines = ViewHolder.this.mTitle.getLineCount();
                    int n = maxLines = titleLines > 1 ? ViewHolder.this.mBodyMinLines : ViewHolder.this.mBodyMaxLines;
                    if (ViewHolder.this.mBody.getMaxLines() != maxLines) {
                        ViewHolder.this.mBody.setMaxLines(maxLines);
                        return false;
                    }
                    ViewHolder.this.removePreDrawListener();
                    return true;
                }
            };
            this.view.getViewTreeObserver().addOnPreDrawListener(this.mPreDrawListener);
        }

        void removePreDrawListener() {
            if (this.mPreDrawListener != null) {
                this.view.getViewTreeObserver().removeOnPreDrawListener(this.mPreDrawListener);
                this.mPreDrawListener = null;
            }
        }

        public TextView getTitle() {
            return this.mTitle;
        }

        public TextView getSubtitle() {
            return this.mSubtitle;
        }

        public TextView getBody() {
            return this.mBody;
        }

        private Paint.FontMetricsInt getFontMetricsInt(TextView textView) {
            Paint paint = new Paint(1);
            paint.setTextSize(textView.getTextSize());
            paint.setTypeface(textView.getTypeface());
            return paint.getFontMetricsInt();
        }
    }
}

