/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.database.Cursor;
import android.support.v17.leanback.database.CursorMapper;
import android.support.v17.leanback.widget.ObjectAdapter;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.PresenterSelector;
import android.util.LruCache;

public class CursorObjectAdapter
extends ObjectAdapter {
    private static final int CACHE_SIZE = 100;
    private Cursor mCursor;
    private CursorMapper mMapper;
    private final LruCache<Integer, Object> mItemCache = new LruCache(100);

    public CursorObjectAdapter(PresenterSelector presenterSelector) {
        super(presenterSelector);
    }

    public CursorObjectAdapter(Presenter presenter) {
        super(presenter);
    }

    public CursorObjectAdapter() {
    }

    public void changeCursor(Cursor cursor) {
        if (cursor == this.mCursor) {
            return;
        }
        if (this.mCursor != null) {
            this.mCursor.close();
        }
        this.mCursor = cursor;
        this.mItemCache.trimToSize(0);
        this.onCursorChanged();
    }

    public Cursor swapCursor(Cursor cursor) {
        if (cursor == this.mCursor) {
            return this.mCursor;
        }
        Cursor oldCursor = this.mCursor;
        this.mCursor = cursor;
        this.mItemCache.trimToSize(0);
        this.onCursorChanged();
        return oldCursor;
    }

    protected void onCursorChanged() {
        this.notifyChanged();
    }

    public final Cursor getCursor() {
        return this.mCursor;
    }

    public final void setMapper(CursorMapper mapper) {
        boolean changed = this.mMapper != mapper;
        this.mMapper = mapper;
        if (changed) {
            this.onMapperChanged();
        }
    }

    protected void onMapperChanged() {
    }

    public final CursorMapper getMapper() {
        return this.mMapper;
    }

    @Override
    public int size() {
        if (this.mCursor == null) {
            return 0;
        }
        return this.mCursor.getCount();
    }

    @Override
    public Object get(int index) {
        if (this.mCursor == null) {
            return null;
        }
        if (!this.mCursor.moveToPosition(index)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object item = this.mItemCache.get((Object)index);
        if (item != null) {
            return item;
        }
        item = this.mMapper.convert(this.mCursor);
        this.mItemCache.put((Object)index, item);
        return item;
    }

    public void close() {
        if (this.mCursor != null) {
            this.mCursor.close();
            this.mCursor = null;
        }
    }

    public boolean isClosed() {
        return this.mCursor == null || this.mCursor.isClosed();
    }

    protected final void invalidateCache(int index) {
        this.mItemCache.remove((Object)index);
    }

    protected final void invalidateCache(int index, int count) {
        int limit = count + index;
        while (index < limit) {
            this.invalidateCache(index);
            ++index;
        }
    }
}

