/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.annotation.ColorInt;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.Action;
import android.support.v17.leanback.widget.BaseGridView;
import android.support.v17.leanback.widget.DetailsOverviewRow;
import android.support.v17.leanback.widget.DetailsOverviewSharedElementHelper;
import android.support.v17.leanback.widget.HorizontalGridView;
import android.support.v17.leanback.widget.ItemBridgeAdapter;
import android.support.v17.leanback.widget.ObjectAdapter;
import android.support.v17.leanback.widget.OnActionClickedListener;
import android.support.v17.leanback.widget.OnChildSelectedListener;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.RoundedRectHelper;
import android.support.v17.leanback.widget.RowPresenter;
import android.support.v7.widget.RecyclerView;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;

@Deprecated
public class DetailsOverviewRowPresenter
extends RowPresenter {
    private static final String TAG = "DetailsOverviewRowPresenter";
    private static final boolean DEBUG = false;
    private static final int MORE_ACTIONS_FADE_MS = 100;
    private static final long DEFAULT_TIMEOUT = 5000L;
    private final Presenter mDetailsPresenter;
    private OnActionClickedListener mActionClickedListener;
    private int mBackgroundColor = 0;
    private boolean mBackgroundColorSet;
    private boolean mIsStyleLarge = true;
    private DetailsOverviewSharedElementHelper mSharedElementHelper;

    public DetailsOverviewRowPresenter(Presenter detailsPresenter) {
        this.setHeaderPresenter(null);
        this.setSelectEffectEnabled(false);
        this.mDetailsPresenter = detailsPresenter;
    }

    public void setOnActionClickedListener(OnActionClickedListener listener) {
        this.mActionClickedListener = listener;
    }

    public OnActionClickedListener getOnActionClickedListener() {
        return this.mActionClickedListener;
    }

    public void setBackgroundColor(@ColorInt int color2) {
        this.mBackgroundColor = color2;
        this.mBackgroundColorSet = true;
    }

    @ColorInt
    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setStyleLarge(boolean large) {
        this.mIsStyleLarge = large;
    }

    public boolean isStyleLarge() {
        return this.mIsStyleLarge;
    }

    public final void setSharedElementEnterTransition(Activity activity, String sharedElementName, long timeoutMs) {
        if (this.mSharedElementHelper == null) {
            this.mSharedElementHelper = new DetailsOverviewSharedElementHelper();
        }
        this.mSharedElementHelper.setSharedElementEnterTransition(activity, sharedElementName, timeoutMs);
    }

    public final void setSharedElementEnterTransition(Activity activity, String sharedElementName) {
        this.setSharedElementEnterTransition(activity, sharedElementName, 5000L);
    }

    private int getDefaultBackgroundColor(Context context) {
        TypedValue outValue = new TypedValue();
        if (context.getTheme().resolveAttribute(R.attr.defaultBrandColor, outValue, true)) {
            return context.getResources().getColor(outValue.resourceId);
        }
        return context.getResources().getColor(R.color.lb_default_brand_color);
    }

    @Override
    protected void onRowViewSelected(RowPresenter.ViewHolder vh, boolean selected) {
        super.onRowViewSelected(vh, selected);
        if (selected) {
            ((ViewHolder)vh).dispatchItemSelection(null);
        }
    }

    @Override
    protected RowPresenter.ViewHolder createRowViewHolder(ViewGroup parent) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.lb_details_overview, parent, false);
        ViewHolder vh = new ViewHolder(v, this.mDetailsPresenter);
        this.initDetailsOverview(vh);
        return vh;
    }

    private int getCardHeight(Context context) {
        int resId = this.mIsStyleLarge ? R.dimen.lb_details_overview_height_large : R.dimen.lb_details_overview_height_small;
        return context.getResources().getDimensionPixelSize(resId);
    }

    private void initDetailsOverview(final ViewHolder vh) {
        vh.mActionBridgeAdapter = new ActionsItemBridgeAdapter(vh);
        FrameLayout overview = vh.mOverviewFrame;
        ViewGroup.LayoutParams lp = overview.getLayoutParams();
        lp.height = this.getCardHeight(overview.getContext());
        overview.setLayoutParams(lp);
        if (!this.getSelectEffectEnabled()) {
            vh.mOverviewFrame.setForeground(null);
        }
        vh.mActionsRow.setOnUnhandledKeyListener(new BaseGridView.OnUnhandledKeyListener(){

            @Override
            public boolean onUnhandledKey(KeyEvent event) {
                return vh.getOnKeyListener() != null && vh.getOnKeyListener().onKey(vh.view, event.getKeyCode(), event);
            }
        });
    }

    private static int getNonNegativeWidth(Drawable drawable2) {
        int width = drawable2 == null ? 0 : drawable2.getIntrinsicWidth();
        return width > 0 ? width : 0;
    }

    private static int getNonNegativeHeight(Drawable drawable2) {
        int height = drawable2 == null ? 0 : drawable2.getIntrinsicHeight();
        return height > 0 ? height : 0;
    }

    private void bindImageDrawable(ViewHolder vh) {
        int bgColor;
        DetailsOverviewRow row = (DetailsOverviewRow)vh.getRow();
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)vh.mImageView.getLayoutParams();
        int cardHeight = this.getCardHeight(vh.mImageView.getContext());
        int verticalMargin = vh.mImageView.getResources().getDimensionPixelSize(R.dimen.lb_details_overview_image_margin_vertical);
        int horizontalMargin = vh.mImageView.getResources().getDimensionPixelSize(R.dimen.lb_details_overview_image_margin_horizontal);
        int drawableWidth = DetailsOverviewRowPresenter.getNonNegativeWidth(row.getImageDrawable());
        int drawableHeight = DetailsOverviewRowPresenter.getNonNegativeHeight(row.getImageDrawable());
        boolean scaleImage = row.isImageScaleUpAllowed();
        boolean useMargin = false;
        if (row.getImageDrawable() != null) {
            boolean landscape = false;
            if (drawableWidth > drawableHeight) {
                landscape = true;
                if (this.mIsStyleLarge) {
                    useMargin = true;
                }
            }
            if (landscape && drawableWidth > cardHeight || !landscape && drawableHeight > cardHeight) {
                scaleImage = true;
            }
            if (!scaleImage) {
                useMargin = true;
            }
            if (useMargin && !scaleImage) {
                if (landscape && drawableWidth > cardHeight - horizontalMargin) {
                    scaleImage = true;
                } else if (!landscape && drawableHeight > cardHeight - 2 * verticalMargin) {
                    scaleImage = true;
                }
            }
        }
        int n = bgColor = this.mBackgroundColorSet ? this.mBackgroundColor : this.getDefaultBackgroundColor(vh.mOverviewView.getContext());
        if (useMargin) {
            layoutParams.setMarginStart(horizontalMargin);
            layoutParams.topMargin = layoutParams.bottomMargin = verticalMargin;
            vh.mOverviewFrame.setBackgroundColor(bgColor);
            vh.mRightPanel.setBackground(null);
            vh.mImageView.setBackground(null);
        } else {
            layoutParams.bottomMargin = 0;
            layoutParams.topMargin = 0;
            layoutParams.leftMargin = 0;
            vh.mRightPanel.setBackgroundColor(bgColor);
            vh.mImageView.setBackgroundColor(bgColor);
            vh.mOverviewFrame.setBackground(null);
        }
        RoundedRectHelper.getInstance().setClipToRoundedOutline((View)vh.mOverviewFrame, true);
        if (scaleImage) {
            vh.mImageView.setScaleType(ImageView.ScaleType.FIT_START);
            vh.mImageView.setAdjustViewBounds(true);
            vh.mImageView.setMaxWidth(cardHeight);
            layoutParams.height = -1;
            layoutParams.width = -2;
        } else {
            vh.mImageView.setScaleType(ImageView.ScaleType.CENTER);
            vh.mImageView.setAdjustViewBounds(false);
            layoutParams.height = -2;
            layoutParams.width = Math.min(cardHeight, drawableWidth);
        }
        vh.mImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        vh.mImageView.setImageDrawable(row.getImageDrawable());
        if (row.getImageDrawable() != null && this.mSharedElementHelper != null) {
            this.mSharedElementHelper.onBindToDrawable(vh);
        }
    }

    @Override
    protected void onBindRowViewHolder(RowPresenter.ViewHolder holder, Object item) {
        super.onBindRowViewHolder(holder, item);
        DetailsOverviewRow row = (DetailsOverviewRow)item;
        ViewHolder vh = (ViewHolder)holder;
        this.bindImageDrawable(vh);
        this.mDetailsPresenter.onBindViewHolder(vh.mDetailsDescriptionViewHolder, row.getItem());
        vh.bindActions(row.getActionsAdapter());
        row.addListener(vh.mListener);
    }

    @Override
    protected void onUnbindRowViewHolder(RowPresenter.ViewHolder holder) {
        ViewHolder vh = (ViewHolder)holder;
        DetailsOverviewRow dor = (DetailsOverviewRow)vh.getRow();
        dor.removeListener(vh.mListener);
        if (vh.mDetailsDescriptionViewHolder != null) {
            this.mDetailsPresenter.onUnbindViewHolder(vh.mDetailsDescriptionViewHolder);
        }
        super.onUnbindRowViewHolder(holder);
    }

    @Override
    public final boolean isUsingDefaultSelectEffect() {
        return false;
    }

    @Override
    protected void onSelectLevelChanged(RowPresenter.ViewHolder holder) {
        super.onSelectLevelChanged(holder);
        if (this.getSelectEffectEnabled()) {
            ViewHolder vh = (ViewHolder)holder;
            int dimmedColor = vh.mColorDimmer.getPaint().getColor();
            ((ColorDrawable)vh.mOverviewFrame.getForeground().mutate()).setColor(dimmedColor);
        }
    }

    @Override
    protected void onRowViewAttachedToWindow(RowPresenter.ViewHolder vh) {
        super.onRowViewAttachedToWindow(vh);
        if (this.mDetailsPresenter != null) {
            this.mDetailsPresenter.onViewAttachedToWindow(((ViewHolder)vh).mDetailsDescriptionViewHolder);
        }
    }

    @Override
    protected void onRowViewDetachedFromWindow(RowPresenter.ViewHolder vh) {
        super.onRowViewDetachedFromWindow(vh);
        if (this.mDetailsPresenter != null) {
            this.mDetailsPresenter.onViewDetachedFromWindow(((ViewHolder)vh).mDetailsDescriptionViewHolder);
        }
    }

    public final class ViewHolder
    extends RowPresenter.ViewHolder {
        final FrameLayout mOverviewFrame;
        final ViewGroup mOverviewView;
        final ImageView mImageView;
        final ViewGroup mRightPanel;
        final FrameLayout mDetailsDescriptionFrame;
        final HorizontalGridView mActionsRow;
        public final Presenter.ViewHolder mDetailsDescriptionViewHolder;
        int mNumItems;
        boolean mShowMoreRight;
        boolean mShowMoreLeft;
        ItemBridgeAdapter mActionBridgeAdapter;
        final Handler mHandler;
        final Runnable mUpdateDrawableCallback;
        final DetailsOverviewRow.Listener mListener;
        final View.OnLayoutChangeListener mLayoutChangeListener;
        final OnChildSelectedListener mChildSelectedListener;
        final RecyclerView.OnScrollListener mScrollListener;

        void bindActions(ObjectAdapter adapter) {
            this.mActionBridgeAdapter.setAdapter(adapter);
            this.mActionsRow.setAdapter(this.mActionBridgeAdapter);
            this.mNumItems = this.mActionBridgeAdapter.getItemCount();
            this.mShowMoreRight = false;
            this.mShowMoreLeft = true;
            this.showMoreLeft(false);
        }

        void dispatchItemSelection(View view) {
            if (!this.isSelected()) {
                return;
            }
            ItemBridgeAdapter.ViewHolder ibvh = (ItemBridgeAdapter.ViewHolder)(view != null ? this.mActionsRow.getChildViewHolder(view) : this.mActionsRow.findViewHolderForPosition(this.mActionsRow.getSelectedPosition()));
            if (ibvh == null) {
                if (this.getOnItemViewSelectedListener() != null) {
                    this.getOnItemViewSelectedListener().onItemSelected(null, null, this, this.getRow());
                }
            } else if (this.getOnItemViewSelectedListener() != null) {
                this.getOnItemViewSelectedListener().onItemSelected(ibvh.getViewHolder(), ibvh.getItem(), this, this.getRow());
            }
        }

        private int getViewCenter(View view) {
            return (view.getRight() - view.getLeft()) / 2;
        }

        private void checkFirstAndLastPosition(boolean fromScroll) {
            RecyclerView.ViewHolder viewHolder = this.mActionsRow.findViewHolderForPosition(this.mNumItems - 1);
            boolean showRight = viewHolder == null || viewHolder.itemView.getRight() > this.mActionsRow.getWidth();
            viewHolder = this.mActionsRow.findViewHolderForPosition(0);
            boolean showLeft = viewHolder == null || viewHolder.itemView.getLeft() < 0;
            this.showMoreRight(showRight);
            this.showMoreLeft(showLeft);
        }

        private void showMoreLeft(boolean show) {
            if (show != this.mShowMoreLeft) {
                this.mActionsRow.setFadingLeftEdge(show);
                this.mShowMoreLeft = show;
            }
        }

        private void showMoreRight(boolean show) {
            if (show != this.mShowMoreRight) {
                this.mActionsRow.setFadingRightEdge(show);
                this.mShowMoreRight = show;
            }
        }

        public ViewHolder(View rootView, Presenter detailsPresenter) {
            super(rootView);
            this.mHandler = new Handler();
            this.mUpdateDrawableCallback = new Runnable(){

                @Override
                public void run() {
                    DetailsOverviewRowPresenter.this.bindImageDrawable(ViewHolder.this);
                }
            };
            this.mListener = new DetailsOverviewRow.Listener(){

                @Override
                public void onImageDrawableChanged(DetailsOverviewRow row) {
                    ViewHolder.this.mHandler.removeCallbacks(ViewHolder.this.mUpdateDrawableCallback);
                    ViewHolder.this.mHandler.post(ViewHolder.this.mUpdateDrawableCallback);
                }

                @Override
                public void onItemChanged(DetailsOverviewRow row) {
                    if (ViewHolder.this.mDetailsDescriptionViewHolder != null) {
                        DetailsOverviewRowPresenter.this.mDetailsPresenter.onUnbindViewHolder(ViewHolder.this.mDetailsDescriptionViewHolder);
                    }
                    DetailsOverviewRowPresenter.this.mDetailsPresenter.onBindViewHolder(ViewHolder.this.mDetailsDescriptionViewHolder, row.getItem());
                }

                @Override
                public void onActionsAdapterChanged(DetailsOverviewRow row) {
                    ViewHolder.this.bindActions(row.getActionsAdapter());
                }
            };
            this.mLayoutChangeListener = new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    ViewHolder.this.checkFirstAndLastPosition(false);
                }
            };
            this.mChildSelectedListener = new OnChildSelectedListener(){

                @Override
                public void onChildSelected(ViewGroup parent, View view, int position, long id2) {
                    ViewHolder.this.dispatchItemSelection(view);
                }
            };
            this.mScrollListener = new RecyclerView.OnScrollListener(){

                public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                }

                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                    ViewHolder.this.checkFirstAndLastPosition(true);
                }
            };
            this.mOverviewFrame = (FrameLayout)rootView.findViewById(R.id.details_frame);
            this.mOverviewView = (ViewGroup)rootView.findViewById(R.id.details_overview);
            this.mImageView = (ImageView)rootView.findViewById(R.id.details_overview_image);
            this.mRightPanel = (ViewGroup)rootView.findViewById(R.id.details_overview_right_panel);
            this.mDetailsDescriptionFrame = (FrameLayout)this.mRightPanel.findViewById(R.id.details_overview_description);
            this.mActionsRow = (HorizontalGridView)this.mRightPanel.findViewById(R.id.details_overview_actions);
            this.mActionsRow.setHasOverlappingRendering(false);
            this.mActionsRow.setOnScrollListener(this.mScrollListener);
            this.mActionsRow.setAdapter(this.mActionBridgeAdapter);
            this.mActionsRow.setOnChildSelectedListener(this.mChildSelectedListener);
            int fadeLength = rootView.getResources().getDimensionPixelSize(R.dimen.lb_details_overview_actions_fade_size);
            this.mActionsRow.setFadingRightEdgeLength(fadeLength);
            this.mActionsRow.setFadingLeftEdgeLength(fadeLength);
            this.mDetailsDescriptionViewHolder = detailsPresenter.onCreateViewHolder((ViewGroup)this.mDetailsDescriptionFrame);
            this.mDetailsDescriptionFrame.addView(this.mDetailsDescriptionViewHolder.view);
        }
    }

    class ActionsItemBridgeAdapter
    extends ItemBridgeAdapter {
        ViewHolder mViewHolder;

        ActionsItemBridgeAdapter(ViewHolder viewHolder) {
            this.mViewHolder = viewHolder;
        }

        @Override
        public void onBind(final ItemBridgeAdapter.ViewHolder ibvh) {
            if (this.mViewHolder.getOnItemViewClickedListener() != null || DetailsOverviewRowPresenter.this.mActionClickedListener != null) {
                ibvh.getPresenter().setOnClickListener(ibvh.getViewHolder(), new View.OnClickListener(){

                    public void onClick(View v) {
                        if (ActionsItemBridgeAdapter.this.mViewHolder.getOnItemViewClickedListener() != null) {
                            ActionsItemBridgeAdapter.this.mViewHolder.getOnItemViewClickedListener().onItemClicked(ibvh.getViewHolder(), ibvh.getItem(), ActionsItemBridgeAdapter.this.mViewHolder, ActionsItemBridgeAdapter.this.mViewHolder.getRow());
                        }
                        if (DetailsOverviewRowPresenter.this.mActionClickedListener != null) {
                            DetailsOverviewRowPresenter.this.mActionClickedListener.onActionClicked((Action)ibvh.getItem());
                        }
                    }
                });
            }
        }

        @Override
        public void onUnbind(ItemBridgeAdapter.ViewHolder ibvh) {
            if (this.mViewHolder.getOnItemViewClickedListener() != null || DetailsOverviewRowPresenter.this.mActionClickedListener != null) {
                ibvh.getPresenter().setOnClickListener(ibvh.getViewHolder(), null);
            }
        }

        @Override
        public void onAttachedToWindow(ItemBridgeAdapter.ViewHolder viewHolder) {
            viewHolder.itemView.removeOnLayoutChangeListener(this.mViewHolder.mLayoutChangeListener);
            viewHolder.itemView.addOnLayoutChangeListener(this.mViewHolder.mLayoutChangeListener);
        }

        @Override
        public void onDetachedFromWindow(ItemBridgeAdapter.ViewHolder viewHolder) {
            viewHolder.itemView.removeOnLayoutChangeListener(this.mViewHolder.mLayoutChangeListener);
            this.mViewHolder.checkFirstAndLastPosition(false);
        }
    }
}

