/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.app.Activity;
import android.graphics.Matrix;
import android.os.Handler;
import android.support.v17.leanback.transition.TransitionHelper;
import android.support.v17.leanback.transition.TransitionListener;
import android.support.v17.leanback.widget.DetailsOverviewRowPresenter;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.SharedElementCallback;
import android.support.v4.view.ViewCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import java.util.List;

final class DetailsOverviewSharedElementHelper
extends SharedElementCallback {
    private static final String TAG = "DetailsOverviewSharedElementHelper";
    private static final boolean DEBUG = false;
    private DetailsOverviewRowPresenter.ViewHolder mViewHolder;
    private Activity mActivityToRunTransition;
    private boolean mStartedPostpone;
    private String mSharedElementName;
    private int mRightPanelWidth;
    private int mRightPanelHeight;
    private ImageView.ScaleType mSavedScaleType;
    private Matrix mSavedMatrix;

    DetailsOverviewSharedElementHelper() {
    }

    private boolean hasImageViewScaleChange(View snapshotView) {
        return snapshotView instanceof ImageView;
    }

    private void saveImageViewScale() {
        if (this.mSavedScaleType == null) {
            ImageView imageView = this.mViewHolder.mImageView;
            this.mSavedScaleType = imageView.getScaleType();
            this.mSavedMatrix = this.mSavedScaleType == ImageView.ScaleType.MATRIX ? imageView.getMatrix() : null;
        }
    }

    private static void updateImageViewAfterScaleTypeChange(ImageView imageView) {
        imageView.measure(View.MeasureSpec.makeMeasureSpec((int)imageView.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)imageView.getMeasuredHeight(), (int)0x40000000));
        imageView.layout(imageView.getLeft(), imageView.getTop(), imageView.getRight(), imageView.getBottom());
    }

    private void changeImageViewScale(View snapshotView) {
        ImageView snapshotImageView = (ImageView)snapshotView;
        ImageView imageView = this.mViewHolder.mImageView;
        imageView.setScaleType(snapshotImageView.getScaleType());
        if (snapshotImageView.getScaleType() == ImageView.ScaleType.MATRIX) {
            imageView.setImageMatrix(snapshotImageView.getImageMatrix());
        }
        DetailsOverviewSharedElementHelper.updateImageViewAfterScaleTypeChange(imageView);
    }

    private void restoreImageViewScale() {
        if (this.mSavedScaleType != null) {
            ImageView imageView = this.mViewHolder.mImageView;
            imageView.setScaleType(this.mSavedScaleType);
            if (this.mSavedScaleType == ImageView.ScaleType.MATRIX) {
                imageView.setImageMatrix(this.mSavedMatrix);
            }
            this.mSavedScaleType = null;
            DetailsOverviewSharedElementHelper.updateImageViewAfterScaleTypeChange(imageView);
        }
    }

    public void onSharedElementStart(List<String> sharedElementNames, List<View> sharedElements, List<View> sharedElementSnapshots) {
        if (sharedElements.size() < 1) {
            return;
        }
        View overviewView = sharedElements.get(0);
        if (this.mViewHolder == null || this.mViewHolder.mOverviewFrame != overviewView) {
            return;
        }
        View snapshot = sharedElementSnapshots.get(0);
        if (this.hasImageViewScaleChange(snapshot)) {
            this.saveImageViewScale();
            this.changeImageViewScale(snapshot);
        }
        ImageView imageView = this.mViewHolder.mImageView;
        int width = overviewView.getWidth();
        int height = overviewView.getHeight();
        imageView.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        imageView.layout(0, 0, width, height);
        ViewGroup rightPanel = this.mViewHolder.mRightPanel;
        if (this.mRightPanelWidth != 0 && this.mRightPanelHeight != 0) {
            rightPanel.measure(View.MeasureSpec.makeMeasureSpec((int)this.mRightPanelWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.mRightPanelHeight, (int)0x40000000));
            rightPanel.layout(width, rightPanel.getTop(), width + this.mRightPanelWidth, rightPanel.getTop() + this.mRightPanelHeight);
        } else {
            rightPanel.offsetLeftAndRight(width - rightPanel.getLeft());
        }
        this.mViewHolder.mActionsRow.setVisibility(4);
        this.mViewHolder.mDetailsDescriptionFrame.setVisibility(4);
    }

    public void onSharedElementEnd(List<String> sharedElementNames, List<View> sharedElements, List<View> sharedElementSnapshots) {
        if (sharedElements.size() < 1) {
            return;
        }
        View overviewView = sharedElements.get(0);
        if (this.mViewHolder == null || this.mViewHolder.mOverviewFrame != overviewView) {
            return;
        }
        this.restoreImageViewScale();
        this.mViewHolder.mActionsRow.setDescendantFocusability(131072);
        this.mViewHolder.mActionsRow.setVisibility(0);
        this.mViewHolder.mActionsRow.setDescendantFocusability(262144);
        this.mViewHolder.mDetailsDescriptionFrame.setVisibility(0);
    }

    void setSharedElementEnterTransition(Activity activity, String sharedElementName, long timeoutMs) {
        if (activity == null && !TextUtils.isEmpty((CharSequence)sharedElementName) || activity != null && TextUtils.isEmpty((CharSequence)sharedElementName)) {
            throw new IllegalArgumentException();
        }
        if (activity == this.mActivityToRunTransition && TextUtils.equals((CharSequence)sharedElementName, (CharSequence)this.mSharedElementName)) {
            return;
        }
        if (this.mActivityToRunTransition != null) {
            ActivityCompat.setEnterSharedElementCallback((Activity)this.mActivityToRunTransition, null);
        }
        this.mActivityToRunTransition = activity;
        this.mSharedElementName = sharedElementName;
        ActivityCompat.setEnterSharedElementCallback((Activity)this.mActivityToRunTransition, (SharedElementCallback)this);
        ActivityCompat.postponeEnterTransition((Activity)this.mActivityToRunTransition);
        if (timeoutMs > 0L) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (DetailsOverviewSharedElementHelper.this.mStartedPostpone) {
                        return;
                    }
                    DetailsOverviewSharedElementHelper.this.startPostponedEnterTransition();
                }
            }, timeoutMs);
        }
    }

    void onBindToDrawable(DetailsOverviewRowPresenter.ViewHolder vh) {
        if (this.mViewHolder != null) {
            ViewCompat.setTransitionName((View)this.mViewHolder.mOverviewFrame, null);
        }
        this.mViewHolder = vh;
        this.mViewHolder.mRightPanel.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                ((DetailsOverviewSharedElementHelper)DetailsOverviewSharedElementHelper.this).mViewHolder.mRightPanel.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                DetailsOverviewSharedElementHelper.this.mRightPanelWidth = ((DetailsOverviewSharedElementHelper)DetailsOverviewSharedElementHelper.this).mViewHolder.mRightPanel.getWidth();
                DetailsOverviewSharedElementHelper.this.mRightPanelHeight = ((DetailsOverviewSharedElementHelper)DetailsOverviewSharedElementHelper.this).mViewHolder.mRightPanel.getHeight();
            }
        });
        this.mViewHolder.mRightPanel.postOnAnimation(new Runnable(){

            @Override
            public void run() {
                ViewCompat.setTransitionName((View)((DetailsOverviewSharedElementHelper)DetailsOverviewSharedElementHelper.this).mViewHolder.mOverviewFrame, (String)DetailsOverviewSharedElementHelper.this.mSharedElementName);
                final TransitionHelper transitionHelper = TransitionHelper.getInstance();
                Object transition2 = transitionHelper.getSharedElementEnterTransition(DetailsOverviewSharedElementHelper.this.mActivityToRunTransition.getWindow());
                if (transition2 != null) {
                    transitionHelper.setTransitionListener(transition2, new TransitionListener(){

                        @Override
                        public void onTransitionEnd(Object transition2) {
                            if (((DetailsOverviewSharedElementHelper)DetailsOverviewSharedElementHelper.this).mViewHolder.mActionsRow.isFocused()) {
                                ((DetailsOverviewSharedElementHelper)DetailsOverviewSharedElementHelper.this).mViewHolder.mActionsRow.requestFocus();
                            }
                            transitionHelper.setTransitionListener(transition2, null);
                        }
                    });
                }
                DetailsOverviewSharedElementHelper.this.startPostponedEnterTransition();
            }
        });
    }

    private void startPostponedEnterTransition() {
        if (!this.mStartedPostpone) {
            ActivityCompat.startPostponedEnterTransition((Activity)this.mActivityToRunTransition);
            this.mStartedPostpone = true;
        }
    }
}

