/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.animation.TimeAnimator;
import android.content.res.Resources;
import android.support.v17.leanback.R;
import android.support.v17.leanback.graphics.ColorOverlayDimmer;
import android.support.v17.leanback.widget.BaseGridView;
import android.support.v17.leanback.widget.FocusHighlightHandler;
import android.support.v17.leanback.widget.ItemBridgeAdapter;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.RowHeaderPresenter;
import android.support.v17.leanback.widget.ShadowOverlayContainer;
import android.support.v17.leanback.widget.VerticalGridView;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;

public class FocusHighlightHelper {
    static boolean isValidZoomIndex(int zoomIndex) {
        return zoomIndex == 0 || FocusHighlightHelper.getResId(zoomIndex) > 0;
    }

    private static int getResId(int zoomIndex) {
        switch (zoomIndex) {
            case 1: {
                return R.fraction.lb_focus_zoom_factor_small;
            }
            case 4: {
                return R.fraction.lb_focus_zoom_factor_xsmall;
            }
            case 2: {
                return R.fraction.lb_focus_zoom_factor_medium;
            }
            case 3: {
                return R.fraction.lb_focus_zoom_factor_large;
            }
        }
        return 0;
    }

    public static void setupBrowseItemFocusHighlight(ItemBridgeAdapter adapter, int zoomIndex, boolean useDimmer) {
        adapter.setFocusHighlight(new BrowseItemFocusHighlight(zoomIndex, useDimmer));
    }

    public static void setupHeaderItemFocusHighlight(VerticalGridView gridView) {
        if (gridView.getAdapter() instanceof ItemBridgeAdapter) {
            ((ItemBridgeAdapter)gridView.getAdapter()).setFocusHighlight(new HeaderItemFocusHighlight(gridView));
        }
    }

    static class HeaderItemFocusHighlight
    implements FocusHighlightHandler {
        private static boolean sInitialized;
        private static float sSelectScale;
        private static int sDuration;
        private BaseGridView mGridView;

        HeaderItemFocusHighlight(BaseGridView gridView) {
            this.mGridView = gridView;
            HeaderItemFocusHighlight.lazyInit(gridView.getContext().getResources());
        }

        private static void lazyInit(Resources res) {
            if (!sInitialized) {
                sSelectScale = Float.parseFloat(res.getString(R.dimen.lb_browse_header_select_scale));
                sDuration = Integer.parseInt(res.getString(R.dimen.lb_browse_header_select_duration));
                sInitialized = true;
            }
        }

        private void viewFocused(View view, boolean hasFocus) {
            view.setSelected(hasFocus);
            FocusAnimator animator2 = (FocusAnimator)view.getTag(R.id.lb_focus_animator);
            if (animator2 == null) {
                animator2 = new HeaderFocusAnimator(view, sSelectScale, sDuration);
                view.setTag(R.id.lb_focus_animator, (Object)animator2);
            }
            animator2.animateFocus(hasFocus, false);
        }

        @Override
        public void onItemFocused(View view, boolean hasFocus) {
            this.viewFocused(view, hasFocus);
        }

        @Override
        public void onInitializeView(View view) {
        }

        class HeaderFocusAnimator
        extends FocusAnimator {
            ItemBridgeAdapter.ViewHolder mViewHolder;

            HeaderFocusAnimator(View view, float scale, int duration) {
                super(view, scale, false, duration);
                this.mViewHolder = (ItemBridgeAdapter.ViewHolder)HeaderItemFocusHighlight.this.mGridView.getChildViewHolder(view);
            }

            @Override
            void setFocusLevel(float level) {
                Presenter presenter = this.mViewHolder.getPresenter();
                if (presenter instanceof RowHeaderPresenter) {
                    ((RowHeaderPresenter)presenter).setSelectLevel((RowHeaderPresenter.ViewHolder)this.mViewHolder.getViewHolder(), level);
                }
                super.setFocusLevel(level);
            }
        }
    }

    static class BrowseItemFocusHighlight
    implements FocusHighlightHandler {
        private static final int DURATION_MS = 150;
        private int mScaleIndex;
        private final boolean mUseDimmer;

        BrowseItemFocusHighlight(int zoomIndex, boolean useDimmer) {
            if (!FocusHighlightHelper.isValidZoomIndex(zoomIndex)) {
                throw new IllegalArgumentException("Unhandled zoom index");
            }
            this.mScaleIndex = zoomIndex;
            this.mUseDimmer = useDimmer;
        }

        private float getScale(Resources res) {
            return this.mScaleIndex == 0 ? 1.0f : res.getFraction(FocusHighlightHelper.getResId(this.mScaleIndex), 1, 1);
        }

        @Override
        public void onItemFocused(View view, boolean hasFocus) {
            view.setSelected(hasFocus);
            this.getOrCreateAnimator(view).animateFocus(hasFocus, false);
        }

        @Override
        public void onInitializeView(View view) {
            this.getOrCreateAnimator(view).animateFocus(false, true);
        }

        private FocusAnimator getOrCreateAnimator(View view) {
            FocusAnimator animator2 = (FocusAnimator)view.getTag(R.id.lb_focus_animator);
            if (animator2 == null) {
                animator2 = new FocusAnimator(view, this.getScale(view.getResources()), this.mUseDimmer, 150);
                view.setTag(R.id.lb_focus_animator, (Object)animator2);
            }
            return animator2;
        }
    }

    static class FocusAnimator
    implements TimeAnimator.TimeListener {
        private final View mView;
        private final int mDuration;
        private final ShadowOverlayContainer mWrapper;
        private final float mScaleDiff;
        private float mFocusLevel = 0.0f;
        private float mFocusLevelStart;
        private float mFocusLevelDelta;
        private final TimeAnimator mAnimator = new TimeAnimator();
        private final Interpolator mInterpolator = new AccelerateDecelerateInterpolator();
        private final ColorOverlayDimmer mDimmer;

        void animateFocus(boolean select, boolean immediate) {
            float end;
            this.endAnimation();
            float f = end = select ? 1.0f : 0.0f;
            if (immediate) {
                this.setFocusLevel(end);
            } else if (this.mFocusLevel != end) {
                this.mFocusLevelStart = this.mFocusLevel;
                this.mFocusLevelDelta = end - this.mFocusLevelStart;
                this.mAnimator.start();
            }
        }

        FocusAnimator(View view, float scale, boolean useDimmer, int duration) {
            this.mView = view;
            this.mDuration = duration;
            this.mScaleDiff = scale - 1.0f;
            this.mWrapper = view instanceof ShadowOverlayContainer ? (ShadowOverlayContainer)view : null;
            this.mAnimator.setTimeListener((TimeAnimator.TimeListener)this);
            this.mDimmer = this.mWrapper != null && useDimmer ? ColorOverlayDimmer.createDefault(view.getContext()) : null;
        }

        void setFocusLevel(float level) {
            this.mFocusLevel = level;
            float scale = 1.0f + this.mScaleDiff * level;
            this.mView.setScaleX(scale);
            this.mView.setScaleY(scale);
            if (this.mWrapper != null) {
                this.mWrapper.setShadowFocusLevel(level);
                if (this.mDimmer != null) {
                    this.mDimmer.setActiveLevel(level);
                    this.mWrapper.setOverlayColor(this.mDimmer.getPaint().getColor());
                }
            }
        }

        float getFocusLevel() {
            return this.mFocusLevel;
        }

        void endAnimation() {
            this.mAnimator.end();
        }

        public void onTimeUpdate(TimeAnimator animation, long totalTime, long deltaTime) {
            float fraction2;
            if (totalTime >= (long)this.mDuration) {
                fraction2 = 1.0f;
                this.mAnimator.end();
            } else {
                fraction2 = (float)((double)totalTime / (double)this.mDuration);
            }
            if (this.mInterpolator != null) {
                fraction2 = this.mInterpolator.getInterpolation(fraction2);
            }
            this.setFocusLevel(this.mFocusLevelStart + fraction2 * this.mFocusLevelDelta);
        }
    }
}

