/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.FragmentAnimationProvider;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.List;

public class GuidanceStylist
implements FragmentAnimationProvider {
    private TextView mTitleView;
    private TextView mDescriptionView;
    private TextView mBreadcrumbView;
    private ImageView mIconView;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Guidance guidance) {
        View guidanceView = inflater.inflate(this.onProvideLayoutId(), container, false);
        this.mTitleView = (TextView)guidanceView.findViewById(R.id.guidance_title);
        this.mBreadcrumbView = (TextView)guidanceView.findViewById(R.id.guidance_breadcrumb);
        this.mDescriptionView = (TextView)guidanceView.findViewById(R.id.guidance_description);
        this.mIconView = (ImageView)guidanceView.findViewById(R.id.guidance_icon);
        if (this.mTitleView != null) {
            this.mTitleView.setText((CharSequence)guidance.getTitle());
        }
        if (this.mBreadcrumbView != null) {
            this.mBreadcrumbView.setText((CharSequence)guidance.getBreadcrumb());
        }
        if (this.mDescriptionView != null) {
            this.mDescriptionView.setText((CharSequence)guidance.getDescription());
        }
        if (this.mIconView != null) {
            this.mIconView.setImageDrawable(guidance.getIconDrawable());
        }
        return guidanceView;
    }

    public int onProvideLayoutId() {
        return R.layout.lb_guidance;
    }

    public TextView getTitleView() {
        return this.mTitleView;
    }

    public TextView getDescriptionView() {
        return this.mDescriptionView;
    }

    public TextView getBreadcrumbView() {
        return this.mBreadcrumbView;
    }

    public ImageView getIconView() {
        return this.mIconView;
    }

    @Override
    public void onActivityEnter(@NonNull List<Animator> animators) {
        this.addAnimator(animators, (View)this.mTitleView, R.attr.guidanceEntryAnimation);
        this.addAnimator(animators, (View)this.mBreadcrumbView, R.attr.guidanceEntryAnimation);
        this.addAnimator(animators, (View)this.mDescriptionView, R.attr.guidanceEntryAnimation);
        this.addAnimator(animators, (View)this.mIconView, R.attr.guidanceEntryAnimation);
    }

    @Override
    public void onActivityExit(@NonNull List<Animator> animators) {
    }

    @Override
    public void onFragmentEnter(@NonNull List<Animator> animators) {
        this.addAnimator(animators, (View)this.mTitleView, R.attr.guidedStepEntryAnimation);
        this.addAnimator(animators, (View)this.mBreadcrumbView, R.attr.guidedStepEntryAnimation);
        this.addAnimator(animators, (View)this.mDescriptionView, R.attr.guidedStepEntryAnimation);
        this.addAnimator(animators, (View)this.mIconView, R.attr.guidedStepEntryAnimation);
    }

    @Override
    public void onFragmentExit(@NonNull List<Animator> animators) {
        this.addAnimator(animators, (View)this.mTitleView, R.attr.guidedStepExitAnimation);
        this.addAnimator(animators, (View)this.mBreadcrumbView, R.attr.guidedStepExitAnimation);
        this.addAnimator(animators, (View)this.mDescriptionView, R.attr.guidedStepExitAnimation);
        this.addAnimator(animators, (View)this.mIconView, R.attr.guidedStepExitAnimation);
    }

    @Override
    public void onFragmentReenter(@NonNull List<Animator> animators) {
        this.addAnimator(animators, (View)this.mTitleView, R.attr.guidedStepReentryAnimation);
        this.addAnimator(animators, (View)this.mBreadcrumbView, R.attr.guidedStepReentryAnimation);
        this.addAnimator(animators, (View)this.mDescriptionView, R.attr.guidedStepReentryAnimation);
        this.addAnimator(animators, (View)this.mIconView, R.attr.guidedStepReentryAnimation);
    }

    @Override
    public void onFragmentReturn(@NonNull List<Animator> animators) {
        this.addAnimator(animators, (View)this.mTitleView, R.attr.guidedStepReturnAnimation);
        this.addAnimator(animators, (View)this.mBreadcrumbView, R.attr.guidedStepReturnAnimation);
        this.addAnimator(animators, (View)this.mDescriptionView, R.attr.guidedStepReturnAnimation);
        this.addAnimator(animators, (View)this.mIconView, R.attr.guidedStepReturnAnimation);
    }

    private void addAnimator(List<Animator> animators, View v, int attrId) {
        if (v != null) {
            Context ctx = v.getContext();
            TypedValue typedValue = new TypedValue();
            ctx.getTheme().resolveAttribute(attrId, typedValue, true);
            Animator animator2 = AnimatorInflater.loadAnimator((Context)ctx, (int)typedValue.resourceId);
            animator2.setTarget((Object)v);
            animators.add(animator2);
        }
    }

    public static class Guidance {
        private final String mTitle;
        private final String mDescription;
        private final String mBreadcrumb;
        private final Drawable mIconDrawable;

        public Guidance(String title, String description, String breadcrumb, Drawable icon) {
            this.mBreadcrumb = breadcrumb;
            this.mTitle = title;
            this.mDescription = description;
            this.mIconDrawable = icon;
        }

        public String getTitle() {
            return this.mTitle;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public String getBreadcrumb() {
            return this.mBreadcrumb;
        }

        public Drawable getIconDrawable() {
            return this.mIconDrawable;
        }
    }
}

