/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.support.v17.leanback.widget.Action;

public class GuidedAction
extends Action {
    private static final String TAG = "GuidedAction";
    public static final int NO_DRAWABLE = 0;
    public static final int NO_CHECK_SET = 0;
    public static final int DEFAULT_CHECK_SET_ID = 1;
    private boolean mChecked;
    private boolean mMultilineDescription;
    private boolean mHasNext;
    private boolean mInfoOnly;
    private int mCheckSetId;
    private boolean mEnabled;
    private Intent mIntent;

    private GuidedAction() {
        super(0L);
    }

    public CharSequence getTitle() {
        return this.getLabel1();
    }

    public CharSequence getDescription() {
        return this.getLabel2();
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(boolean checked) {
        this.mChecked = checked;
    }

    public int getCheckSetId() {
        return this.mCheckSetId;
    }

    public boolean hasMultilineDescription() {
        return this.mMultilineDescription;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public boolean hasNext() {
        return this.mHasNext;
    }

    public boolean infoOnly() {
        return this.mInfoOnly;
    }

    public static class Builder {
        private long mId;
        private String mTitle;
        private String mDescription;
        private Drawable mIcon;
        private boolean mChecked;
        private boolean mMultilineDescription;
        private boolean mHasNext;
        private boolean mInfoOnly;
        private int mCheckSetId = 0;
        private boolean mEnabled = true;
        private Intent mIntent;

        public GuidedAction build() {
            GuidedAction action = new GuidedAction();
            action.setId(this.mId);
            action.setLabel1(this.mTitle);
            action.setLabel2(this.mDescription);
            action.setIcon(this.mIcon);
            action.mIntent = this.mIntent;
            action.mChecked = this.mChecked;
            action.mCheckSetId = this.mCheckSetId;
            action.mMultilineDescription = this.mMultilineDescription;
            action.mHasNext = this.mHasNext;
            action.mInfoOnly = this.mInfoOnly;
            action.mEnabled = this.mEnabled;
            return action;
        }

        public Builder id(long id2) {
            this.mId = id2;
            return this;
        }

        public Builder title(String title) {
            this.mTitle = title;
            return this;
        }

        public Builder description(String description) {
            this.mDescription = description;
            return this;
        }

        public Builder intent(Intent intent) {
            this.mIntent = intent;
            return this;
        }

        public Builder icon(Drawable icon) {
            this.mIcon = icon;
            return this;
        }

        public Builder iconResourceId(int iconResourceId, Context context) {
            return this.icon(context.getResources().getDrawable(iconResourceId));
        }

        public Builder checked(boolean checked) {
            this.mChecked = checked;
            return this;
        }

        public Builder checkSetId(int checkSetId) {
            this.mCheckSetId = checkSetId;
            return this;
        }

        public Builder multilineDescription(boolean multilineDescription) {
            this.mMultilineDescription = multilineDescription;
            return this;
        }

        public Builder hasNext(boolean hasNext) {
            this.mHasNext = hasNext;
            return this;
        }

        public Builder infoOnly(boolean infoOnly) {
            this.mInfoOnly = infoOnly;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.mEnabled = enabled;
            return this;
        }
    }
}

