/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.FragmentAnimationProvider;
import android.support.v17.leanback.widget.GuidedAction;
import android.support.v17.leanback.widget.VerticalGridView;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.List;

public class GuidedActionsStylist
implements FragmentAnimationProvider {
    private static String TAG = "GuidedActionsStylist";
    protected View mMainView;
    protected VerticalGridView mActionsGridView;
    protected View mSelectorView;
    private float mEnabledChevronAlpha;
    private float mDisabledChevronAlpha;
    private int mContentWidth;
    private int mContentWidthNoIcon;
    private int mTitleMinLines;
    private int mTitleMaxLines;
    private int mDescriptionMinLines;
    private int mVerticalPadding;
    private int mDisplayHeight;

    public View onCreateView(LayoutInflater inflater, ViewGroup container) {
        this.mMainView = inflater.inflate(this.onProvideLayoutId(), container, false);
        this.mSelectorView = this.mMainView.findViewById(R.id.guidedactions_selector);
        if (this.mMainView instanceof VerticalGridView) {
            this.mActionsGridView = (VerticalGridView)this.mMainView;
        } else {
            this.mActionsGridView = (VerticalGridView)this.mMainView.findViewById(R.id.guidedactions_list);
            if (this.mActionsGridView == null) {
                throw new IllegalStateException("No ListView exists.");
            }
            this.mActionsGridView.setWindowAlignmentOffset(0);
            this.mActionsGridView.setWindowAlignmentOffsetPercent(50.0f);
            this.mActionsGridView.setWindowAlignment(0);
            if (this.mSelectorView != null) {
                this.mActionsGridView.setOnScrollListener(new SelectorAnimator(this.mSelectorView, (ViewGroup)this.mActionsGridView));
            }
        }
        this.mActionsGridView.requestFocusFromTouch();
        if (this.mSelectorView != null) {
            this.mActionsGridView.getViewTreeObserver().addOnGlobalFocusChangeListener(new ViewTreeObserver.OnGlobalFocusChangeListener(){
                private boolean mChildFocused;

                public void onGlobalFocusChanged(View oldFocus, View newFocus) {
                    View focusedChild = GuidedActionsStylist.this.mActionsGridView.getFocusedChild();
                    if (focusedChild == null) {
                        GuidedActionsStylist.this.mSelectorView.setVisibility(4);
                        this.mChildFocused = false;
                    } else if (!this.mChildFocused) {
                        this.mChildFocused = true;
                        GuidedActionsStylist.this.mSelectorView.setVisibility(0);
                        GuidedActionsStylist.this.updateSelectorView(focusedChild);
                    }
                }
            });
        }
        Context ctx = this.mMainView.getContext();
        TypedValue val = new TypedValue();
        this.mEnabledChevronAlpha = this.getFloat(ctx, val, R.attr.guidedActionEnabledChevronAlpha);
        this.mDisabledChevronAlpha = this.getFloat(ctx, val, R.attr.guidedActionDisabledChevronAlpha);
        this.mContentWidth = this.getDimension(ctx, val, R.attr.guidedActionContentWidth);
        this.mContentWidthNoIcon = this.getDimension(ctx, val, R.attr.guidedActionContentWidthNoIcon);
        this.mTitleMinLines = this.getInteger(ctx, val, R.attr.guidedActionTitleMinLines);
        this.mTitleMaxLines = this.getInteger(ctx, val, R.attr.guidedActionTitleMaxLines);
        this.mDescriptionMinLines = this.getInteger(ctx, val, R.attr.guidedActionDescriptionMinLines);
        this.mVerticalPadding = this.getDimension(ctx, val, R.attr.guidedActionVerticalPadding);
        this.mDisplayHeight = ((WindowManager)ctx.getSystemService("window")).getDefaultDisplay().getHeight();
        return this.mMainView;
    }

    public VerticalGridView getActionsGridView() {
        return this.mActionsGridView;
    }

    public int onProvideLayoutId() {
        return R.layout.lb_guidedactions;
    }

    public int onProvideItemLayoutId() {
        return R.layout.lb_guidedactions_item;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        View v = inflater.inflate(this.onProvideItemLayoutId(), parent, false);
        return new ViewHolder(v);
    }

    public void onBindViewHolder(ViewHolder vh, GuidedAction action) {
        if (vh.mTitleView != null) {
            vh.mTitleView.setText(action.getTitle());
        }
        if (vh.mDescriptionView != null) {
            vh.mDescriptionView.setText(action.getDescription());
            vh.mDescriptionView.setVisibility(TextUtils.isEmpty((CharSequence)action.getDescription()) ? 8 : 0);
        }
        if (vh.mCheckmarkView != null && vh.mCheckmarkView.getVisibility() != 8) {
            vh.mCheckmarkView.setVisibility(action.isChecked() ? 0 : 4);
        }
        if (vh.mContentView != null) {
            ViewGroup.LayoutParams contentLp = vh.mContentView.getLayoutParams();
            contentLp.width = this.setIcon(vh.mIconView, action) ? this.mContentWidth : this.mContentWidthNoIcon;
            vh.mContentView.setLayoutParams(contentLp);
        }
        if (vh.mChevronView != null) {
            vh.mChevronView.setVisibility(action.hasNext() ? 0 : 4);
            vh.mChevronView.setAlpha(action.isEnabled() ? this.mEnabledChevronAlpha : this.mDisabledChevronAlpha);
        }
        if (action.hasMultilineDescription()) {
            if (vh.mTitleView != null) {
                vh.mTitleView.setMaxLines(this.mTitleMaxLines);
                if (vh.mDescriptionView != null) {
                    vh.mDescriptionView.setMaxHeight(this.getDescriptionMaxHeight(vh.view.getContext(), vh.mTitleView));
                }
            }
        } else {
            if (vh.mTitleView != null) {
                vh.mTitleView.setMaxLines(this.mTitleMinLines);
            }
            if (vh.mDescriptionView != null) {
                vh.mDescriptionView.setMaxLines(this.mDescriptionMinLines);
            }
        }
    }

    public void onAnimateItemFocused(ViewHolder vh, boolean focused) {
    }

    public void onAnimateItemPressed(ViewHolder vh, boolean pressed) {
        int attr2 = pressed ? R.attr.guidedActionPressedAnimation : R.attr.guidedActionUnpressedAnimation;
        GuidedActionsStylist.createAnimator(vh.view, attr2).start();
    }

    public void onAnimateItemChecked(ViewHolder vh, boolean checked) {
        ImageView checkView = vh.mCheckmarkView;
        if (checkView != null) {
            if (checked) {
                checkView.setVisibility(0);
                GuidedActionsStylist.createAnimator((View)checkView, R.attr.guidedActionCheckedAnimation).start();
            } else {
                Animator animator2 = GuidedActionsStylist.createAnimator((View)checkView, R.attr.guidedActionUncheckedAnimation);
                animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter((View)checkView){
                    final /* synthetic */ View val$checkView;
                    {
                        this.val$checkView = view;
                    }

                    public void onAnimationEnd(Animator animation) {
                        this.val$checkView.setVisibility(4);
                    }
                });
                animator2.start();
            }
        }
    }

    @Override
    public void onActivityEnter(@NonNull List<Animator> animators) {
        animators.add(GuidedActionsStylist.createAnimator(this.mMainView, R.attr.guidedActionsEntryAnimation));
    }

    @Override
    public void onActivityExit(@NonNull List<Animator> animators) {
    }

    @Override
    public void onFragmentEnter(@NonNull List<Animator> animators) {
        animators.add(GuidedActionsStylist.createAnimator((View)this.mActionsGridView, R.attr.guidedStepEntryAnimation));
        animators.add(GuidedActionsStylist.createAnimator(this.mSelectorView, R.attr.guidedStepEntryAnimation));
    }

    @Override
    public void onFragmentExit(@NonNull List<Animator> animators) {
        animators.add(GuidedActionsStylist.createAnimator((View)this.mActionsGridView, R.attr.guidedStepExitAnimation));
        animators.add(GuidedActionsStylist.createAnimator(this.mSelectorView, R.attr.guidedStepExitAnimation));
    }

    @Override
    public void onFragmentReenter(@NonNull List<Animator> animators) {
        animators.add(GuidedActionsStylist.createAnimator((View)this.mActionsGridView, R.attr.guidedStepReentryAnimation));
        animators.add(GuidedActionsStylist.createAnimator(this.mSelectorView, R.attr.guidedStepReentryAnimation));
    }

    @Override
    public void onFragmentReturn(@NonNull List<Animator> animators) {
        animators.add(GuidedActionsStylist.createAnimator((View)this.mActionsGridView, R.attr.guidedStepReturnAnimation));
        animators.add(GuidedActionsStylist.createAnimator(this.mSelectorView, R.attr.guidedStepReturnAnimation));
    }

    private void updateSelectorView(View focusedChild) {
        int height = focusedChild.getHeight();
        ViewGroup.LayoutParams lp = this.mSelectorView.getLayoutParams();
        lp.height = height;
        this.mSelectorView.setLayoutParams(lp);
        this.mSelectorView.setAlpha(1.0f);
    }

    private float getFloat(Context ctx, TypedValue typedValue, int attrId) {
        ctx.getTheme().resolveAttribute(attrId, typedValue, true);
        return Float.valueOf(ctx.getResources().getString(typedValue.resourceId)).floatValue();
    }

    private int getInteger(Context ctx, TypedValue typedValue, int attrId) {
        ctx.getTheme().resolveAttribute(attrId, typedValue, true);
        return ctx.getResources().getInteger(typedValue.resourceId);
    }

    private int getDimension(Context ctx, TypedValue typedValue, int attrId) {
        ctx.getTheme().resolveAttribute(attrId, typedValue, true);
        return ctx.getResources().getDimensionPixelSize(typedValue.resourceId);
    }

    private static Animator createAnimator(View v, int attrId) {
        Context ctx = v.getContext();
        TypedValue typedValue = new TypedValue();
        ctx.getTheme().resolveAttribute(attrId, typedValue, true);
        Animator animator2 = AnimatorInflater.loadAnimator((Context)ctx, (int)typedValue.resourceId);
        animator2.setTarget((Object)v);
        return animator2;
    }

    private boolean setIcon(ImageView iconView, GuidedAction action) {
        Drawable icon = null;
        if (iconView != null) {
            Context context = iconView.getContext();
            icon = action.getIcon();
            if (icon != null) {
                iconView.setImageLevel(icon.getLevel());
                iconView.setImageDrawable(icon);
                iconView.setVisibility(0);
            } else {
                iconView.setVisibility(8);
            }
        }
        return icon != null;
    }

    private int getDescriptionMaxHeight(Context context, TextView title) {
        return this.mDisplayHeight - 2 * this.mVerticalPadding - 2 * this.mTitleMaxLines * title.getLineHeight();
    }

    private static class SelectorAnimator
    extends RecyclerView.OnScrollListener {
        private final View mSelectorView;
        private final ViewGroup mParentView;
        private volatile boolean mFadedOut = true;

        SelectorAnimator(View selectorView, ViewGroup parentView) {
            this.mSelectorView = selectorView;
            this.mParentView = parentView;
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            Animator animator2 = null;
            boolean fadingOut = false;
            if (newState == 0) {
                View focusedChild = this.mParentView.getFocusedChild();
                if (focusedChild != null) {
                    int selectorHeight = this.mSelectorView.getHeight();
                    float scaleY = (float)focusedChild.getHeight() / (float)selectorHeight;
                    AnimatorSet animators = (AnimatorSet)GuidedActionsStylist.createAnimator(this.mSelectorView, R.attr.guidedActionsSelectorShowAnimation);
                    if (this.mFadedOut) {
                        this.mSelectorView.setScaleY(scaleY);
                        animator2 = (Animator)animators.getChildAnimations().get(0);
                    } else {
                        ((ObjectAnimator)animators.getChildAnimations().get(1)).setFloatValues(new float[]{scaleY});
                        animator2 = animators;
                    }
                }
            } else {
                animator2 = GuidedActionsStylist.createAnimator(this.mSelectorView, R.attr.guidedActionsSelectorHideAnimation);
                fadingOut = true;
            }
            if (animator2 != null) {
                animator2.addListener((Animator.AnimatorListener)new Listener(fadingOut));
                animator2.start();
            }
        }

        private class Listener
        implements Animator.AnimatorListener {
            private boolean mFadingOut;
            private boolean mCanceled;

            public Listener(boolean fadingOut) {
                this.mFadingOut = fadingOut;
            }

            public void onAnimationStart(Animator animation) {
                if (!this.mFadingOut) {
                    SelectorAnimator.this.mFadedOut = false;
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (!this.mCanceled && this.mFadingOut) {
                    SelectorAnimator.this.mFadedOut = true;
                }
            }

            public void onAnimationCancel(Animator animation) {
                this.mCanceled = true;
            }

            public void onAnimationRepeat(Animator animation) {
            }
        }
    }

    public static class ViewHolder {
        public final View view;
        private View mContentView;
        private TextView mTitleView;
        private TextView mDescriptionView;
        private ImageView mIconView;
        private ImageView mCheckmarkView;
        private ImageView mChevronView;

        public ViewHolder(View v) {
            this.view = v;
            this.mContentView = v.findViewById(R.id.guidedactions_item_content);
            this.mTitleView = (TextView)v.findViewById(R.id.guidedactions_item_title);
            this.mDescriptionView = (TextView)v.findViewById(R.id.guidedactions_item_description);
            this.mIconView = (ImageView)v.findViewById(R.id.guidedactions_item_icon);
            this.mCheckmarkView = (ImageView)v.findViewById(R.id.guidedactions_item_checkmark);
            this.mChevronView = (ImageView)v.findViewById(R.id.guidedactions_item_chevron);
        }

        public View getContentView() {
            return this.mContentView;
        }

        public TextView getTitleView() {
            return this.mTitleView;
        }

        public TextView getDescriptionView() {
            return this.mDescriptionView;
        }

        public ImageView getIconView() {
            return this.mIconView;
        }

        public ImageView getCheckmarkView() {
            return this.mCheckmarkView;
        }

        public ImageView getChevronView() {
            return this.mChevronView;
        }
    }
}

