/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.BaseGridView;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;

public class HorizontalGridView
extends BaseGridView {
    private boolean mFadingLowEdge;
    private boolean mFadingHighEdge;
    private Paint mTempPaint = new Paint();
    private Bitmap mTempBitmapLow;
    private LinearGradient mLowFadeShader;
    private int mLowFadeShaderLength;
    private int mLowFadeShaderOffset;
    private Bitmap mTempBitmapHigh;
    private LinearGradient mHighFadeShader;
    private int mHighFadeShaderLength;
    private int mHighFadeShaderOffset;
    private Rect mTempRect = new Rect();

    public HorizontalGridView(Context context) {
        this(context, null);
    }

    public HorizontalGridView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HorizontalGridView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mLayoutManager.setOrientation(0);
        this.initAttributes(context, attrs);
    }

    protected void initAttributes(Context context, AttributeSet attrs) {
        this.initBaseGridViewAttributes(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.lbHorizontalGridView);
        this.setRowHeight(a);
        this.setNumRows(a.getInt(R.styleable.lbHorizontalGridView_numberOfRows, 1));
        a.recycle();
        this.updateLayerType();
        this.mTempPaint = new Paint();
        this.mTempPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
    }

    void setRowHeight(TypedArray array) {
        TypedValue typedValue = array.peekValue(R.styleable.lbHorizontalGridView_rowHeight);
        if (typedValue != null) {
            int size = array.getLayoutDimension(R.styleable.lbHorizontalGridView_rowHeight, 0);
            this.setRowHeight(size);
        }
    }

    public void setNumRows(int numRows) {
        this.mLayoutManager.setNumRows(numRows);
        this.requestLayout();
    }

    public void setRowHeight(int height) {
        this.mLayoutManager.setRowHeight(height);
        this.requestLayout();
    }

    public final void setFadingLeftEdge(boolean fading) {
        if (this.mFadingLowEdge != fading) {
            this.mFadingLowEdge = fading;
            if (!this.mFadingLowEdge) {
                this.mTempBitmapLow = null;
            }
            this.invalidate();
            this.updateLayerType();
        }
    }

    public final boolean getFadingLeftEdge() {
        return this.mFadingLowEdge;
    }

    public final void setFadingLeftEdgeLength(int fadeLength) {
        if (this.mLowFadeShaderLength != fadeLength) {
            this.mLowFadeShaderLength = fadeLength;
            this.mLowFadeShader = this.mLowFadeShaderLength != 0 ? new LinearGradient(0.0f, 0.0f, (float)this.mLowFadeShaderLength, 0.0f, 0, -16777216, Shader.TileMode.CLAMP) : null;
            this.invalidate();
        }
    }

    public final int getFadingLeftEdgeLength() {
        return this.mLowFadeShaderLength;
    }

    public final void setFadingLeftEdgeOffset(int fadeOffset) {
        if (this.mLowFadeShaderOffset != fadeOffset) {
            this.mLowFadeShaderOffset = fadeOffset;
            this.invalidate();
        }
    }

    public final int getFadingLeftEdgeOffset() {
        return this.mLowFadeShaderOffset;
    }

    public final void setFadingRightEdge(boolean fading) {
        if (this.mFadingHighEdge != fading) {
            this.mFadingHighEdge = fading;
            if (!this.mFadingHighEdge) {
                this.mTempBitmapHigh = null;
            }
            this.invalidate();
            this.updateLayerType();
        }
    }

    public final boolean getFadingRightEdge() {
        return this.mFadingHighEdge;
    }

    public final void setFadingRightEdgeLength(int fadeLength) {
        if (this.mHighFadeShaderLength != fadeLength) {
            this.mHighFadeShaderLength = fadeLength;
            this.mHighFadeShader = this.mHighFadeShaderLength != 0 ? new LinearGradient(0.0f, 0.0f, (float)this.mHighFadeShaderLength, 0.0f, -16777216, 0, Shader.TileMode.CLAMP) : null;
            this.invalidate();
        }
    }

    public final int getFadingRightEdgeLength() {
        return this.mHighFadeShaderLength;
    }

    public final void setFadingRightEdgeOffset(int fadeOffset) {
        if (this.mHighFadeShaderOffset != fadeOffset) {
            this.mHighFadeShaderOffset = fadeOffset;
            this.invalidate();
        }
    }

    public final int getFadingRightEdgeOffset() {
        return this.mHighFadeShaderOffset;
    }

    private boolean needsFadingLowEdge() {
        if (!this.mFadingLowEdge) {
            return false;
        }
        int c = this.getChildCount();
        for (int i = 0; i < c; ++i) {
            View view = this.getChildAt(i);
            if (this.mLayoutManager.getOpticalLeft(view) >= this.getPaddingLeft() - this.mLowFadeShaderOffset) continue;
            return true;
        }
        return false;
    }

    private boolean needsFadingHighEdge() {
        if (!this.mFadingHighEdge) {
            return false;
        }
        int c = this.getChildCount();
        for (int i = c - 1; i >= 0; --i) {
            View view = this.getChildAt(i);
            if (this.mLayoutManager.getOpticalRight(view) <= this.getWidth() - this.getPaddingRight() + this.mHighFadeShaderOffset) continue;
            return true;
        }
        return false;
    }

    private Bitmap getTempBitmapLow() {
        if (this.mTempBitmapLow == null || this.mTempBitmapLow.getWidth() != this.mLowFadeShaderLength || this.mTempBitmapLow.getHeight() != this.getHeight()) {
            this.mTempBitmapLow = Bitmap.createBitmap((int)this.mLowFadeShaderLength, (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        return this.mTempBitmapLow;
    }

    private Bitmap getTempBitmapHigh() {
        if (this.mTempBitmapHigh == null || this.mTempBitmapHigh.getWidth() != this.mHighFadeShaderLength || this.mTempBitmapHigh.getHeight() != this.getHeight()) {
            this.mTempBitmapHigh = Bitmap.createBitmap((int)this.mHighFadeShaderLength, (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        return this.mTempBitmapHigh;
    }

    public void draw(Canvas canvas) {
        int tmpSave;
        Bitmap tempBitmap;
        boolean needsFadingLow = this.needsFadingLowEdge();
        boolean needsFadingHigh = this.needsFadingHighEdge();
        if (!needsFadingLow) {
            this.mTempBitmapLow = null;
        }
        if (!needsFadingHigh) {
            this.mTempBitmapHigh = null;
        }
        if (!needsFadingLow && !needsFadingHigh) {
            super.draw(canvas);
            return;
        }
        int lowEdge = this.mFadingLowEdge ? this.getPaddingLeft() - this.mLowFadeShaderOffset - this.mLowFadeShaderLength : 0;
        int highEdge = this.mFadingHighEdge ? this.getWidth() - this.getPaddingRight() + this.mHighFadeShaderOffset + this.mHighFadeShaderLength : this.getWidth();
        int save = canvas.save();
        canvas.clipRect(lowEdge + (this.mFadingLowEdge ? this.mLowFadeShaderLength : 0), 0, highEdge - (this.mFadingHighEdge ? this.mHighFadeShaderLength : 0), this.getHeight());
        super.draw(canvas);
        canvas.restoreToCount(save);
        Canvas tmpCanvas = new Canvas();
        this.mTempRect.top = 0;
        this.mTempRect.bottom = this.getHeight();
        if (needsFadingLow && this.mLowFadeShaderLength > 0) {
            tempBitmap = this.getTempBitmapLow();
            tempBitmap.eraseColor(0);
            tmpCanvas.setBitmap(tempBitmap);
            tmpSave = tmpCanvas.save();
            tmpCanvas.clipRect(0, 0, this.mLowFadeShaderLength, this.getHeight());
            tmpCanvas.translate((float)(-lowEdge), 0.0f);
            super.draw(tmpCanvas);
            tmpCanvas.restoreToCount(tmpSave);
            this.mTempPaint.setShader((Shader)this.mLowFadeShader);
            tmpCanvas.drawRect(0.0f, 0.0f, (float)this.mLowFadeShaderLength, (float)this.getHeight(), this.mTempPaint);
            this.mTempRect.left = 0;
            this.mTempRect.right = this.mLowFadeShaderLength;
            canvas.translate((float)lowEdge, 0.0f);
            canvas.drawBitmap(tempBitmap, this.mTempRect, this.mTempRect, null);
            canvas.translate((float)(-lowEdge), 0.0f);
        }
        if (needsFadingHigh && this.mHighFadeShaderLength > 0) {
            tempBitmap = this.getTempBitmapHigh();
            tempBitmap.eraseColor(0);
            tmpCanvas.setBitmap(tempBitmap);
            tmpSave = tmpCanvas.save();
            tmpCanvas.clipRect(0, 0, this.mHighFadeShaderLength, this.getHeight());
            tmpCanvas.translate((float)(-(highEdge - this.mHighFadeShaderLength)), 0.0f);
            super.draw(tmpCanvas);
            tmpCanvas.restoreToCount(tmpSave);
            this.mTempPaint.setShader((Shader)this.mHighFadeShader);
            tmpCanvas.drawRect(0.0f, 0.0f, (float)this.mHighFadeShaderLength, (float)this.getHeight(), this.mTempPaint);
            this.mTempRect.left = 0;
            this.mTempRect.right = this.mHighFadeShaderLength;
            canvas.translate((float)(highEdge - this.mHighFadeShaderLength), 0.0f);
            canvas.drawBitmap(tempBitmap, this.mTempRect, this.mTempRect, null);
            canvas.translate((float)(-(highEdge - this.mHighFadeShaderLength)), 0.0f);
        }
    }

    private void updateLayerType() {
        if (this.mFadingLowEdge || this.mFadingHighEdge) {
            this.setLayerType(2, null);
            this.setWillNotDraw(false);
        } else {
            this.setLayerType(0, null);
            this.setWillNotDraw(true);
        }
    }
}

