/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.BaseCardView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

public class ImageCardView
extends BaseCardView {
    private ImageView mImageView;
    private View mInfoArea;
    private TextView mTitleView;
    private TextView mContentView;
    private ImageView mBadgeImage;
    private boolean mAttachedToWindow;

    public ImageCardView(Context context) {
        this(context, null);
    }

    public ImageCardView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.imageCardViewStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageCardView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View v = inflater.inflate(R.layout.lb_image_card_view, (ViewGroup)this);
        this.mImageView = (ImageView)v.findViewById(R.id.main_image);
        this.mImageView.setVisibility(4);
        this.mInfoArea = v.findViewById(R.id.info_field);
        this.mTitleView = (TextView)v.findViewById(R.id.title_text);
        this.mContentView = (TextView)v.findViewById(R.id.content_text);
        this.mBadgeImage = (ImageView)v.findViewById(R.id.extra_badge);
        if (this.mInfoArea != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.lbImageCardView, defStyle, 0);
            try {
                this.setInfoAreaBackground(a.getDrawable(R.styleable.lbImageCardView_infoAreaBackground));
            }
            finally {
                a.recycle();
            }
        }
    }

    public final ImageView getMainImageView() {
        return this.mImageView;
    }

    public void setMainImageAdjustViewBounds(boolean adjustViewBounds) {
        if (this.mImageView != null) {
            this.mImageView.setAdjustViewBounds(adjustViewBounds);
        }
    }

    public void setMainImageScaleType(ImageView.ScaleType scaleType) {
        if (this.mImageView != null) {
            this.mImageView.setScaleType(scaleType);
        }
    }

    public void setMainImage(Drawable drawable2) {
        this.setMainImage(drawable2, true);
    }

    public void setMainImage(Drawable drawable2, boolean fade) {
        if (this.mImageView == null) {
            return;
        }
        this.mImageView.setImageDrawable(drawable2);
        if (drawable2 == null) {
            this.mImageView.animate().cancel();
            this.mImageView.setAlpha(1.0f);
            this.mImageView.setVisibility(4);
        } else {
            this.mImageView.setVisibility(0);
            if (fade) {
                this.fadeIn();
            } else {
                this.mImageView.animate().cancel();
                this.mImageView.setAlpha(1.0f);
            }
        }
    }

    public void setMainImageDimensions(int width, int height) {
        ViewGroup.LayoutParams lp = this.mImageView.getLayoutParams();
        lp.width = width;
        lp.height = height;
        this.mImageView.setLayoutParams(lp);
    }

    public Drawable getMainImage() {
        if (this.mImageView == null) {
            return null;
        }
        return this.mImageView.getDrawable();
    }

    public Drawable getInfoAreaBackground() {
        if (this.mInfoArea != null) {
            return this.mInfoArea.getBackground();
        }
        return null;
    }

    public void setInfoAreaBackground(Drawable drawable2) {
        if (this.mInfoArea != null) {
            this.mInfoArea.setBackground(drawable2);
        }
    }

    public void setInfoAreaBackgroundColor(@ColorInt int color2) {
        if (this.mInfoArea != null) {
            this.mInfoArea.setBackgroundColor(color2);
        }
    }

    public void setTitleText(CharSequence text) {
        if (this.mTitleView == null) {
            return;
        }
        this.mTitleView.setText(text);
    }

    public CharSequence getTitleText() {
        if (this.mTitleView == null) {
            return null;
        }
        return this.mTitleView.getText();
    }

    public void setContentText(CharSequence text) {
        if (this.mContentView == null) {
            return;
        }
        this.mContentView.setText(text);
    }

    public CharSequence getContentText() {
        if (this.mContentView == null) {
            return null;
        }
        return this.mContentView.getText();
    }

    public void setBadgeImage(Drawable drawable2) {
        if (this.mBadgeImage == null) {
            return;
        }
        this.mBadgeImage.setImageDrawable(drawable2);
        if (drawable2 != null && this.mContentView != null && this.mContentView.getVisibility() != 8) {
            this.mBadgeImage.setVisibility(0);
        } else {
            this.mBadgeImage.setVisibility(8);
        }
    }

    public Drawable getBadgeImage() {
        if (this.mBadgeImage == null) {
            return null;
        }
        return this.mBadgeImage.getDrawable();
    }

    private void fadeIn() {
        this.mImageView.setAlpha(0.0f);
        if (this.mAttachedToWindow) {
            this.mImageView.animate().alpha(1.0f).setDuration((long)this.mImageView.getResources().getInteger(0x10E0000));
        }
    }

    public boolean hasOverlappingRendering() {
        return false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttachedToWindow = true;
        if (this.mImageView.getAlpha() == 0.0f) {
            this.fadeIn();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        this.mAttachedToWindow = false;
        this.mImageView.animate().cancel();
        this.mImageView.setAlpha(1.0f);
        super.onDetachedFromWindow();
    }
}

