/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.support.v17.leanback.widget.FacetProvider;
import android.support.v17.leanback.widget.FacetProviderAdapter;
import android.support.v17.leanback.widget.FocusHighlightHandler;
import android.support.v17.leanback.widget.ObjectAdapter;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.PresenterSelector;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;

public class ItemBridgeAdapter
extends RecyclerView.Adapter
implements FacetProviderAdapter {
    private static final String TAG = "ItemBridgeAdapter";
    private static final boolean DEBUG = false;
    private ObjectAdapter mAdapter;
    private Wrapper mWrapper;
    private PresenterSelector mPresenterSelector;
    private FocusHighlightHandler mFocusHighlight;
    private AdapterListener mAdapterListener;
    private ArrayList<Presenter> mPresenters = new ArrayList();
    private ObjectAdapter.DataObserver mDataObserver = new ObjectAdapter.DataObserver(){

        @Override
        public void onChanged() {
            ItemBridgeAdapter.this.notifyDataSetChanged();
        }

        @Override
        public void onItemRangeChanged(int positionStart, int itemCount) {
            ItemBridgeAdapter.this.notifyItemRangeChanged(positionStart, itemCount);
        }

        @Override
        public void onItemRangeInserted(int positionStart, int itemCount) {
            ItemBridgeAdapter.this.notifyItemRangeInserted(positionStart, itemCount);
        }

        @Override
        public void onItemRangeRemoved(int positionStart, int itemCount) {
            ItemBridgeAdapter.this.notifyItemRangeRemoved(positionStart, itemCount);
        }
    };

    public ItemBridgeAdapter(ObjectAdapter adapter, PresenterSelector presenterSelector) {
        this.setAdapter(adapter);
        this.mPresenterSelector = presenterSelector;
    }

    public ItemBridgeAdapter(ObjectAdapter adapter) {
        this(adapter, null);
    }

    public ItemBridgeAdapter() {
    }

    public void setAdapter(ObjectAdapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterObserver(this.mDataObserver);
        }
        this.mAdapter = adapter;
        if (this.mAdapter == null) {
            return;
        }
        this.mAdapter.registerObserver(this.mDataObserver);
        if (this.hasStableIds() != this.mAdapter.hasStableIds()) {
            this.setHasStableIds(this.mAdapter.hasStableIds());
        }
    }

    public void setWrapper(Wrapper wrapper) {
        this.mWrapper = wrapper;
    }

    public Wrapper getWrapper() {
        return this.mWrapper;
    }

    void setFocusHighlight(FocusHighlightHandler listener) {
        this.mFocusHighlight = listener;
    }

    public void clear() {
        this.setAdapter(null);
    }

    public void setPresenterMapper(ArrayList<Presenter> presenters) {
        this.mPresenters = presenters;
    }

    public ArrayList<Presenter> getPresenterMapper() {
        return this.mPresenters;
    }

    public int getItemCount() {
        return this.mAdapter.size();
    }

    public int getItemViewType(int position) {
        Object item;
        PresenterSelector presenterSelector = this.mPresenterSelector != null ? this.mPresenterSelector : this.mAdapter.getPresenterSelector();
        Presenter presenter = presenterSelector.getPresenter(item = this.mAdapter.get(position));
        int type = this.mPresenters.indexOf(presenter);
        if (type < 0) {
            this.mPresenters.add(presenter);
            type = this.mPresenters.indexOf(presenter);
            this.onAddPresenter(presenter, type);
            if (this.mAdapterListener != null) {
                this.mAdapterListener.onAddPresenter(presenter, type);
            }
        }
        return type;
    }

    protected void onAddPresenter(Presenter presenter, int type) {
    }

    protected void onCreate(ViewHolder viewHolder) {
    }

    protected void onBind(ViewHolder viewHolder) {
    }

    protected void onUnbind(ViewHolder viewHolder) {
    }

    protected void onAttachedToWindow(ViewHolder viewHolder) {
    }

    protected void onDetachedFromWindow(ViewHolder viewHolder) {
    }

    public final RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View presenterView;
        Presenter.ViewHolder presenterVh;
        View view;
        Presenter presenter = this.mPresenters.get(viewType);
        if (this.mWrapper != null) {
            view = this.mWrapper.createWrapper((View)parent);
            presenterVh = presenter.onCreateViewHolder(parent);
            this.mWrapper.wrap(view, presenterVh.view);
        } else {
            presenterVh = presenter.onCreateViewHolder(parent);
            view = presenterVh.view;
        }
        ViewHolder viewHolder = new ViewHolder(presenter, view, presenterVh);
        this.onCreate(viewHolder);
        if (this.mAdapterListener != null) {
            this.mAdapterListener.onCreate(viewHolder);
        }
        if ((presenterView = viewHolder.mHolder.view) != null) {
            viewHolder.mFocusChangeListener.mChainedListener = presenterView.getOnFocusChangeListener();
            presenterView.setOnFocusChangeListener((View.OnFocusChangeListener)viewHolder.mFocusChangeListener);
        }
        if (this.mFocusHighlight != null) {
            this.mFocusHighlight.onInitializeView(view);
        }
        return viewHolder;
    }

    public void setAdapterListener(AdapterListener listener) {
        this.mAdapterListener = listener;
    }

    public final void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        ViewHolder viewHolder = (ViewHolder)holder;
        viewHolder.mItem = this.mAdapter.get(position);
        viewHolder.mPresenter.onBindViewHolder(viewHolder.mHolder, viewHolder.mItem);
        this.onBind(viewHolder);
        if (this.mAdapterListener != null) {
            this.mAdapterListener.onBind(viewHolder);
        }
    }

    public final void onViewRecycled(RecyclerView.ViewHolder holder) {
        ViewHolder viewHolder = (ViewHolder)holder;
        viewHolder.mPresenter.onUnbindViewHolder(viewHolder.mHolder);
        this.onUnbind(viewHolder);
        if (this.mAdapterListener != null) {
            this.mAdapterListener.onUnbind(viewHolder);
        }
        viewHolder.mItem = null;
    }

    public final void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        ViewHolder viewHolder = (ViewHolder)holder;
        this.onAttachedToWindow(viewHolder);
        if (this.mAdapterListener != null) {
            this.mAdapterListener.onAttachedToWindow(viewHolder);
        }
        viewHolder.mPresenter.onViewAttachedToWindow(viewHolder.mHolder);
    }

    public final void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        ViewHolder viewHolder = (ViewHolder)holder;
        viewHolder.mPresenter.onViewDetachedFromWindow(viewHolder.mHolder);
        this.onDetachedFromWindow(viewHolder);
        if (this.mAdapterListener != null) {
            this.mAdapterListener.onDetachedFromWindow(viewHolder);
        }
    }

    public long getItemId(int position) {
        return this.mAdapter.getId(position);
    }

    @Override
    public FacetProvider getFacetProvider(int type) {
        return this.mPresenters.get(type);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder
    implements FacetProvider {
        final Presenter mPresenter;
        final Presenter.ViewHolder mHolder;
        final OnFocusChangeListener mFocusChangeListener;
        Object mItem;
        Object mExtraObject;

        public final Presenter getPresenter() {
            return this.mPresenter;
        }

        public final Presenter.ViewHolder getViewHolder() {
            return this.mHolder;
        }

        public final Object getItem() {
            return this.mItem;
        }

        public final Object getExtraObject() {
            return this.mExtraObject;
        }

        public void setExtraObject(Object object) {
            this.mExtraObject = object;
        }

        @Override
        public Object getFacet(Class<?> facetClass) {
            return this.mHolder.getFacet(facetClass);
        }

        ViewHolder(Presenter presenter, View view, Presenter.ViewHolder holder) {
            super(view);
            this.mFocusChangeListener = new OnFocusChangeListener();
            this.mPresenter = presenter;
            this.mHolder = holder;
        }
    }

    final class OnFocusChangeListener
    implements View.OnFocusChangeListener {
        View.OnFocusChangeListener mChainedListener;

        OnFocusChangeListener() {
        }

        public void onFocusChange(View view, boolean hasFocus) {
            if (ItemBridgeAdapter.this.mWrapper != null) {
                view = (View)view.getParent();
            }
            if (ItemBridgeAdapter.this.mFocusHighlight != null) {
                ItemBridgeAdapter.this.mFocusHighlight.onItemFocused(view, hasFocus);
            }
            if (this.mChainedListener != null) {
                this.mChainedListener.onFocusChange(view, hasFocus);
            }
        }
    }

    public static abstract class Wrapper {
        public abstract View createWrapper(View var1);

        public abstract void wrap(View var1, View var2);
    }

    public static class AdapterListener {
        public void onAddPresenter(Presenter presenter, int type) {
        }

        public void onCreate(ViewHolder viewHolder) {
        }

        public void onBind(ViewHolder viewHolder) {
        }

        public void onUnbind(ViewHolder viewHolder) {
        }

        public void onAttachedToWindow(ViewHolder viewHolder) {
        }

        public void onDetachedFromWindow(ViewHolder viewHolder) {
        }
    }
}

