/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.ArrayList;

class PersistentFocusWrapper
extends FrameLayout {
    private static final String TAG = "PersistentFocusWrapper";
    private static final boolean DEBUG = false;
    private int mSelectedPosition = -1;
    private boolean mPersistFocusVertical = true;

    public PersistentFocusWrapper(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PersistentFocusWrapper(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    int getGrandChildCount() {
        ViewGroup wrapper = (ViewGroup)this.getChildAt(0);
        return wrapper == null ? 0 : wrapper.getChildCount();
    }

    public void clearSelection() {
        this.mSelectedPosition = -1;
        if (this.hasFocus()) {
            this.clearFocus();
        }
    }

    public void persistFocusVertical() {
        this.mPersistFocusVertical = true;
    }

    public void persistFocusHorizontal() {
        this.mPersistFocusVertical = false;
    }

    private boolean shouldPersistFocusFromDirection(int direction) {
        return this.mPersistFocusVertical && (direction == 33 || direction == 130) || !this.mPersistFocusVertical && (direction == 17 || direction == 66);
    }

    public void addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        if (this.hasFocus() || this.getGrandChildCount() == 0 || !this.shouldPersistFocusFromDirection(direction)) {
            super.addFocusables(views, direction, focusableMode);
        } else {
            views.add((View)this);
        }
    }

    public void requestChildFocus(View child, View focused) {
        View view;
        super.requestChildFocus(child, focused);
        for (view = focused; view != null && view.getParent() != child; view = (View)view.getParent()) {
        }
        this.mSelectedPosition = view == null ? -1 : ((ViewGroup)child).indexOfChild(view);
    }

    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        ViewGroup wrapper = (ViewGroup)this.getChildAt(0);
        if (wrapper != null && this.mSelectedPosition >= 0 && this.mSelectedPosition < this.getGrandChildCount() && wrapper.getChildAt(this.mSelectedPosition).requestFocus(direction, previouslyFocusedRect)) {
            return true;
        }
        return super.requestFocus(direction, previouslyFocusedRect);
    }

    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.mSelectedPosition = this.mSelectedPosition;
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        this.mSelectedPosition = ((SavedState)state).mSelectedPosition;
        super.onRestoreInstanceState(savedState.getSuperState());
    }

    static class SavedState
    extends View.BaseSavedState {
        int mSelectedPosition;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcel in) {
            super(in);
            this.mSelectedPosition = in.readInt();
        }

        SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mSelectedPosition);
        }
    }
}

