/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.Action;
import android.support.v17.leanback.widget.ControlBarPresenter;
import android.support.v17.leanback.widget.ControlButtonPresenterSelector;
import android.support.v17.leanback.widget.ObjectAdapter;
import android.support.v17.leanback.widget.OnActionClickedListener;
import android.support.v17.leanback.widget.PlaybackControlsPresenter;
import android.support.v17.leanback.widget.PlaybackControlsRow;
import android.support.v17.leanback.widget.PlaybackControlsRowView;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.RoundedRectHelper;
import android.support.v17.leanback.widget.RowPresenter;
import android.support.v17.leanback.widget.ShadowHelper;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

public class PlaybackControlsRowPresenter
extends RowPresenter {
    private int mBackgroundColor = 0;
    private boolean mBackgroundColorSet;
    private int mProgressColor = 0;
    private boolean mProgressColorSet;
    private boolean mSecondaryActionsHidden;
    private Presenter mDescriptionPresenter;
    private PlaybackControlsPresenter mPlaybackControlsPresenter;
    private ControlBarPresenter mSecondaryControlsPresenter;
    private OnActionClickedListener mOnActionClickedListener;
    private static float sShadowZ;
    private final ControlBarPresenter.OnControlSelectedListener mOnControlSelectedListener = new ControlBarPresenter.OnControlSelectedListener(){

        @Override
        public void onControlSelected(Presenter.ViewHolder itemViewHolder, Object item, ControlBarPresenter.BoundData data) {
            ViewHolder vh = ((BoundData)data).mRowViewHolder;
            if (vh.mSelectedViewHolder != itemViewHolder || vh.mSelectedItem != item) {
                vh.mSelectedViewHolder = itemViewHolder;
                vh.mSelectedItem = item;
                vh.dispatchItemSelection();
            }
        }
    };
    private final ControlBarPresenter.OnControlClickedListener mOnControlClickedListener = new ControlBarPresenter.OnControlClickedListener(){

        @Override
        public void onControlClicked(Presenter.ViewHolder itemViewHolder, Object item, ControlBarPresenter.BoundData data) {
            ViewHolder vh = ((BoundData)data).mRowViewHolder;
            if (vh.getOnItemViewClickedListener() != null) {
                vh.getOnItemViewClickedListener().onItemClicked(itemViewHolder, item, vh, vh.getRow());
            }
            if (PlaybackControlsRowPresenter.this.mOnActionClickedListener != null && item instanceof Action) {
                PlaybackControlsRowPresenter.this.mOnActionClickedListener.onActionClicked((Action)item);
            }
        }
    };

    public PlaybackControlsRowPresenter(Presenter descriptionPresenter) {
        this.setHeaderPresenter(null);
        this.setSelectEffectEnabled(false);
        this.mDescriptionPresenter = descriptionPresenter;
        this.mPlaybackControlsPresenter = new PlaybackControlsPresenter(R.layout.lb_playback_controls);
        this.mSecondaryControlsPresenter = new ControlBarPresenter(R.layout.lb_control_bar);
        this.mPlaybackControlsPresenter.setOnControlSelectedListener(this.mOnControlSelectedListener);
        this.mSecondaryControlsPresenter.setOnControlSelectedListener(this.mOnControlSelectedListener);
        this.mPlaybackControlsPresenter.setOnControlClickedListener(this.mOnControlClickedListener);
        this.mSecondaryControlsPresenter.setOnControlClickedListener(this.mOnControlClickedListener);
    }

    public PlaybackControlsRowPresenter() {
        this(null);
    }

    public void setOnActionClickedListener(OnActionClickedListener listener) {
        this.mOnActionClickedListener = listener;
    }

    public OnActionClickedListener getOnActionClickedListener() {
        return this.mOnActionClickedListener;
    }

    public void setBackgroundColor(@ColorInt int color2) {
        this.mBackgroundColor = color2;
        this.mBackgroundColorSet = true;
    }

    @ColorInt
    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setProgressColor(@ColorInt int color2) {
        this.mProgressColor = color2;
        this.mProgressColorSet = true;
    }

    @ColorInt
    public int getProgressColor() {
        return this.mProgressColor;
    }

    public void setSecondaryActionsHidden(boolean hidden) {
        this.mSecondaryActionsHidden = hidden;
    }

    public boolean areSecondaryActionsHidden() {
        return this.mSecondaryActionsHidden;
    }

    public void showBottomSpace(ViewHolder vh, boolean show) {
        vh.mBottomSpacer.setVisibility(show ? 0 : 8);
    }

    public void showPrimaryActions(ViewHolder vh) {
        this.mPlaybackControlsPresenter.showPrimaryActions(vh.mControlsVh);
        this.mPlaybackControlsPresenter.resetFocus(vh.mControlsVh);
    }

    private int getDefaultBackgroundColor(Context context) {
        TypedValue outValue = new TypedValue();
        if (context.getTheme().resolveAttribute(R.attr.defaultBrandColor, outValue, true)) {
            return context.getResources().getColor(outValue.resourceId);
        }
        return context.getResources().getColor(R.color.lb_default_brand_color);
    }

    private int getDefaultProgressColor(Context context) {
        TypedValue outValue = new TypedValue();
        if (context.getTheme().resolveAttribute(R.attr.playbackProgressPrimaryColor, outValue, true)) {
            return context.getResources().getColor(outValue.resourceId);
        }
        return context.getResources().getColor(R.color.lb_playback_progress_color_no_theme);
    }

    @Override
    protected RowPresenter.ViewHolder createRowViewHolder(ViewGroup parent) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.lb_playback_controls_row, parent, false);
        ViewHolder vh = new ViewHolder(v, this.mDescriptionPresenter);
        this.initRow(vh);
        return vh;
    }

    private void initRow(final ViewHolder vh) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)vh.mControlsDock.getLayoutParams();
        vh.mControlsDockMarginStart = lp.getMarginStart();
        vh.mControlsDockMarginEnd = lp.getMarginEnd();
        vh.mControlsVh = (PlaybackControlsPresenter.ViewHolder)this.mPlaybackControlsPresenter.onCreateViewHolder(vh.mControlsDock);
        this.mPlaybackControlsPresenter.setProgressColor(vh.mControlsVh, this.mProgressColorSet ? this.mProgressColor : this.getDefaultProgressColor(vh.mControlsDock.getContext()));
        this.mPlaybackControlsPresenter.setBackgroundColor(vh.mControlsVh, this.mBackgroundColorSet ? this.mBackgroundColor : this.getDefaultBackgroundColor(vh.view.getContext()));
        vh.mControlsDock.addView(vh.mControlsVh.view);
        vh.mSecondaryControlsVh = this.mSecondaryControlsPresenter.onCreateViewHolder(vh.mSecondaryControlsDock);
        if (!this.mSecondaryActionsHidden) {
            vh.mSecondaryControlsDock.addView(vh.mSecondaryControlsVh.view);
        }
        ((PlaybackControlsRowView)vh.view).setOnUnhandledKeyListener(new PlaybackControlsRowView.OnUnhandledKeyListener(){

            @Override
            public boolean onUnhandledKey(KeyEvent event) {
                return vh.getOnKeyListener() != null && vh.getOnKeyListener().onKey(vh.view, event.getKeyCode(), event);
            }
        });
    }

    @Override
    protected void onBindRowViewHolder(RowPresenter.ViewHolder holder, Object item) {
        super.onBindRowViewHolder(holder, item);
        ViewHolder vh = (ViewHolder)holder;
        PlaybackControlsRow row = (PlaybackControlsRow)vh.getRow();
        this.mPlaybackControlsPresenter.enableSecondaryActions(this.mSecondaryActionsHidden);
        if (row.getItem() == null) {
            vh.mDescriptionDock.setVisibility(8);
            vh.mSpacer.setVisibility(8);
        } else {
            vh.mDescriptionDock.setVisibility(0);
            if (vh.mDescriptionViewHolder != null) {
                this.mDescriptionPresenter.onBindViewHolder(vh.mDescriptionViewHolder, row.getItem());
            }
            vh.mSpacer.setVisibility(0);
        }
        if (row.getImageDrawable() == null || row.getItem() == null) {
            vh.mImageView.setImageDrawable(null);
            this.updateCardLayout(vh, -2);
        } else {
            vh.mImageView.setImageDrawable(row.getImageDrawable());
            this.updateCardLayout(vh, vh.mImageView.getLayoutParams().height);
        }
        vh.mControlsBoundData.adapter = row.getPrimaryActionsAdapter();
        vh.mControlsBoundData.secondaryActionsAdapter = row.getSecondaryActionsAdapter();
        vh.mControlsBoundData.presenter = vh.getPresenter(true);
        vh.mControlsBoundData.mRowViewHolder = vh;
        this.mPlaybackControlsPresenter.onBindViewHolder(vh.mControlsVh, vh.mControlsBoundData);
        vh.mSecondaryBoundData.adapter = row.getSecondaryActionsAdapter();
        vh.mSecondaryBoundData.presenter = vh.getPresenter(false);
        vh.mSecondaryBoundData.mRowViewHolder = vh;
        this.mSecondaryControlsPresenter.onBindViewHolder(vh.mSecondaryControlsVh, vh.mSecondaryBoundData);
        this.mPlaybackControlsPresenter.setTotalTime(vh.mControlsVh, row.getTotalTime());
        this.mPlaybackControlsPresenter.setCurrentTime(vh.mControlsVh, row.getCurrentTime());
        this.mPlaybackControlsPresenter.setSecondaryProgress(vh.mControlsVh, row.getBufferedProgress());
        row.setOnPlaybackStateChangedListener(vh.mListener);
    }

    private void updateCardLayout(ViewHolder vh, int height) {
        ViewGroup.LayoutParams lp = vh.mCardRightPanel.getLayoutParams();
        lp.height = height;
        vh.mCardRightPanel.setLayoutParams(lp);
        ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)vh.mControlsDock.getLayoutParams();
        LinearLayout.LayoutParams llp = (LinearLayout.LayoutParams)vh.mDescriptionDock.getLayoutParams();
        if (height == -2) {
            llp.height = -2;
            mlp.setMarginStart(0);
            mlp.setMarginEnd(0);
            vh.mCard.setBackground(null);
            vh.setOutline((View)vh.mControlsDock);
            this.mPlaybackControlsPresenter.enableTimeMargins(vh.mControlsVh, true);
        } else {
            llp.height = 0;
            llp.weight = 1.0f;
            mlp.setMarginStart(vh.mControlsDockMarginStart);
            mlp.setMarginEnd(vh.mControlsDockMarginEnd);
            vh.mCard.setBackgroundColor(this.mBackgroundColorSet ? this.mBackgroundColor : this.getDefaultBackgroundColor(vh.mCard.getContext()));
            vh.setOutline((View)vh.mCard);
            this.mPlaybackControlsPresenter.enableTimeMargins(vh.mControlsVh, false);
        }
        vh.mDescriptionDock.setLayoutParams((ViewGroup.LayoutParams)llp);
        vh.mControlsDock.setLayoutParams((ViewGroup.LayoutParams)mlp);
    }

    @Override
    protected void onUnbindRowViewHolder(RowPresenter.ViewHolder holder) {
        ViewHolder vh = (ViewHolder)holder;
        PlaybackControlsRow row = (PlaybackControlsRow)vh.getRow();
        if (vh.mDescriptionViewHolder != null) {
            this.mDescriptionPresenter.onUnbindViewHolder(vh.mDescriptionViewHolder);
        }
        this.mPlaybackControlsPresenter.onUnbindViewHolder(vh.mControlsVh);
        this.mSecondaryControlsPresenter.onUnbindViewHolder(vh.mSecondaryControlsVh);
        row.setOnPlaybackStateChangedListener(null);
        super.onUnbindRowViewHolder(holder);
    }

    @Override
    protected void onRowViewSelected(RowPresenter.ViewHolder vh, boolean selected) {
        super.onRowViewSelected(vh, selected);
        if (selected) {
            ((ViewHolder)vh).dispatchItemSelection();
        }
    }

    @Override
    protected void onRowViewAttachedToWindow(RowPresenter.ViewHolder vh) {
        super.onRowViewAttachedToWindow(vh);
        if (this.mDescriptionPresenter != null) {
            this.mDescriptionPresenter.onViewAttachedToWindow(((ViewHolder)vh).mDescriptionViewHolder);
        }
    }

    @Override
    protected void onRowViewDetachedFromWindow(RowPresenter.ViewHolder vh) {
        super.onRowViewDetachedFromWindow(vh);
        if (this.mDescriptionPresenter != null) {
            this.mDescriptionPresenter.onViewDetachedFromWindow(((ViewHolder)vh).mDescriptionViewHolder);
        }
    }

    public class ViewHolder
    extends RowPresenter.ViewHolder {
        public final Presenter.ViewHolder mDescriptionViewHolder;
        final ViewGroup mCard;
        final ViewGroup mCardRightPanel;
        final ImageView mImageView;
        final ViewGroup mDescriptionDock;
        final ViewGroup mControlsDock;
        final ViewGroup mSecondaryControlsDock;
        final View mSpacer;
        final View mBottomSpacer;
        View mBgView;
        int mControlsDockMarginStart;
        int mControlsDockMarginEnd;
        PlaybackControlsPresenter.ViewHolder mControlsVh;
        Presenter.ViewHolder mSecondaryControlsVh;
        BoundData mControlsBoundData;
        BoundData mSecondaryBoundData;
        Presenter.ViewHolder mSelectedViewHolder;
        Object mSelectedItem;
        final PlaybackControlsRow.OnPlaybackStateChangedListener mListener;

        ViewHolder(View rootView, Presenter descriptionPresenter) {
            super(rootView);
            this.mControlsBoundData = new BoundData();
            this.mSecondaryBoundData = new BoundData();
            this.mListener = new PlaybackControlsRow.OnPlaybackStateChangedListener(){

                @Override
                public void onCurrentTimeChanged(int ms) {
                    PlaybackControlsRowPresenter.this.mPlaybackControlsPresenter.setCurrentTime(ViewHolder.this.mControlsVh, ms);
                }

                @Override
                public void onBufferedProgressChanged(int ms) {
                    PlaybackControlsRowPresenter.this.mPlaybackControlsPresenter.setSecondaryProgress(ViewHolder.this.mControlsVh, ms);
                }
            };
            this.mCard = (ViewGroup)rootView.findViewById(R.id.controls_card);
            this.mCardRightPanel = (ViewGroup)rootView.findViewById(R.id.controls_card_right_panel);
            this.mImageView = (ImageView)rootView.findViewById(R.id.image);
            this.mDescriptionDock = (ViewGroup)rootView.findViewById(R.id.description_dock);
            this.mControlsDock = (ViewGroup)rootView.findViewById(R.id.controls_dock);
            this.mSecondaryControlsDock = (ViewGroup)rootView.findViewById(R.id.secondary_controls_dock);
            this.mSpacer = rootView.findViewById(R.id.spacer);
            this.mBottomSpacer = rootView.findViewById(R.id.bottom_spacer);
            Presenter.ViewHolder viewHolder = this.mDescriptionViewHolder = descriptionPresenter == null ? null : descriptionPresenter.onCreateViewHolder(this.mDescriptionDock);
            if (this.mDescriptionViewHolder != null) {
                this.mDescriptionDock.addView(this.mDescriptionViewHolder.view);
            }
        }

        void dispatchItemSelection() {
            if (!this.isSelected()) {
                return;
            }
            if (this.mSelectedViewHolder == null) {
                if (this.getOnItemViewSelectedListener() != null) {
                    this.getOnItemViewSelectedListener().onItemSelected(null, null, this, this.getRow());
                }
            } else if (this.getOnItemViewSelectedListener() != null) {
                this.getOnItemViewSelectedListener().onItemSelected(this.mSelectedViewHolder, this.mSelectedItem, this, this.getRow());
            }
        }

        Presenter getPresenter(boolean primary) {
            ObjectAdapter adapter;
            ObjectAdapter objectAdapter = adapter = primary ? ((PlaybackControlsRow)this.getRow()).getPrimaryActionsAdapter() : ((PlaybackControlsRow)this.getRow()).getSecondaryActionsAdapter();
            if (adapter == null) {
                return null;
            }
            if (adapter.getPresenterSelector() instanceof ControlButtonPresenterSelector) {
                ControlButtonPresenterSelector selector = (ControlButtonPresenterSelector)adapter.getPresenterSelector();
                return primary ? selector.getPrimaryPresenter() : selector.getSecondaryPresenter();
            }
            return adapter.getPresenter(adapter.size() > 0 ? adapter.get(0) : null);
        }

        void setOutline(View view) {
            if (this.mBgView != null) {
                RoundedRectHelper.getInstance().setClipToRoundedOutline(this.mBgView, false);
                ShadowHelper.getInstance().setZ(this.mBgView, 0.0f);
            }
            this.mBgView = view;
            RoundedRectHelper.getInstance().setClipToRoundedOutline(view, true);
            if (sShadowZ == 0.0f) {
                sShadowZ = view.getResources().getDimensionPixelSize(R.dimen.lb_playback_controls_z);
            }
            ShadowHelper.getInstance().setZ(view, sShadowZ);
        }
    }

    static class BoundData
    extends PlaybackControlsPresenter.BoundData {
        ViewHolder mRowViewHolder;

        BoundData() {
        }
    }
}

