/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.PresenterSelector;
import android.view.View;
import android.view.ViewGroup;

public abstract class PresenterSwitcher {
    private ViewGroup mParent;
    private PresenterSelector mPresenterSelector;
    private Presenter mCurrentPresenter;
    private Presenter.ViewHolder mCurrentViewHolder;

    public void init(ViewGroup parent, PresenterSelector presenterSelector) {
        this.clear();
        this.mParent = parent;
        this.mPresenterSelector = presenterSelector;
    }

    public void select(Object object) {
        this.switchView(object);
        this.showView(true);
    }

    public void unselect() {
        this.showView(false);
    }

    public final ViewGroup getParentViewGroup() {
        return this.mParent;
    }

    private void showView(boolean show) {
        if (this.mCurrentViewHolder != null) {
            this.showView(this.mCurrentViewHolder.view, show);
        }
    }

    private void switchView(Object object) {
        Presenter presenter = this.mPresenterSelector.getPresenter(object);
        if (presenter != this.mCurrentPresenter) {
            this.showView(false);
            this.clear();
            this.mCurrentPresenter = presenter;
            if (this.mCurrentPresenter == null) {
                return;
            }
            this.mCurrentViewHolder = this.mCurrentPresenter.onCreateViewHolder(this.mParent);
            this.insertView(this.mCurrentViewHolder.view);
        } else {
            if (this.mCurrentPresenter == null) {
                return;
            }
            this.mCurrentPresenter.onUnbindViewHolder(this.mCurrentViewHolder);
        }
        this.mCurrentPresenter.onBindViewHolder(this.mCurrentViewHolder, object);
        this.onViewSelected(this.mCurrentViewHolder.view);
    }

    protected abstract void insertView(View var1);

    protected void onViewSelected(View view) {
    }

    protected void showView(View view, boolean visible) {
        view.setVisibility(visible ? 0 : 8);
    }

    public void clear() {
        if (this.mCurrentPresenter != null) {
            this.mCurrentPresenter.onUnbindViewHolder(this.mCurrentViewHolder);
            this.mParent.removeView(this.mCurrentViewHolder.view);
            this.mCurrentViewHolder = null;
            this.mCurrentPresenter = null;
        }
    }
}

