/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v17.leanback.R;
import android.text.Layout;
import android.util.AttributeSet;
import android.widget.TextView;

class ResizingTextView
extends TextView {
    public static final int TRIGGER_MAX_LINES = 1;
    private int mTriggerConditions;
    private int mResizedTextSize;
    private boolean mMaintainLineSpacing;
    private int mResizedPaddingAdjustmentTop;
    private int mResizedPaddingAdjustmentBottom;
    private boolean mIsResized = false;
    private boolean mDefaultsInitialized = false;
    private int mDefaultTextSize;
    private float mDefaultLineSpacingExtra;
    private int mDefaultPaddingTop;
    private int mDefaultPaddingBottom;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResizingTextView(Context ctx, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(ctx, attrs, defStyleAttr);
        TypedArray a = ctx.obtainStyledAttributes(attrs, R.styleable.lbResizingTextView, defStyleAttr, defStyleRes);
        try {
            this.mTriggerConditions = a.getInt(R.styleable.lbResizingTextView_resizeTrigger, 1);
            this.mResizedTextSize = a.getDimensionPixelSize(R.styleable.lbResizingTextView_resizedTextSize, -1);
            this.mMaintainLineSpacing = a.getBoolean(R.styleable.lbResizingTextView_maintainLineSpacing, false);
            this.mResizedPaddingAdjustmentTop = a.getDimensionPixelOffset(R.styleable.lbResizingTextView_resizedPaddingAdjustmentTop, 0);
            this.mResizedPaddingAdjustmentBottom = a.getDimensionPixelOffset(R.styleable.lbResizingTextView_resizedPaddingAdjustmentBottom, 0);
        }
        finally {
            a.recycle();
        }
    }

    public ResizingTextView(Context ctx, AttributeSet attrs, int defStyleAttr) {
        this(ctx, attrs, defStyleAttr, 0);
    }

    public ResizingTextView(Context ctx, AttributeSet attrs) {
        this(ctx, attrs, 16842884);
    }

    public ResizingTextView(Context ctx) {
        this(ctx, null);
    }

    public int getTriggerConditions() {
        return this.mTriggerConditions;
    }

    public void setTriggerConditions(int conditions) {
        if (this.mTriggerConditions != conditions) {
            this.mTriggerConditions = conditions;
            this.requestLayout();
        }
    }

    public int getResizedTextSize() {
        return this.mResizedTextSize;
    }

    public void setResizedTextSize(int size) {
        if (this.mResizedTextSize != size) {
            this.mResizedTextSize = size;
            this.resizeParamsChanged();
        }
    }

    public boolean getMaintainLineSpacing() {
        return this.mMaintainLineSpacing;
    }

    public void setMaintainLineSpacing(boolean maintain) {
        if (this.mMaintainLineSpacing != maintain) {
            this.mMaintainLineSpacing = maintain;
            this.resizeParamsChanged();
        }
    }

    public int getResizedPaddingAdjustmentTop() {
        return this.mResizedPaddingAdjustmentTop;
    }

    public void setResizedPaddingAdjustmentTop(int adjustment) {
        if (this.mResizedPaddingAdjustmentTop != adjustment) {
            this.mResizedPaddingAdjustmentTop = adjustment;
            this.resizeParamsChanged();
        }
    }

    public int getResizedPaddingAdjustmentBottom() {
        return this.mResizedPaddingAdjustmentBottom;
    }

    public void setResizedPaddingAdjustmentBottom(int adjustment) {
        if (this.mResizedPaddingAdjustmentBottom != adjustment) {
            this.mResizedPaddingAdjustmentBottom = adjustment;
            this.resizeParamsChanged();
        }
    }

    private void resizeParamsChanged() {
        if (this.mIsResized) {
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!this.mDefaultsInitialized) {
            this.mDefaultTextSize = (int)this.getTextSize();
            this.mDefaultLineSpacingExtra = this.getLineSpacingExtra();
            this.mDefaultPaddingTop = this.getPaddingTop();
            this.mDefaultPaddingBottom = this.getPaddingBottom();
            this.mDefaultsInitialized = true;
        }
        this.setTextSize(0, this.mDefaultTextSize);
        this.setLineSpacing(this.mDefaultLineSpacingExtra, this.getLineSpacingMultiplier());
        this.setPaddingTopAndBottom(this.mDefaultPaddingTop, this.mDefaultPaddingBottom);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        boolean resizeText = false;
        Layout layout2 = this.getLayout();
        if (layout2 != null && (this.mTriggerConditions & 1) > 0) {
            int lineCount = layout2.getLineCount();
            int maxLines = this.getMaxLines();
            if (maxLines > 1) {
                resizeText = lineCount == maxLines;
            }
        }
        int currentSizePx = (int)this.getTextSize();
        boolean remeasure = false;
        if (resizeText) {
            if (this.mResizedTextSize != -1 && currentSizePx != this.mResizedTextSize) {
                this.setTextSize(0, this.mResizedTextSize);
                remeasure = true;
            }
            float targetLineSpacingExtra = this.mDefaultLineSpacingExtra + (float)this.mDefaultTextSize - (float)this.mResizedTextSize;
            if (this.mMaintainLineSpacing && this.getLineSpacingExtra() != targetLineSpacingExtra) {
                this.setLineSpacing(targetLineSpacingExtra, this.getLineSpacingMultiplier());
                remeasure = true;
            }
            int paddingTop = this.mDefaultPaddingTop + this.mResizedPaddingAdjustmentTop;
            int paddingBottom = this.mDefaultPaddingBottom + this.mResizedPaddingAdjustmentBottom;
            if (this.getPaddingTop() != paddingTop || this.getPaddingBottom() != paddingBottom) {
                this.setPaddingTopAndBottom(paddingTop, paddingBottom);
                remeasure = true;
            }
        } else {
            if (this.mResizedTextSize != -1 && currentSizePx != this.mDefaultTextSize) {
                this.setTextSize(0, this.mDefaultTextSize);
                remeasure = true;
            }
            if (this.mMaintainLineSpacing && this.getLineSpacingExtra() != this.mDefaultLineSpacingExtra) {
                this.setLineSpacing(this.mDefaultLineSpacingExtra, this.getLineSpacingMultiplier());
                remeasure = true;
            }
            if (this.getPaddingTop() != this.mDefaultPaddingTop || this.getPaddingBottom() != this.mDefaultPaddingBottom) {
                this.setPaddingTopAndBottom(this.mDefaultPaddingTop, this.mDefaultPaddingBottom);
                remeasure = true;
            }
        }
        this.mIsResized = resizeText;
        if (remeasure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void setPaddingTopAndBottom(int paddingTop, int paddingBottom) {
        if (this.isPaddingRelative()) {
            this.setPaddingRelative(this.getPaddingStart(), paddingTop, this.getPaddingEnd(), paddingBottom);
        } else {
            this.setPadding(this.getPaddingLeft(), paddingTop, this.getPaddingRight(), paddingBottom);
        }
    }
}

