/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.graphics.Paint;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.HeaderItem;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.Row;
import android.support.v17.leanback.widget.RowHeaderView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

public class RowHeaderPresenter
extends Presenter {
    private final int mLayoutResourceId;
    private final Paint mFontMeasurePaint = new Paint(1);
    private boolean mNullItemVisibilityGone;

    public RowHeaderPresenter() {
        this(R.layout.lb_row_header);
    }

    public RowHeaderPresenter(int layoutResourceId) {
        this.mLayoutResourceId = layoutResourceId;
    }

    public void setNullItemVisibilityGone(boolean nullItemVisibilityGone) {
        this.mNullItemVisibilityGone = nullItemVisibilityGone;
    }

    public boolean isNullItemVisibilityGone() {
        return this.mNullItemVisibilityGone;
    }

    @Override
    public Presenter.ViewHolder onCreateViewHolder(ViewGroup parent) {
        RowHeaderView headerView = (RowHeaderView)LayoutInflater.from((Context)parent.getContext()).inflate(this.mLayoutResourceId, parent, false);
        ViewHolder viewHolder = new ViewHolder((View)headerView);
        viewHolder.mOriginalTextColor = headerView.getCurrentTextColor();
        viewHolder.mUnselectAlpha = parent.getResources().getFraction(R.fraction.lb_browse_header_unselect_alpha, 1, 1);
        this.setSelectLevel(viewHolder, 0.0f);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(Presenter.ViewHolder viewHolder, Object item) {
        HeaderItem headerItem;
        HeaderItem headerItem2 = headerItem = item == null ? null : ((Row)item).getHeaderItem();
        if (headerItem == null) {
            ((RowHeaderView)viewHolder.view).setText(null);
            if (this.mNullItemVisibilityGone) {
                viewHolder.view.setVisibility(8);
            }
        } else {
            viewHolder.view.setVisibility(0);
            ((RowHeaderView)viewHolder.view).setText(headerItem.getName());
        }
    }

    @Override
    public void onUnbindViewHolder(Presenter.ViewHolder viewHolder) {
        ((RowHeaderView)viewHolder.view).setText(null);
        this.setSelectLevel((ViewHolder)viewHolder, 0.0f);
    }

    public final void setSelectLevel(ViewHolder holder, float selectLevel) {
        holder.mSelectLevel = selectLevel;
        this.onSelectLevelChanged(holder);
    }

    protected void onSelectLevelChanged(ViewHolder holder) {
        holder.view.setAlpha(holder.mUnselectAlpha + holder.mSelectLevel * (1.0f - holder.mUnselectAlpha));
    }

    public int getSpaceUnderBaseline(ViewHolder holder) {
        int space = holder.view.getPaddingBottom();
        if (holder.view instanceof TextView) {
            space += (int)RowHeaderPresenter.getFontDescent((TextView)holder.view, this.mFontMeasurePaint);
        }
        return space;
    }

    protected static float getFontDescent(TextView textView, Paint fontMeasurePaint) {
        if (fontMeasurePaint.getTextSize() != textView.getTextSize()) {
            fontMeasurePaint.setTextSize(textView.getTextSize());
        }
        if (fontMeasurePaint.getTypeface() != textView.getTypeface()) {
            fontMeasurePaint.setTypeface(textView.getTypeface());
        }
        return fontMeasurePaint.descent();
    }

    public static class ViewHolder
    extends Presenter.ViewHolder {
        float mSelectLevel;
        int mOriginalTextColor;
        float mUnselectAlpha;

        public ViewHolder(View view) {
            super(view);
        }

        public final float getSelectLevel() {
            return this.mSelectLevel;
        }
    }
}

