/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.widget.FrameLayout;

public class ScaleFrameLayout
extends FrameLayout {
    private static final int DEFAULT_CHILD_GRAVITY = 0x800033;
    private float mLayoutScaleX = 1.0f;
    private float mLayoutScaleY = 1.0f;

    public ScaleFrameLayout(Context context) {
        this(context, null);
    }

    public ScaleFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScaleFrameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setLayoutScaleX(float scaleX) {
        if (scaleX != this.mLayoutScaleX) {
            this.mLayoutScaleX = scaleX;
            this.requestLayout();
        }
    }

    public void setLayoutScaleY(float scaleY) {
        if (scaleY != this.mLayoutScaleY) {
            this.mLayoutScaleY = scaleY;
            this.requestLayout();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int parentBottom;
        int parentTop;
        int parentRight;
        int parentLeft;
        float pivotX;
        int count = this.getChildCount();
        int layoutDirection = this.getLayoutDirection();
        float f = pivotX = layoutDirection == 1 ? (float)this.getWidth() - this.getPivotX() : this.getPivotX();
        if (this.mLayoutScaleX != 1.0f) {
            parentLeft = this.getPaddingLeft() + (int)(pivotX - pivotX / this.mLayoutScaleX + 0.5f);
            parentRight = (int)(pivotX + ((float)(right - left) - pivotX) / this.mLayoutScaleX + 0.5f) - this.getPaddingRight();
        } else {
            parentLeft = this.getPaddingLeft();
            parentRight = right - left - this.getPaddingRight();
        }
        float pivotY = this.getPivotY();
        if (this.mLayoutScaleY != 1.0f) {
            parentTop = this.getPaddingTop() + (int)(pivotY - pivotY / this.mLayoutScaleY + 0.5f);
            parentBottom = (int)(pivotY + ((float)(bottom - top) - pivotY) / this.mLayoutScaleY + 0.5f) - this.getPaddingBottom();
        } else {
            parentTop = this.getPaddingTop();
            parentBottom = bottom - top - this.getPaddingBottom();
        }
        for (int i = 0; i < count; ++i) {
            int childTop;
            int childLeft;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int gravity = lp.gravity;
            if (gravity == -1) {
                gravity = 0x800033;
            }
            int absoluteGravity = Gravity.getAbsoluteGravity((int)gravity, (int)layoutDirection);
            int verticalGravity = gravity & 0x70;
            switch (absoluteGravity & 7) {
                case 1: {
                    childLeft = parentLeft + (parentRight - parentLeft - width) / 2 + lp.leftMargin - lp.rightMargin;
                    break;
                }
                case 5: {
                    childLeft = parentRight - width - lp.rightMargin;
                    break;
                }
                default: {
                    childLeft = parentLeft + lp.leftMargin;
                }
            }
            switch (verticalGravity) {
                case 48: {
                    childTop = parentTop + lp.topMargin;
                    break;
                }
                case 16: {
                    childTop = parentTop + (parentBottom - parentTop - height) / 2 + lp.topMargin - lp.bottomMargin;
                    break;
                }
                case 80: {
                    childTop = parentBottom - height - lp.bottomMargin;
                    break;
                }
                default: {
                    childTop = parentTop + lp.topMargin;
                }
            }
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
            child.setPivotX(pivotX - (float)childLeft);
            child.setPivotY(pivotY - (float)childTop);
        }
    }

    private static int getScaledMeasureSpec(int measureSpec, float scale) {
        return scale == 1.0f ? measureSpec : View.MeasureSpec.makeMeasureSpec((int)((int)((float)View.MeasureSpec.getSize((int)measureSpec) / scale + 0.5f)), (int)View.MeasureSpec.getMode((int)measureSpec));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mLayoutScaleX != 1.0f || this.mLayoutScaleY != 1.0f) {
            int scaledWidthMeasureSpec = ScaleFrameLayout.getScaledMeasureSpec(widthMeasureSpec, this.mLayoutScaleX);
            int scaledHeightMeasureSpec = ScaleFrameLayout.getScaledMeasureSpec(heightMeasureSpec, this.mLayoutScaleY);
            super.onMeasure(scaledWidthMeasureSpec, scaledHeightMeasureSpec);
            this.setMeasuredDimension((int)((float)this.getMeasuredWidth() * this.mLayoutScaleX + 0.5f), (int)((float)this.getMeasuredHeight() * this.mLayoutScaleY + 0.5f));
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void setForeground(Drawable d) {
        throw new UnsupportedOperationException();
    }
}

