/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.os.Build;
import android.support.v17.leanback.widget.ShadowHelperApi21;
import android.view.View;
import android.view.ViewGroup;

final class ShadowHelper {
    static final ShadowHelper sInstance = new ShadowHelper();
    boolean mSupportsDynamicShadow;
    ShadowHelperVersionImpl mImpl;

    private ShadowHelper() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.mSupportsDynamicShadow = true;
            this.mImpl = new ShadowHelperApi21Impl();
        } else {
            this.mImpl = new ShadowHelperStubImpl();
        }
    }

    public static ShadowHelper getInstance() {
        return sInstance;
    }

    public boolean supportsDynamicShadow() {
        return this.mSupportsDynamicShadow;
    }

    public Object addDynamicShadow(ViewGroup shadowContainer, float unfocusedZ, float focusedZ, boolean roundedCorners) {
        return this.mImpl.addDynamicShadow(shadowContainer, unfocusedZ, focusedZ, roundedCorners);
    }

    public void setShadowFocusLevel(Object impl, float level) {
        this.mImpl.setShadowFocusLevel(impl, level);
    }

    public void setZ(View view, float z) {
        this.mImpl.setZ(view, z);
    }

    private static final class ShadowHelperApi21Impl
    implements ShadowHelperVersionImpl {
        private ShadowHelperApi21Impl() {
        }

        @Override
        public Object addDynamicShadow(ViewGroup shadowContainer, float unfocusedZ, float focusedZ, boolean roundedCorners) {
            return ShadowHelperApi21.addDynamicShadow(shadowContainer, unfocusedZ, focusedZ, roundedCorners);
        }

        @Override
        public void setShadowFocusLevel(Object impl, float level) {
            ShadowHelperApi21.setShadowFocusLevel(impl, level);
        }

        @Override
        public void setZ(View view, float z) {
            ShadowHelperApi21.setZ(view, z);
        }
    }

    private static final class ShadowHelperStubImpl
    implements ShadowHelperVersionImpl {
        private ShadowHelperStubImpl() {
        }

        @Override
        public Object addDynamicShadow(ViewGroup shadowContainer, float focusedZ, float unfocusedZ, boolean roundedCorners) {
            return null;
        }

        @Override
        public void setShadowFocusLevel(Object impl, float level) {
        }

        @Override
        public void setZ(View view, float z) {
        }
    }

    static interface ShadowHelperVersionImpl {
        public Object addDynamicShadow(ViewGroup var1, float var2, float var3, boolean var4);

        public void setZ(View var1, float var2);

        public void setShadowFocusLevel(Object var1, float var2);
    }
}

