/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.support.v17.leanback.widget.Grid;
import android.support.v4.util.CircularIntArray;
import java.io.PrintWriter;

class SingleRow
extends Grid {
    private final Grid.Location mTmpLocation = new Grid.Location(0);
    private Object[] mTmpItem = new Object[1];

    SingleRow() {
        this.setNumRows(1);
    }

    @Override
    public final Grid.Location getLocation(int index) {
        return this.mTmpLocation;
    }

    @Override
    public final void debugPrint(PrintWriter pw) {
        pw.print("SingleRow<");
        pw.print(this.mFirstVisibleIndex);
        pw.print(",");
        pw.print(this.mLastVisibleIndex);
        pw.print(">");
        pw.println();
    }

    int getStartIndexForAppend() {
        if (this.mLastVisibleIndex >= 0) {
            return this.mLastVisibleIndex + 1;
        }
        if (this.mStartIndex != -1) {
            return Math.min(this.mStartIndex, this.mProvider.getCount() - 1);
        }
        return 0;
    }

    int getStartIndexForPrepend() {
        if (this.mFirstVisibleIndex >= 0) {
            return this.mFirstVisibleIndex - 1;
        }
        if (this.mStartIndex != -1) {
            return Math.min(this.mStartIndex, this.mProvider.getCount() - 1);
        }
        return this.mProvider.getCount() - 1;
    }

    @Override
    protected final boolean prependVisibleItems(int toLimit, boolean oneColumnMode) {
        if (this.mProvider.getCount() == 0) {
            return false;
        }
        if (!oneColumnMode && this.checkPrependOverLimit(toLimit)) {
            return false;
        }
        boolean filledOne = false;
        for (int index = this.getStartIndexForPrepend(); index >= 0; --index) {
            int edge;
            int size = this.mProvider.createItem(index, false, this.mTmpItem);
            if (this.mFirstVisibleIndex < 0 || this.mLastVisibleIndex < 0) {
                edge = this.mReversedFlow ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                this.mLastVisibleIndex = this.mFirstVisibleIndex = index;
            } else {
                edge = this.mReversedFlow ? this.mProvider.getEdge(index + 1) + this.mMargin + size : this.mProvider.getEdge(index + 1) - this.mMargin - size;
                this.mFirstVisibleIndex = index;
            }
            this.mProvider.addItem(this.mTmpItem[0], index, size, 0, edge);
            filledOne = true;
            if (oneColumnMode || this.checkPrependOverLimit(toLimit)) break;
        }
        return filledOne;
    }

    @Override
    protected final boolean appendVisibleItems(int toLimit, boolean oneColumnMode) {
        if (this.mProvider.getCount() == 0) {
            return false;
        }
        if (!oneColumnMode && this.checkAppendOverLimit(toLimit)) {
            return false;
        }
        boolean filledOne = false;
        for (int index = this.getStartIndexForAppend(); index < this.mProvider.getCount(); ++index) {
            int edge;
            int size = this.mProvider.createItem(index, true, this.mTmpItem);
            if (this.mFirstVisibleIndex < 0 || this.mLastVisibleIndex < 0) {
                edge = this.mReversedFlow ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                this.mLastVisibleIndex = this.mFirstVisibleIndex = index;
            } else {
                edge = this.mReversedFlow ? this.mProvider.getEdge(index - 1) - this.mProvider.getSize(index - 1) - this.mMargin : this.mProvider.getEdge(index - 1) + this.mProvider.getSize(index - 1) + this.mMargin;
                this.mLastVisibleIndex = index;
            }
            this.mProvider.addItem(this.mTmpItem[0], index, size, 0, edge);
            filledOne = true;
            if (oneColumnMode || this.checkAppendOverLimit(toLimit)) break;
        }
        return filledOne;
    }

    @Override
    public final CircularIntArray[] getItemPositionsInRows(int startPos, int endPos) {
        this.mTmpItemPositionsInRows[0].clear();
        this.mTmpItemPositionsInRows[0].addLast(startPos);
        this.mTmpItemPositionsInRows[0].addLast(endPos);
        return this.mTmpItemPositionsInRows;
    }

    @Override
    protected final int findRowMin(boolean findLarge, int indexLimit, int[] indices) {
        if (indices != null) {
            indices[0] = 0;
            indices[1] = indexLimit;
        }
        return this.mReversedFlow ? this.mProvider.getEdge(indexLimit) - this.mProvider.getSize(indexLimit) : this.mProvider.getEdge(indexLimit);
    }

    @Override
    protected final int findRowMax(boolean findLarge, int indexLimit, int[] indices) {
        if (indices != null) {
            indices[0] = 0;
            indices[1] = indexLimit;
        }
        return this.mReversedFlow ? this.mProvider.getEdge(indexLimit) : this.mProvider.getEdge(indexLimit) + this.mProvider.getSize(indexLimit);
    }
}

