/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.content.res.Resources;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.SearchOrbView;
import android.util.AttributeSet;

public class SpeechOrbView
extends SearchOrbView {
    private final float mSoundLevelMaxZoom;
    private final SearchOrbView.Colors mListeningOrbColors;
    private final SearchOrbView.Colors mNotListeningOrbColors;
    private int mCurrentLevel = 0;
    private boolean mListening = false;

    public SpeechOrbView(Context context) {
        this(context, null);
    }

    public SpeechOrbView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SpeechOrbView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        Resources resources = context.getResources();
        this.mSoundLevelMaxZoom = resources.getFraction(R.fraction.lb_search_bar_speech_orb_max_level_zoom, 1, 1);
        this.mNotListeningOrbColors = new SearchOrbView.Colors(resources.getColor(R.color.lb_speech_orb_not_recording), resources.getColor(R.color.lb_speech_orb_not_recording_pulsed), resources.getColor(R.color.lb_speech_orb_not_recording_icon));
        this.mListeningOrbColors = new SearchOrbView.Colors(resources.getColor(R.color.lb_speech_orb_recording), resources.getColor(R.color.lb_speech_orb_recording), 0);
        this.showNotListening();
    }

    @Override
    int getLayoutResourceId() {
        return R.layout.lb_speech_orb;
    }

    public void showListening() {
        this.setOrbColors(this.mListeningOrbColors);
        this.setOrbIcon(this.getResources().getDrawable(R.drawable.lb_ic_search_mic));
        this.animateOnFocus(true);
        this.enableOrbColorAnimation(false);
        this.scaleOrbViewOnly(1.0f);
        this.mCurrentLevel = 0;
        this.mListening = true;
    }

    public void showNotListening() {
        this.setOrbColors(this.mNotListeningOrbColors);
        this.setOrbIcon(this.getResources().getDrawable(R.drawable.lb_ic_search_mic_out));
        this.animateOnFocus(this.hasFocus());
        this.scaleOrbViewOnly(1.0f);
        this.mListening = false;
    }

    public void setSoundLevel(int level) {
        if (!this.mListening) {
            return;
        }
        this.mCurrentLevel = level > this.mCurrentLevel ? (this.mCurrentLevel += (level - this.mCurrentLevel) / 2) : (int)((float)this.mCurrentLevel * 0.7f);
        float zoom = 1.0f + (this.mSoundLevelMaxZoom - this.getFocusedZoom()) * (float)this.mCurrentLevel / 100.0f;
        this.scaleOrbViewOnly(zoom);
    }
}

