/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.support.v17.leanback.widget.Grid;
import android.support.v4.util.CircularArray;
import android.support.v4.util.CircularIntArray;
import java.io.PrintWriter;

abstract class StaggeredGrid
extends Grid {
    protected CircularArray<Location> mLocations = new CircularArray(64);
    protected int mFirstIndex = -1;
    private Object[] mTmpItem = new Object[1];
    protected Object mPendingItem;
    protected int mPendingItemSize;

    StaggeredGrid() {
    }

    public final int getFirstIndex() {
        return this.mFirstIndex;
    }

    public final int getLastIndex() {
        return this.mFirstIndex + this.mLocations.size() - 1;
    }

    public final int getSize() {
        return this.mLocations.size();
    }

    @Override
    public final Location getLocation(int index) {
        if (this.mLocations.size() == 0) {
            return null;
        }
        return (Location)this.mLocations.get(index - this.mFirstIndex);
    }

    @Override
    public final void debugPrint(PrintWriter pw) {
        int size = this.mLocations.size();
        for (int i = 0; i < size; ++i) {
            Location loc = (Location)this.mLocations.get(i);
            pw.print("<" + (this.mFirstIndex + i) + "," + loc.row + ">");
            pw.print(" ");
            pw.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean prependVisibleItems(int toLimit, boolean oneColumnMode) {
        if (this.mProvider.getCount() == 0) {
            return false;
        }
        if (!oneColumnMode && this.checkPrependOverLimit(toLimit)) {
            return false;
        }
        try {
            if (this.prependVisbleItemsWithCache(toLimit, oneColumnMode)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.prependVisibleItemsWithoutCache(toLimit, oneColumnMode);
            return bl;
        }
        finally {
            this.mTmpItem[0] = null;
            this.mPendingItem = null;
        }
    }

    protected final boolean prependVisbleItemsWithCache(int toLimit, boolean oneColumnMode) {
        int itemIndex;
        int offset;
        int edge;
        if (this.mLocations.size() == 0) {
            return false;
        }
        int count = this.mProvider.getCount();
        int firstIndex = this.getFirstIndex();
        if (this.mFirstVisibleIndex >= 0) {
            edge = this.mProvider.getEdge(this.mFirstVisibleIndex);
            offset = this.getLocation((int)this.mFirstVisibleIndex).offset;
            itemIndex = this.mFirstVisibleIndex - 1;
        } else {
            edge = Integer.MAX_VALUE;
            offset = 0;
            int n = itemIndex = this.mStartIndex != -1 ? this.mStartIndex : 0;
            if (itemIndex > this.getLastIndex() || itemIndex < this.getFirstIndex() - 1) {
                this.mLocations.clear();
                return false;
            }
            if (itemIndex < this.getFirstIndex()) {
                return false;
            }
        }
        while (itemIndex >= this.mFirstIndex) {
            Location loc = this.getLocation(itemIndex);
            int rowIndex = loc.row;
            int size = this.mProvider.createItem(itemIndex, false, this.mTmpItem);
            if (size != loc.size) {
                this.mLocations.removeFromStart(itemIndex + 1 - this.mFirstIndex);
                this.mFirstIndex = this.mFirstVisibleIndex;
                this.mPendingItem = this.mTmpItem[0];
                this.mPendingItemSize = size;
                return false;
            }
            this.mFirstVisibleIndex = itemIndex;
            if (this.mLastVisibleIndex < 0) {
                this.mLastVisibleIndex = itemIndex;
            }
            this.mProvider.addItem(this.mTmpItem[0], itemIndex, size, rowIndex, edge - offset);
            if (!oneColumnMode && this.checkPrependOverLimit(toLimit)) {
                return true;
            }
            edge = this.mProvider.getEdge(itemIndex);
            offset = loc.offset;
            if (rowIndex == 0 && oneColumnMode) {
                return true;
            }
            --itemIndex;
        }
        return false;
    }

    private int calculateOffsetAfterLastItem(int row) {
        int cachedIndex;
        boolean foundCachedItemInSameRow = false;
        for (cachedIndex = this.getLastIndex(); cachedIndex >= this.mFirstIndex; --cachedIndex) {
            Location loc = this.getLocation(cachedIndex);
            if (loc.row != row) continue;
            foundCachedItemInSameRow = true;
            break;
        }
        if (!foundCachedItemInSameRow) {
            cachedIndex = this.getLastIndex();
        }
        int offset = this.isReversedFlow() ? -this.getLocation((int)cachedIndex).size - this.mMargin : this.getLocation((int)cachedIndex).size + this.mMargin;
        for (int i = cachedIndex + 1; i <= this.getLastIndex(); ++i) {
            offset -= this.getLocation((int)i).offset;
        }
        return offset;
    }

    protected abstract boolean prependVisibleItemsWithoutCache(int var1, boolean var2);

    protected final int prependVisibleItemToRow(int itemIndex, int rowIndex, int edge) {
        int thisEdge;
        Object item;
        if (this.mFirstVisibleIndex >= 0 && (this.mFirstVisibleIndex != this.getFirstIndex() || this.mFirstVisibleIndex != itemIndex + 1)) {
            throw new IllegalStateException();
        }
        Location oldFirstLoc = this.mFirstIndex >= 0 ? this.getLocation(this.mFirstIndex) : null;
        int oldFirstEdge = this.mProvider.getEdge(this.mFirstIndex);
        Location loc = new Location(rowIndex, 0, 0);
        this.mLocations.addFirst((Object)loc);
        if (this.mPendingItem != null) {
            loc.size = this.mPendingItemSize;
            item = this.mPendingItem;
            this.mPendingItem = null;
        } else {
            loc.size = this.mProvider.createItem(itemIndex, false, this.mTmpItem);
            item = this.mTmpItem[0];
        }
        this.mFirstIndex = this.mFirstVisibleIndex = itemIndex;
        if (this.mLastVisibleIndex < 0) {
            this.mLastVisibleIndex = itemIndex;
        }
        int n = thisEdge = !this.mReversedFlow ? edge - loc.size : edge + loc.size;
        if (oldFirstLoc != null) {
            oldFirstLoc.offset = oldFirstEdge - thisEdge;
        }
        this.mProvider.addItem(item, itemIndex, loc.size, rowIndex, thisEdge);
        return loc.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean appendVisibleItems(int toLimit, boolean oneColumnMode) {
        if (this.mProvider.getCount() == 0) {
            return false;
        }
        if (!oneColumnMode && this.checkAppendOverLimit(toLimit)) {
            return false;
        }
        try {
            if (this.appendVisbleItemsWithCache(toLimit, oneColumnMode)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.appendVisibleItemsWithoutCache(toLimit, oneColumnMode);
            return bl;
        }
        finally {
            this.mTmpItem[0] = null;
            this.mPendingItem = null;
        }
    }

    protected final boolean appendVisbleItemsWithCache(int toLimit, boolean oneColumnMode) {
        int edge;
        int itemIndex;
        if (this.mLocations.size() == 0) {
            return false;
        }
        int count = this.mProvider.getCount();
        if (this.mLastVisibleIndex >= 0) {
            itemIndex = this.mLastVisibleIndex + 1;
            edge = this.mProvider.getEdge(this.mLastVisibleIndex);
        } else {
            edge = Integer.MAX_VALUE;
            int n = itemIndex = this.mStartIndex != -1 ? this.mStartIndex : 0;
            if (itemIndex > this.getLastIndex() + 1 || itemIndex < this.getFirstIndex()) {
                this.mLocations.clear();
                return false;
            }
            if (itemIndex > this.getLastIndex()) {
                return false;
            }
        }
        int lastIndex = this.getLastIndex();
        while (itemIndex < count && itemIndex <= lastIndex) {
            Location loc = this.getLocation(itemIndex);
            if (edge != Integer.MAX_VALUE) {
                edge += loc.offset;
            }
            int rowIndex = loc.row;
            int size = this.mProvider.createItem(itemIndex, true, this.mTmpItem);
            if (size != loc.size) {
                loc.size = size;
                this.mLocations.removeFromEnd(lastIndex - itemIndex);
                lastIndex = itemIndex;
            }
            this.mLastVisibleIndex = itemIndex;
            if (this.mFirstVisibleIndex < 0) {
                this.mFirstVisibleIndex = itemIndex;
            }
            this.mProvider.addItem(this.mTmpItem[0], itemIndex, size, rowIndex, edge);
            if (!oneColumnMode && this.checkAppendOverLimit(toLimit)) {
                return true;
            }
            if (edge == Integer.MAX_VALUE) {
                edge = this.mProvider.getEdge(itemIndex);
            }
            if (rowIndex == this.mNumRows - 1 && oneColumnMode) {
                return true;
            }
            ++itemIndex;
        }
        return false;
    }

    protected abstract boolean appendVisibleItemsWithoutCache(int var1, boolean var2);

    protected final int appendVisibleItemToRow(int itemIndex, int rowIndex, int location) {
        Object item;
        if (this.mLastVisibleIndex >= 0 && (this.mLastVisibleIndex != this.getLastIndex() || this.mLastVisibleIndex != itemIndex - 1)) {
            throw new IllegalStateException();
        }
        int offset = this.mLastVisibleIndex < 0 ? (this.mLocations.size() > 0 && itemIndex == this.getLastIndex() + 1 ? this.calculateOffsetAfterLastItem(rowIndex) : 0) : location - this.mProvider.getEdge(this.mLastVisibleIndex);
        Location loc = new Location(rowIndex, offset, 0);
        this.mLocations.addLast((Object)loc);
        if (this.mPendingItem != null) {
            loc.size = this.mPendingItemSize;
            item = this.mPendingItem;
            this.mPendingItem = null;
        } else {
            loc.size = this.mProvider.createItem(itemIndex, true, this.mTmpItem);
            item = this.mTmpItem[0];
        }
        if (this.mLocations.size() == 1) {
            this.mFirstVisibleIndex = this.mLastVisibleIndex = itemIndex;
            this.mFirstIndex = this.mLastVisibleIndex;
        } else if (this.mLastVisibleIndex < 0) {
            this.mFirstVisibleIndex = this.mLastVisibleIndex = itemIndex;
        } else {
            ++this.mLastVisibleIndex;
        }
        this.mProvider.addItem(item, itemIndex, loc.size, rowIndex, location);
        return loc.size;
    }

    @Override
    public final CircularIntArray[] getItemPositionsInRows(int startPos, int endPos) {
        int i;
        for (i = 0; i < this.mNumRows; ++i) {
            this.mTmpItemPositionsInRows[i].clear();
        }
        if (startPos >= 0) {
            for (i = startPos; i <= endPos; ++i) {
                CircularIntArray row = this.mTmpItemPositionsInRows[this.getLocation((int)i).row];
                if (row.size() > 0 && row.getLast() == i - 1) {
                    row.popLast();
                    row.addLast(i);
                    continue;
                }
                row.addLast(i);
                row.addLast(i);
            }
        }
        return this.mTmpItemPositionsInRows;
    }

    @Override
    public void invalidateItemsAfter(int index) {
        super.invalidateItemsAfter(index);
        this.mLocations.removeFromEnd(this.getLastIndex() - index + 1);
        if (this.mLocations.size() == 0) {
            this.mFirstIndex = -1;
        }
    }

    public static class Location
    extends Grid.Location {
        public int offset;
        public int size;

        public Location(int row, int offset, int size) {
            super(row);
            this.offset = offset;
            this.size = size;
        }
    }
}

