/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.support.v17.leanback.widget.StaggeredGrid;

final class StaggeredGridDefault
extends StaggeredGrid {
    StaggeredGridDefault() {
    }

    int getRowMax(int rowIndex) {
        if (this.mFirstVisibleIndex < 0) {
            return Integer.MIN_VALUE;
        }
        if (this.mReversedFlow) {
            int edge = this.mProvider.getEdge(this.mFirstVisibleIndex);
            if (this.getLocation((int)this.mFirstVisibleIndex).row == rowIndex) {
                return edge;
            }
            for (int i = this.mFirstVisibleIndex + 1; i <= this.getLastIndex(); ++i) {
                StaggeredGrid.Location loc = this.getLocation(i);
                edge += loc.offset;
                if (loc.row != rowIndex) continue;
                return edge;
            }
        } else {
            int edge = this.mProvider.getEdge(this.mLastVisibleIndex);
            StaggeredGrid.Location loc = this.getLocation(this.mLastVisibleIndex);
            if (loc.row == rowIndex) {
                return edge + loc.size;
            }
            for (int i = this.mLastVisibleIndex - 1; i >= this.getFirstIndex(); --i) {
                edge -= loc.offset;
                loc = this.getLocation(i);
                if (loc.row != rowIndex) continue;
                return edge + loc.size;
            }
        }
        return Integer.MIN_VALUE;
    }

    int getRowMin(int rowIndex) {
        if (this.mFirstVisibleIndex < 0) {
            return Integer.MAX_VALUE;
        }
        if (this.mReversedFlow) {
            int edge = this.mProvider.getEdge(this.mLastVisibleIndex);
            StaggeredGrid.Location loc = this.getLocation(this.mLastVisibleIndex);
            if (loc.row == rowIndex) {
                return edge - loc.size;
            }
            for (int i = this.mLastVisibleIndex - 1; i >= this.getFirstIndex(); --i) {
                edge -= loc.offset;
                loc = this.getLocation(i);
                if (loc.row != rowIndex) continue;
                return edge - loc.size;
            }
        } else {
            int edge = this.mProvider.getEdge(this.mFirstVisibleIndex);
            if (this.getLocation((int)this.mFirstVisibleIndex).row == rowIndex) {
                return edge;
            }
            for (int i = this.mFirstVisibleIndex + 1; i <= this.getLastIndex(); ++i) {
                StaggeredGrid.Location loc = this.getLocation(i);
                edge += loc.offset;
                if (loc.row != rowIndex) continue;
                return edge;
            }
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int findRowMax(boolean findLarge, int indexLimit, int[] indices) {
        int value;
        int edge = this.mProvider.getEdge(indexLimit);
        StaggeredGrid.Location loc = this.getLocation(indexLimit);
        int row = loc.row;
        int index = indexLimit;
        int visitedRows = 1;
        int visitRow = row;
        if (this.mReversedFlow) {
            value = edge;
            for (int i = indexLimit + 1; visitedRows < this.mNumRows && i <= this.mLastVisibleIndex; ++i) {
                loc = this.getLocation(i);
                edge += loc.offset;
                if (loc.row == visitRow) continue;
                visitRow = loc.row;
                ++visitedRows;
                if (!(findLarge ? edge > value : edge < value)) continue;
                row = visitRow;
                value = edge;
                index = i;
            }
        } else {
            value = edge + this.mProvider.getSize(indexLimit);
            for (int i = indexLimit - 1; visitedRows < this.mNumRows && i >= this.mFirstVisibleIndex; --i) {
                edge -= loc.offset;
                loc = this.getLocation(i);
                if (loc.row == visitRow) continue;
                visitRow = loc.row;
                ++visitedRows;
                int newValue = edge + this.mProvider.getSize(i);
                if (!(findLarge ? newValue > value : newValue < value)) continue;
                row = visitRow;
                value = newValue;
                index = i;
            }
        }
        if (indices != null) {
            indices[0] = row;
            indices[1] = index;
        }
        return value;
    }

    @Override
    public int findRowMin(boolean findLarge, int indexLimit, int[] indices) {
        int value;
        int edge = this.mProvider.getEdge(indexLimit);
        StaggeredGrid.Location loc = this.getLocation(indexLimit);
        int row = loc.row;
        int index = indexLimit;
        int visitedRows = 1;
        int visitRow = row;
        if (this.mReversedFlow) {
            value = edge - this.mProvider.getSize(indexLimit);
            for (int i = indexLimit - 1; visitedRows < this.mNumRows && i >= this.mFirstVisibleIndex; --i) {
                edge -= loc.offset;
                loc = this.getLocation(i);
                if (loc.row == visitRow) continue;
                visitRow = loc.row;
                ++visitedRows;
                int newValue = edge - this.mProvider.getSize(i);
                if (!(findLarge ? newValue > value : newValue < value)) continue;
                value = newValue;
                row = visitRow;
                index = i;
            }
        } else {
            value = edge;
            for (int i = indexLimit + 1; visitedRows < this.mNumRows && i <= this.mLastVisibleIndex; ++i) {
                loc = this.getLocation(i);
                edge += loc.offset;
                if (loc.row == visitRow) continue;
                visitRow = loc.row;
                ++visitedRows;
                if (!(findLarge ? edge > value : edge < value)) continue;
                value = edge;
                row = visitRow;
                index = i;
            }
        }
        if (indices != null) {
            indices[0] = row;
            indices[1] = index;
        }
        return value;
    }

    private int findRowEdgeLimitSearchIndex(boolean append) {
        boolean wrapped = false;
        if (append) {
            for (int index = this.mLastVisibleIndex; index >= this.mFirstVisibleIndex; --index) {
                int row = this.getLocation((int)index).row;
                if (row == 0) {
                    wrapped = true;
                    continue;
                }
                if (!wrapped || row != this.mNumRows - 1) continue;
                return index;
            }
        } else {
            for (int index = this.mFirstVisibleIndex; index <= this.mLastVisibleIndex; ++index) {
                int row = this.getLocation((int)index).row;
                if (row == this.mNumRows - 1) {
                    wrapped = true;
                    continue;
                }
                if (!wrapped || row != 0) continue;
                return index;
            }
        }
        return -1;
    }

    @Override
    protected boolean appendVisibleItemsWithoutCache(int toLimit, boolean oneColumnMode) {
        boolean edgeLimitIsValid;
        int edgeLimit;
        int rowIndex;
        int itemIndex;
        int count = this.mProvider.getCount();
        if (this.mLastVisibleIndex >= 0) {
            if (this.mLastVisibleIndex < this.getLastIndex()) {
                return false;
            }
            itemIndex = this.mLastVisibleIndex + 1;
            rowIndex = this.getLocation((int)this.mLastVisibleIndex).row;
            int edgeLimitSearchIndex = this.findRowEdgeLimitSearchIndex(true);
            if (edgeLimitSearchIndex < 0) {
                edgeLimit = Integer.MIN_VALUE;
                for (int i = 0; i < this.mNumRows; ++i) {
                    int n = edgeLimit = this.mReversedFlow ? this.getRowMin(i) : this.getRowMax(i);
                    if (edgeLimit == Integer.MIN_VALUE) {
                        continue;
                    }
                    break;
                }
            } else {
                int n = edgeLimit = this.mReversedFlow ? this.findRowMin(false, edgeLimitSearchIndex, null) : this.findRowMax(true, edgeLimitSearchIndex, null);
            }
            if ((this.mReversedFlow ? this.getRowMin(rowIndex) <= edgeLimit : this.getRowMax(rowIndex) >= edgeLimit) && ++rowIndex == this.mNumRows) {
                rowIndex = 0;
                edgeLimit = this.mReversedFlow ? this.findRowMin(false, null) : this.findRowMax(true, null);
            }
            edgeLimitIsValid = true;
        } else {
            itemIndex = this.mStartIndex != -1 ? this.mStartIndex : 0;
            rowIndex = (this.mLocations.size() > 0 ? this.getLocation((int)this.getLastIndex()).row + 1 : itemIndex) % this.mNumRows;
            edgeLimit = 0;
            edgeLimitIsValid = false;
        }
        boolean filledOne = false;
        while (true) {
            if (rowIndex < this.mNumRows) {
                int location;
                if (itemIndex == count || !oneColumnMode && this.checkAppendOverLimit(toLimit)) {
                    return filledOne;
                }
                int n = location = this.mReversedFlow ? this.getRowMin(rowIndex) : this.getRowMax(rowIndex);
                if (location == Integer.MAX_VALUE || location == Integer.MIN_VALUE) {
                    if (rowIndex == 0) {
                        int n2 = location = this.mReversedFlow ? this.getRowMin(this.mNumRows - 1) : this.getRowMax(this.mNumRows - 1);
                        if (location != Integer.MAX_VALUE && location != Integer.MIN_VALUE) {
                            location += this.mReversedFlow ? -this.mMargin : this.mMargin;
                        }
                    } else {
                        location = this.mReversedFlow ? this.getRowMax(rowIndex - 1) : this.getRowMin(rowIndex - 1);
                    }
                } else {
                    location += this.mReversedFlow ? -this.mMargin : this.mMargin;
                }
                int size = this.appendVisibleItemToRow(itemIndex++, rowIndex, location);
                filledOne = true;
                if (edgeLimitIsValid) {
                    while (this.mReversedFlow ? location - size > edgeLimit : location + size < edgeLimit) {
                        if (itemIndex == count || !oneColumnMode && this.checkAppendOverLimit(toLimit)) {
                            return filledOne;
                        }
                        size = this.appendVisibleItemToRow(itemIndex++, rowIndex, location += this.mReversedFlow ? -size - this.mMargin : size + this.mMargin);
                    }
                } else {
                    edgeLimitIsValid = true;
                    edgeLimit = this.mReversedFlow ? this.getRowMin(rowIndex) : this.getRowMax(rowIndex);
                }
                ++rowIndex;
                continue;
            }
            if (oneColumnMode) {
                return filledOne;
            }
            edgeLimit = this.mReversedFlow ? this.findRowMin(false, null) : this.findRowMax(true, null);
            rowIndex = 0;
        }
    }

    @Override
    protected boolean prependVisibleItemsWithoutCache(int toLimit, boolean oneColumnMode) {
        boolean edgeLimitIsValid;
        int edgeLimit;
        int rowIndex;
        int itemIndex;
        if (this.mFirstVisibleIndex >= 0) {
            if (this.mFirstVisibleIndex > this.getFirstIndex()) {
                return false;
            }
            itemIndex = this.mFirstVisibleIndex - 1;
            rowIndex = this.getLocation((int)this.mFirstVisibleIndex).row;
            int edgeLimitSearchIndex = this.findRowEdgeLimitSearchIndex(false);
            if (edgeLimitSearchIndex < 0) {
                --rowIndex;
                edgeLimit = Integer.MAX_VALUE;
                for (int i = this.mNumRows - 1; i >= 0; --i) {
                    int n = edgeLimit = this.mReversedFlow ? this.getRowMax(i) : this.getRowMin(i);
                    if (edgeLimit == Integer.MAX_VALUE) {
                        continue;
                    }
                    break;
                }
            } else {
                int n = edgeLimit = this.mReversedFlow ? this.findRowMax(true, edgeLimitSearchIndex, null) : this.findRowMin(false, edgeLimitSearchIndex, null);
            }
            if ((this.mReversedFlow ? this.getRowMax(rowIndex) >= edgeLimit : this.getRowMin(rowIndex) <= edgeLimit) && --rowIndex < 0) {
                rowIndex = this.mNumRows - 1;
                edgeLimit = this.mReversedFlow ? this.findRowMax(true, null) : this.findRowMin(false, null);
            }
            edgeLimitIsValid = true;
        } else {
            itemIndex = this.mStartIndex != -1 ? this.mStartIndex : 0;
            rowIndex = (this.mLocations.size() >= 0 ? this.getLocation((int)this.getFirstIndex()).row + this.mNumRows - 1 : itemIndex) % this.mNumRows;
            edgeLimit = 0;
            edgeLimitIsValid = false;
        }
        boolean filledOne = false;
        while (true) {
            if (rowIndex >= 0) {
                int location;
                if (itemIndex < 0 || !oneColumnMode && this.checkPrependOverLimit(toLimit)) {
                    return filledOne;
                }
                int n = location = this.mReversedFlow ? this.getRowMax(rowIndex) : this.getRowMin(rowIndex);
                if (location == Integer.MAX_VALUE || location == Integer.MIN_VALUE) {
                    if (rowIndex == this.mNumRows - 1) {
                        int n2 = location = this.mReversedFlow ? this.getRowMax(0) : this.getRowMin(0);
                        if (location != Integer.MAX_VALUE && location != Integer.MIN_VALUE) {
                            location += this.mReversedFlow ? this.mMargin : -this.mMargin;
                        }
                    } else {
                        location = this.mReversedFlow ? this.getRowMin(rowIndex + 1) : this.getRowMax(rowIndex + 1);
                    }
                } else {
                    location += this.mReversedFlow ? this.mMargin : -this.mMargin;
                }
                int size = this.prependVisibleItemToRow(itemIndex--, rowIndex, location);
                filledOne = true;
                if (edgeLimitIsValid) {
                    while (this.mReversedFlow ? location + size < edgeLimit : location - size > edgeLimit) {
                        if (itemIndex < 0 || !oneColumnMode && this.checkPrependOverLimit(toLimit)) {
                            return filledOne;
                        }
                        size = this.prependVisibleItemToRow(itemIndex--, rowIndex, location += this.mReversedFlow ? size + this.mMargin : -size - this.mMargin);
                    }
                } else {
                    edgeLimitIsValid = true;
                    edgeLimit = this.mReversedFlow ? this.getRowMax(rowIndex) : this.getRowMin(rowIndex);
                }
                --rowIndex;
                continue;
            }
            if (oneColumnMode) {
                return filledOne;
            }
            edgeLimit = this.mReversedFlow ? this.findRowMax(true, null) : this.findRowMin(false, null);
            rowIndex = this.mNumRows - 1;
        }
    }
}

