/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.support.v17.leanback.transition.LeanbackTransitionHelper;
import android.support.v17.leanback.transition.TransitionHelper;
import android.support.v17.leanback.widget.BrowseFrameLayout;
import android.support.v17.leanback.widget.TitleView;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewGroup;

public class TitleHelper {
    private ViewGroup mSceneRoot;
    private TitleView mTitleView;
    private Object mTitleUpTransition;
    private Object mTitleDownTransition;
    private Object mSceneWithTitle;
    private Object mSceneWithoutTitle;
    static TransitionHelper sTransitionHelper = TransitionHelper.getInstance();
    private final BrowseFrameLayout.OnFocusSearchListener mOnFocusSearchListener = new BrowseFrameLayout.OnFocusSearchListener(){

        @Override
        public View onFocusSearch(View focused, int direction) {
            int forward;
            if (focused != TitleHelper.this.mTitleView && direction == 33) {
                return TitleHelper.this.mTitleView;
            }
            boolean isRtl = ViewCompat.getLayoutDirection((View)focused) == 1;
            int n = forward = isRtl ? 17 : 66;
            if (TitleHelper.this.mTitleView.hasFocus() && direction == 130 || direction == forward) {
                return TitleHelper.this.mSceneRoot;
            }
            return null;
        }
    };

    public TitleHelper(ViewGroup sceneRoot, TitleView titleView) {
        if (sceneRoot == null || titleView == null) {
            throw new IllegalArgumentException("Views may not be null");
        }
        this.mSceneRoot = sceneRoot;
        this.mTitleView = titleView;
        this.createTransitions();
    }

    private void createTransitions() {
        this.mTitleUpTransition = LeanbackTransitionHelper.loadTitleOutTransition(this.mSceneRoot.getContext(), sTransitionHelper);
        this.mTitleDownTransition = LeanbackTransitionHelper.loadTitleInTransition(this.mSceneRoot.getContext(), sTransitionHelper);
        this.mSceneWithTitle = sTransitionHelper.createScene(this.mSceneRoot, new Runnable(){

            @Override
            public void run() {
                TitleHelper.this.mTitleView.setVisibility(0);
            }
        });
        this.mSceneWithoutTitle = sTransitionHelper.createScene(this.mSceneRoot, new Runnable(){

            @Override
            public void run() {
                TitleHelper.this.mTitleView.setVisibility(4);
            }
        });
    }

    public void showTitle(boolean show) {
        if (show) {
            sTransitionHelper.runTransition(this.mSceneWithTitle, this.mTitleDownTransition);
        } else {
            sTransitionHelper.runTransition(this.mSceneWithoutTitle, this.mTitleUpTransition);
        }
    }

    public ViewGroup getSceneRoot() {
        return this.mSceneRoot;
    }

    public TitleView getTitleView() {
        return this.mTitleView;
    }

    public BrowseFrameLayout.OnFocusSearchListener getOnFocusSearchListener() {
        return this.mOnFocusSearchListener;
    }
}

