/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.SearchOrbView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

public class TitleView
extends FrameLayout {
    private ImageView mBadgeView;
    private TextView mTextView;
    private SearchOrbView mSearchOrbView;

    public TitleView(Context context) {
        this(context, null);
    }

    public TitleView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.browseTitleViewStyle);
    }

    public TitleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View rootView = inflater.inflate(R.layout.lb_title_view, (ViewGroup)this);
        this.mBadgeView = (ImageView)rootView.findViewById(R.id.title_badge);
        this.mTextView = (TextView)rootView.findViewById(R.id.title_text);
        this.mSearchOrbView = (SearchOrbView)rootView.findViewById(R.id.title_orb);
        this.setClipToPadding(false);
        this.setClipChildren(false);
    }

    public void setTitle(String titleText) {
        this.mTextView.setText((CharSequence)titleText);
    }

    public CharSequence getTitle() {
        return this.mTextView.getText();
    }

    public void setBadgeDrawable(Drawable drawable2) {
        this.mBadgeView.setImageDrawable(drawable2);
        if (drawable2 != null) {
            this.mBadgeView.setVisibility(0);
            this.mTextView.setVisibility(8);
        } else {
            this.mBadgeView.setVisibility(8);
            this.mTextView.setVisibility(0);
        }
    }

    public Drawable getBadgeDrawable() {
        return this.mBadgeView.getDrawable();
    }

    public void setOnSearchClickedListener(View.OnClickListener listener) {
        this.mSearchOrbView.setOnOrbClickedListener(listener);
    }

    public View getSearchAffordanceView() {
        return this.mSearchOrbView;
    }

    public void setSearchAffordanceColors(SearchOrbView.Colors colors) {
        this.mSearchOrbView.setOrbColors(colors);
    }

    public SearchOrbView.Colors getSearchAffordanceColors() {
        return this.mSearchOrbView.getOrbColors();
    }

    public void enableAnimation(boolean enable) {
        this.mSearchOrbView.enableOrbColorAnimation(enable && this.mSearchOrbView.hasFocus());
    }
}

