/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.support.v17.leanback.R;
import android.support.v17.leanback.system.Settings;
import android.support.v17.leanback.widget.FocusHighlightHelper;
import android.support.v17.leanback.widget.ItemBridgeAdapter;
import android.support.v17.leanback.widget.ObjectAdapter;
import android.support.v17.leanback.widget.OnChildSelectedListener;
import android.support.v17.leanback.widget.OnItemViewClickedListener;
import android.support.v17.leanback.widget.OnItemViewSelectedListener;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.ShadowOverlayContainer;
import android.support.v17.leanback.widget.VerticalGridView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public class VerticalGridPresenter
extends Presenter {
    private static final String TAG = "GridPresenter";
    private static final boolean DEBUG = false;
    private int mNumColumns = -1;
    private int mFocusZoomFactor;
    private boolean mUseFocusDimmer;
    private boolean mShadowEnabled = true;
    private OnItemViewSelectedListener mOnItemViewSelectedListener;
    private OnItemViewClickedListener mOnItemViewClickedListener;
    private boolean mRoundedCornersEnabled = true;
    private ItemBridgeAdapter.Wrapper mWrapper = new ItemBridgeAdapter.Wrapper(){

        @Override
        public View createWrapper(View root) {
            ShadowOverlayContainer wrapper = new ShadowOverlayContainer(root.getContext());
            wrapper.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            wrapper.initialize(VerticalGridPresenter.this.needsDefaultShadow(), true, VerticalGridPresenter.this.areChildRoundedCornersEnabled());
            return wrapper;
        }

        @Override
        public void wrap(View wrapper, View wrapped) {
            ((ShadowOverlayContainer)wrapper).wrap(wrapped);
        }
    };

    public VerticalGridPresenter() {
        this(3);
    }

    public VerticalGridPresenter(int focusZoomFactor) {
        this(focusZoomFactor, true);
    }

    public VerticalGridPresenter(int focusZoomFactor, boolean useFocusDimmer) {
        this.mFocusZoomFactor = focusZoomFactor;
        this.mUseFocusDimmer = useFocusDimmer;
    }

    public void setNumberOfColumns(int numColumns) {
        if (numColumns < 0) {
            throw new IllegalArgumentException("Invalid number of columns");
        }
        if (this.mNumColumns != numColumns) {
            this.mNumColumns = numColumns;
        }
    }

    public int getNumberOfColumns() {
        return this.mNumColumns;
    }

    public final void setShadowEnabled(boolean enabled) {
        this.mShadowEnabled = enabled;
    }

    public final boolean getShadowEnabled() {
        return this.mShadowEnabled;
    }

    public boolean isUsingDefaultShadow() {
        return ShadowOverlayContainer.supportsShadow();
    }

    public final void enableChildRoundedCorners(boolean enable) {
        this.mRoundedCornersEnabled = enable;
    }

    public final boolean areChildRoundedCornersEnabled() {
        return this.mRoundedCornersEnabled;
    }

    public boolean isUsingZOrder(Context context) {
        return ShadowOverlayContainer.supportsDynamicShadow() && !Settings.getInstance(context).preferStaticShadows();
    }

    final boolean needsDefaultShadow() {
        return this.isUsingDefaultShadow() && this.getShadowEnabled();
    }

    public final int getFocusZoomFactor() {
        return this.mFocusZoomFactor;
    }

    public final boolean isFocusDimmerUsed() {
        return this.mUseFocusDimmer;
    }

    @Override
    public final ViewHolder onCreateViewHolder(ViewGroup parent) {
        ViewHolder vh = this.createGridViewHolder(parent);
        vh.mInitialized = false;
        vh.mItemBridgeAdapter = new VerticalGridItemBridgeAdapter();
        this.initializeGridViewHolder(vh);
        if (!vh.mInitialized) {
            throw new RuntimeException("super.initializeGridViewHolder() must be called");
        }
        return vh;
    }

    protected ViewHolder createGridViewHolder(ViewGroup parent) {
        View root = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.lb_vertical_grid, parent, false);
        return new ViewHolder((VerticalGridView)root.findViewById(R.id.browse_grid));
    }

    protected void initializeGridViewHolder(ViewHolder vh) {
        if (this.mNumColumns == -1) {
            throw new IllegalStateException("Number of columns must be set");
        }
        vh.getGridView().setNumColumns(this.mNumColumns);
        vh.mInitialized = true;
        vh.mItemBridgeAdapter.setWrapper(this.mWrapper);
        if (this.needsDefaultShadow() || this.areChildRoundedCornersEnabled()) {
            ShadowOverlayContainer.prepareParentForShadow((ViewGroup)vh.getGridView());
            ((ViewGroup)vh.view).setClipChildren(false);
        }
        vh.getGridView().setFocusDrawingOrderEnabled(!this.isUsingZOrder(vh.getGridView().getContext()));
        FocusHighlightHelper.setupBrowseItemFocusHighlight(vh.mItemBridgeAdapter, this.mFocusZoomFactor, this.mUseFocusDimmer);
        final ViewHolder gridViewHolder = vh;
        vh.getGridView().setOnChildSelectedListener(new OnChildSelectedListener(){

            @Override
            public void onChildSelected(ViewGroup parent, View view, int position, long id2) {
                VerticalGridPresenter.this.selectChildView(gridViewHolder, view);
            }
        });
    }

    @Override
    public void onBindViewHolder(Presenter.ViewHolder viewHolder, Object item) {
        ViewHolder vh = (ViewHolder)viewHolder;
        vh.mItemBridgeAdapter.setAdapter((ObjectAdapter)item);
        vh.getGridView().setAdapter(vh.mItemBridgeAdapter);
    }

    @Override
    public void onUnbindViewHolder(Presenter.ViewHolder viewHolder) {
        ViewHolder vh = (ViewHolder)viewHolder;
        vh.mItemBridgeAdapter.setAdapter(null);
        vh.getGridView().setAdapter(null);
    }

    public final void setOnItemViewSelectedListener(OnItemViewSelectedListener listener) {
        this.mOnItemViewSelectedListener = listener;
    }

    public final OnItemViewSelectedListener getOnItemViewSelectedListener() {
        return this.mOnItemViewSelectedListener;
    }

    public final void setOnItemViewClickedListener(OnItemViewClickedListener listener) {
        this.mOnItemViewClickedListener = listener;
    }

    public final OnItemViewClickedListener getOnItemViewClickedListener() {
        return this.mOnItemViewClickedListener;
    }

    private void selectChildView(ViewHolder vh, View view) {
        if (this.getOnItemViewSelectedListener() != null) {
            ItemBridgeAdapter.ViewHolder ibh;
            ItemBridgeAdapter.ViewHolder viewHolder = ibh = view == null ? null : (ItemBridgeAdapter.ViewHolder)vh.getGridView().getChildViewHolder(view);
            if (ibh == null) {
                this.getOnItemViewSelectedListener().onItemSelected(null, null, null, null);
            } else {
                this.getOnItemViewSelectedListener().onItemSelected(ibh.mHolder, ibh.mItem, null, null);
            }
        }
    }

    public static class ViewHolder
    extends Presenter.ViewHolder {
        ItemBridgeAdapter mItemBridgeAdapter;
        final VerticalGridView mGridView;
        boolean mInitialized;

        public ViewHolder(VerticalGridView view) {
            super((View)view);
            this.mGridView = view;
        }

        public VerticalGridView getGridView() {
            return this.mGridView;
        }
    }

    class VerticalGridItemBridgeAdapter
    extends ItemBridgeAdapter {
        VerticalGridItemBridgeAdapter() {
        }

        @Override
        public void onBind(final ItemBridgeAdapter.ViewHolder itemViewHolder) {
            if (VerticalGridPresenter.this.getOnItemViewClickedListener() != null) {
                View itemView = itemViewHolder.mHolder.view;
                itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (VerticalGridPresenter.this.getOnItemViewClickedListener() != null) {
                            VerticalGridPresenter.this.getOnItemViewClickedListener().onItemClicked(itemViewHolder.mHolder, itemViewHolder.mItem, null, null);
                        }
                    }
                });
            }
        }

        @Override
        public void onUnbind(ItemBridgeAdapter.ViewHolder viewHolder) {
            if (VerticalGridPresenter.this.getOnItemViewClickedListener() != null) {
                viewHolder.mHolder.view.setOnClickListener(null);
            }
        }

        @Override
        public void onAttachedToWindow(ItemBridgeAdapter.ViewHolder viewHolder) {
            viewHolder.itemView.setActivated(true);
        }
    }
}

