/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

class WindowAlignment {
    private int mOrientation = 0;
    public final Axis vertical = new Axis("vertical");
    public final Axis horizontal;
    private Axis mMainAxis = this.horizontal = new Axis("horizontal");
    private Axis mSecondAxis = this.vertical;

    WindowAlignment() {
    }

    public final Axis mainAxis() {
        return this.mMainAxis;
    }

    public final Axis secondAxis() {
        return this.mSecondAxis;
    }

    public final void setOrientation(int orientation) {
        this.mOrientation = orientation;
        if (this.mOrientation == 0) {
            this.mMainAxis = this.horizontal;
            this.mSecondAxis = this.vertical;
        } else {
            this.mMainAxis = this.vertical;
            this.mSecondAxis = this.horizontal;
        }
    }

    public final int getOrientation() {
        return this.mOrientation;
    }

    public final void reset() {
        this.mainAxis().reset();
    }

    public String toString() {
        return new StringBuffer().append("horizontal=").append(this.horizontal.toString()).append("; vertical=").append(this.vertical.toString()).toString();
    }

    public static class Axis {
        private float mScrollCenter;
        private int mMaxEdge;
        private int mMinEdge;
        private int mMaxScroll;
        private int mMinScroll;
        private int mWindowAlignment = 3;
        private int mWindowAlignmentOffset = 0;
        private float mWindowAlignmentOffsetPercent = 50.0f;
        private int mSize;
        private int mPaddingLow;
        private int mPaddingHigh;
        private boolean mReversedFlow;
        private String mName;

        public Axis(String name) {
            this.reset();
            this.mName = name;
        }

        public final int getWindowAlignment() {
            return this.mWindowAlignment;
        }

        public final void setWindowAlignment(int windowAlignment) {
            this.mWindowAlignment = windowAlignment;
        }

        public final int getWindowAlignmentOffset() {
            return this.mWindowAlignmentOffset;
        }

        public final void setWindowAlignmentOffset(int offset) {
            this.mWindowAlignmentOffset = offset;
        }

        public final void setWindowAlignmentOffsetPercent(float percent) {
            if ((percent < 0.0f || percent > 100.0f) && percent != -1.0f) {
                throw new IllegalArgumentException();
            }
            this.mWindowAlignmentOffsetPercent = percent;
        }

        public final float getWindowAlignmentOffsetPercent() {
            return this.mWindowAlignmentOffsetPercent;
        }

        public final int getScrollCenter() {
            return (int)this.mScrollCenter;
        }

        public final void setMinEdge(int minEdge) {
            this.mMinEdge = minEdge;
        }

        public final int getMinEdge() {
            return this.mMinEdge;
        }

        public final void setMinScroll(int minScroll) {
            this.mMinScroll = minScroll;
        }

        public final int getMinScroll() {
            return this.mMinScroll;
        }

        public final void invalidateScrollMin() {
            this.mMinEdge = Integer.MIN_VALUE;
            this.mMinScroll = Integer.MIN_VALUE;
        }

        public final void setMaxEdge(int maxEdge) {
            this.mMaxEdge = maxEdge;
        }

        public final int getMaxEdge() {
            return this.mMaxEdge;
        }

        public final void setMaxScroll(int maxScroll) {
            this.mMaxScroll = maxScroll;
        }

        public final int getMaxScroll() {
            return this.mMaxScroll;
        }

        public final void invalidateScrollMax() {
            this.mMaxEdge = Integer.MAX_VALUE;
            this.mMaxScroll = Integer.MAX_VALUE;
        }

        public final float updateScrollCenter(float scrollTarget) {
            this.mScrollCenter = scrollTarget;
            return scrollTarget;
        }

        private void reset() {
            this.mScrollCenter = -2.1474836E9f;
            this.mMinEdge = Integer.MIN_VALUE;
            this.mMaxEdge = Integer.MAX_VALUE;
        }

        public final boolean isMinUnknown() {
            return this.mMinEdge == Integer.MIN_VALUE;
        }

        public final boolean isMaxUnknown() {
            return this.mMaxEdge == Integer.MAX_VALUE;
        }

        public final void setSize(int size) {
            this.mSize = size;
        }

        public final int getSize() {
            return this.mSize;
        }

        public final void setPadding(int paddingLow, int paddingHigh) {
            this.mPaddingLow = paddingLow;
            this.mPaddingHigh = paddingHigh;
        }

        public final int getPaddingLow() {
            return this.mPaddingLow;
        }

        public final int getPaddingHigh() {
            return this.mPaddingHigh;
        }

        public final int getClientSize() {
            return this.mSize - this.mPaddingLow - this.mPaddingHigh;
        }

        public final int getSystemScrollPos(boolean isAtMin, boolean isAtMax) {
            return this.getSystemScrollPos((int)this.mScrollCenter, isAtMin, isAtMax);
        }

        public final int getSystemScrollPos(int scrollCenter, boolean isAtMin, boolean isAtMax) {
            int middlePosition;
            if (!this.mReversedFlow) {
                middlePosition = this.mWindowAlignmentOffset >= 0 ? this.mWindowAlignmentOffset - this.mPaddingLow : this.mSize + this.mWindowAlignmentOffset - this.mPaddingLow;
                if (this.mWindowAlignmentOffsetPercent != -1.0f) {
                    middlePosition += (int)((float)this.mSize * this.mWindowAlignmentOffsetPercent / 100.0f);
                }
            } else {
                middlePosition = this.mWindowAlignmentOffset >= 0 ? this.mSize - this.mWindowAlignmentOffset - this.mPaddingLow : -this.mWindowAlignmentOffset - this.mPaddingLow;
                if (this.mWindowAlignmentOffsetPercent != -1.0f) {
                    middlePosition -= (int)((float)this.mSize * this.mWindowAlignmentOffsetPercent / 100.0f);
                }
            }
            int clientSize = this.getClientSize();
            int afterMiddlePosition = clientSize - middlePosition;
            boolean isMinUnknown = this.isMinUnknown();
            boolean isMaxUnknown = this.isMaxUnknown();
            if (!isMinUnknown && !isMaxUnknown && (this.mWindowAlignment & 3) == 3 && this.mMaxEdge - this.mMinEdge <= clientSize) {
                return this.mReversedFlow ? this.mMaxEdge - this.mPaddingLow - clientSize : this.mMinEdge - this.mPaddingLow;
            }
            if (!isMinUnknown && (!this.mReversedFlow ? (this.mWindowAlignment & 1) != 0 : (this.mWindowAlignment & 2) != 0) && (isAtMin || scrollCenter - this.mMinEdge <= middlePosition)) {
                return this.mMinEdge - this.mPaddingLow;
            }
            if (!isMaxUnknown && (!this.mReversedFlow ? (this.mWindowAlignment & 2) != 0 : (this.mWindowAlignment & 1) != 0) && (isAtMax || this.mMaxEdge - scrollCenter <= afterMiddlePosition)) {
                return this.mMaxEdge - this.mPaddingLow - clientSize;
            }
            return scrollCenter - middlePosition - this.mPaddingLow;
        }

        public final void setReversedFlow(boolean reversedFlow) {
            this.mReversedFlow = reversedFlow;
        }

        public String toString() {
            return "center: " + this.mScrollCenter + " min:" + this.mMinEdge + " max:" + this.mMaxEdge;
        }
    }
}

