/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.jdbcx.EedInfo;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;

public class ASEMessageText
extends MessageFormat {
    public static final int DB_BASE_ERR = 11;
    public static final int SQL_VENDOR_CODE = 105;
    private static final Hashtable ERR_MAP = new Hashtable();
    private Object[] _arguments;
    private String _formatPattern;

    public ASEMessageText(String string) {
        super(string);
        this._formatPattern = string;
        this._arguments = null;
    }

    public ASEMessageText(String string, Object object) {
        super(string);
        this._formatPattern = string;
        Object[] objectArray = new Object[]{object};
        this.setArguments(objectArray);
    }

    public ASEMessageText(String string, Object object, Object object2) {
        super(string);
        this._formatPattern = string;
        Object[] objectArray = new Object[]{object, object2};
        this.setArguments(objectArray);
    }

    public ASEMessageText(String string, Object object, Object object2, Object object3) {
        super(string);
        this._formatPattern = string;
        Object[] objectArray = new Object[]{object, object2, object3};
        this.setArguments(objectArray);
    }

    public ASEMessageText(String string, Object object, Object object2, Object object3, Object object4) {
        super(string);
        this._formatPattern = string;
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        this.setArguments(objectArray);
    }

    public static String addSingleQuotes(String string) {
        return ASEMessageText._quote(string, '\'', true, true);
    }

    private static String _quote(String string, char c, boolean bl, boolean bl2) {
        if (!(bl || string != null && string.indexOf(c) != -1)) {
            return string;
        }
        int n = string.length();
        char[] cArray = new char[n * 2 + 2];
        int n2 = 0;
        if (bl) {
            cArray[n2++] = c;
        }
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            cArray[n2++] = c2;
            if (!bl2 || c2 != c) continue;
            cArray[n2++] = c;
        }
        if (bl) {
            cArray[n2++] = c;
        }
        return new String(cArray, 0, n2);
    }

    @Override
    public void applyPattern(String string) {
        this._formatPattern = string;
        super.applyPattern(string);
    }

    public void setArguments(Object[] objectArray) {
        this._arguments = objectArray;
    }

    public String toString() {
        if (this._arguments == null) {
            return this._formatPattern;
        }
        this.applyPattern(this._formatPattern.replaceAll("'", "''"));
        return this.format(this._arguments);
    }

    public static String toString(Throwable throwable) {
        return ASEMessageText.toString(throwable, false);
    }

    public static String toString(Throwable throwable, boolean bl) {
        String string = "";
        Throwable throwable2 = throwable;
        if (throwable2 != null) {
            string = throwable2 instanceof SQLException ? string + ASEMessageText.getSQLExceptionMessage((SQLException)throwable2, bl) : string + throwable2.getMessage() + '\n';
        }
        return string;
    }

    public static boolean isWarning(SQLException sQLException) {
        if (sQLException instanceof EedInfo) {
            return ((EedInfo)sQLException).getSeverity() >= 11;
        }
        return false;
    }

    public static boolean containsMessageId(SQLException sQLException, int n) {
        while (sQLException != null) {
            EedInfo eedInfo;
            if (sQLException instanceof EedInfo && (eedInfo = (EedInfo)sQLException).getSeverity() >= 11 && n == sQLException.getErrorCode()) {
                return true;
            }
            sQLException = sQLException.getNextException();
        }
        return false;
    }

    public static String getFriendlyMessage(SQLException sQLException) {
        Enumeration enumeration = ERR_MAP.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (!ASEMessageText.containsMessageId(sQLException, n)) continue;
            return ASEUtils.getString((String)ERR_MAP.get(n));
        }
        return null;
    }

    public static String getSQLExceptionMessage(SQLException sQLException) {
        return ASEMessageText.getSQLExceptionMessage(sQLException, false);
    }

    public static String getSQLExceptionMessage(SQLException sQLException, boolean bl) {
        String string = "";
        String string2 = "";
        while (sQLException != null) {
            if (sQLException instanceof EedInfo) {
                EedInfo eedInfo = (EedInfo)sQLException;
                if (bl && eedInfo.getSeverity() >= 11) {
                    boolean bl2 = true;
                    string = string + "Msg " + sQLException.getErrorCode() + ", Level " + eedInfo.getSeverity() + ", State " + eedInfo.getState() + ":\n";
                    if (eedInfo.getServerName() != null) {
                        string = string + ", Server " + eedInfo.getServerName();
                        bl2 = false;
                    }
                    if (eedInfo.getProcedureName() != null) {
                        string = string + (bl2 ? "" : ", ") + "Procedure " + eedInfo.getProcedureName();
                        bl2 = false;
                    }
                    string = string + (bl2 ? "" : ", ") + "Line " + eedInfo.getLineNumber() + ", Status " + eedInfo.getStatus() + ", TranState " + eedInfo.getTranState() + ":\n";
                }
                string = string + string2 + sQLException.getMessage();
            } else if (sQLException.getSQLState() == null || !bl) {
                string = string + string2 + sQLException.getMessage();
            } else if (!sQLException.getSQLState().equals("010P4")) {
                string = string + string2 + "SqlState: " + sQLException.getSQLState() + ", ErrorCode: " + sQLException.getErrorCode() + ", " + sQLException.getMessage();
            }
            if (sQLException.getErrorCode() == 105) {
                string = string + ASEUtils.getString("MSG_QUOTED_IDENTIFIERS_NOT_SUPPORTED");
            }
            if ((sQLException = sQLException.getNextException()) == null || string.endsWith("\n")) continue;
            string2 = "\n";
        }
        return string;
    }

    static {
        ERR_MAP.put(new Integer(10330), "ERR_PERMISSION");
        ERR_MAP.put(new Integer(10331), "ERR_PERMISSION");
        ERR_MAP.put(new Integer(10332), "ERR_PERMISSION");
    }
}

