/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin;

import com.sybase.aseplugin.BundleManager;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class ASEUtils {
    private static final String STR_EMPTY = "";
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String[] DEFAULT_COMMAND_ROUTINES = new String[]{"certreq", "certauth", "bcp", "cmd", "command", "sh", "configssl", "optdiag", "extrjava", "extractjava"};
    public static final boolean OS_WINDOWS = OS_NAME.indexOf("Windows") != -1;
    public static final boolean OS_MAC_OS_X = System.getProperty("mrj.version") != null;
    public static final boolean OS_AIX = OS_NAME.indexOf("AIX") != -1;
    private static Desktop _desktop = null;
    public static final char[] UNIX_META_CHAR = new char[]{'|', '&', ';', '<', '>', '(', ')', '[', '{', '$', '*', '?', '~', '`', '\\', '\"', '\'', ' ', '\t', '\n', '\r'};
    public static final char[] WIN_META_CHAR = new char[]{' ', '^', '&'};

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.equals(STR_EMPTY);
    }

    public static boolean isNormalPath(String string) {
        return string != null && string.length() > 0 && string.indexOf("..") < 0;
    }

    public static boolean isExistingFile(String string) {
        if (!ASEUtils.isNormalPath(string)) {
            return false;
        }
        File file = new File(string);
        return file.isFile();
    }

    public static boolean isReadableFile(String string) {
        if (!ASEUtils.isNormalPath(string)) {
            return false;
        }
        File file = new File(string);
        return file.canRead();
    }

    public static boolean isWritableFile(String string) {
        if (!ASEUtils.isNormalPath(string)) {
            return false;
        }
        File file = new File(string);
        return file.canWrite();
    }

    public static boolean isExistingDirectory(String string) {
        if (string == null) {
            return false;
        }
        if (string.isEmpty()) {
            return true;
        }
        if (string.indexOf("..") >= 0) {
            return false;
        }
        File file = new File(string);
        return file.isDirectory();
    }

    public static boolean canExistingDirectoryWrite(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return true;
        }
        if (!ASEUtils.isNormalPath(string)) {
            return false;
        }
        File file = new File(string);
        return file.isDirectory() && file.canWrite();
    }

    public static String getDirectoryFromPath(String string) {
        File file = new File(string);
        String string2 = file.getParent();
        return string2 == null ? STR_EMPTY : string2;
    }

    public static String getFileFromPath(String string) {
        File file = new File(string);
        String string2 = file.getName();
        return string2 == null ? STR_EMPTY : string2;
    }

    public static String getCanonicalPath(String string) {
        File file = new File(string);
        return ASEUtils.getCanonicalPath(file);
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static String utilPath(String string, String string2, String string3) {
        String string4 = string + File.separator + string2 + File.separator + string3;
        return string4;
    }

    public static boolean utilExists(String string, String string2, String string3) {
        if (ASEUtils.isNormalPath(string2)) {
            String string4 = ASEUtils.utilPath(string, string2, string3);
            return ASEUtils.isExistingFile(string4);
        }
        return false;
    }

    public static boolean isExistingFileOrDir(String string) {
        if (!ASEUtils.isNormalPath(string)) {
            return false;
        }
        File file = new File(string);
        return file.exists();
    }

    public static String[] getFileListFromDirectory(String string) {
        if (!ASEUtils.isExistingDirectory(string)) {
            return null;
        }
        File file = new File(string);
        return file.list();
    }

    public static String buildFullPathName(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n = string.length();
        if (n > 0 && string.charAt(n - 1) != File.separatorChar) {
            return string + File.separatorChar + string2;
        }
        return string + string2;
    }

    public static boolean createDirectory(String string) {
        if (!ASEUtils.isNormalPath(string)) {
            return false;
        }
        File file = new File(string);
        return file.mkdirs();
    }

    public static boolean deleteFile(String string) {
        File file = new File(string);
        return file.delete();
    }

    public static BundleManager getBundleMgr() {
        return BundleManager.instance();
    }

    public static String[] execProcess(String[] stringArray, String[] stringArray2) throws Exception {
        String[] stringArray3 = new String[]{STR_EMPTY, STR_EMPTY};
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Runtime runtime = Runtime.getRuntime();
        String[] stringArray4 = ASEUtils.validCommandIsRoutine(stringArray, null);
        if (stringArray4.length > 0) {
            Process process = runtime.exec(stringArray4, stringArray2);
            ASEUtils.handleProcess(process, stringBuffer, stringBuffer2);
            stringArray3[0] = stringBuffer.toString().trim();
            stringArray3[1] = stringBuffer2.toString().trim();
            stringArray3[0] = stringArray3[0].equals(STR_EMPTY) ? null : stringArray3[0].trim();
            stringArray3[1] = stringArray3[1].equals(STR_EMPTY) ? null : stringArray3[1].trim();
        } else {
            stringArray3[0] = ASEUtils.getString("INVALID_COMMAND");
            stringArray3[1] = STR_EMPTY;
        }
        return stringArray3;
    }

    public static String[] execProcess(String string, String[] stringArray) throws Exception {
        return ASEUtils.execProcess(ASEUtils.parseCommandToArray(string), stringArray);
    }

    public static int handleProcess(Process process, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws IOException {
        int n = -1;
        InputStream inputStream = process.getInputStream();
        InputStream inputStream2 = process.getErrorStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        InputStreamReader inputStreamReader2 = new InputStreamReader(inputStream2);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        BufferedReader bufferedReader2 = new BufferedReader(inputStreamReader2);
        while (n == -1) {
            String string;
            if (bufferedReader.ready()) {
                string = bufferedReader.readLine();
                if (string == null || string.length() <= 0) continue;
                stringBuffer.append(string + "\n");
                continue;
            }
            if (bufferedReader2.ready()) {
                string = bufferedReader2.readLine();
                if (string == null || string.length() <= 0) continue;
                stringBuffer2.append(string + "\n");
                continue;
            }
            try {
                n = process.exitValue();
                process.getInputStream().close();
                process.getErrorStream().close();
                process.destroy();
                return n;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return n;
    }

    public static boolean isPathQuoted(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'");
    }

    public static String quotePath(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "\"\"";
        }
        if (ASEUtils.isPathQuoted(string)) {
            return string;
        }
        char[] cArray = UNIX_META_CHAR;
        if (OS_WINDOWS) {
            cArray = WIN_META_CHAR;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (!string.contains(String.valueOf(cArray[i]))) continue;
            if (OS_WINDOWS) {
                string = "\"" + string + "\"";
                break;
            }
            if (string.indexOf(34) >= 0) {
                string = "'" + string + "'";
                break;
            }
            string = "\"" + string + "\"";
            break;
        }
        return string;
    }

    public static String[] parseCommandToArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public static boolean setFilePermission(String string, String string2) {
        try {
            if (OS_WINDOWS) {
                return false;
            }
            if (!ASEUtils.isExistingFile(string) && !ASEUtils.isExistingDirectory(string)) {
                return false;
            }
            string = ASEUtils.quotePath(string);
            ASEUtils.execProcess("chmod " + string2 + " " + string, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static boolean isDesktopSupported(Desktop.Action action) {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        if (_desktop == null) {
            _desktop = Desktop.getDesktop();
        }
        return _desktop.isSupported(action);
    }

    public static boolean desktopOpen(String string, Desktop.Action action) throws IOException {
        if (ASEUtils.isDesktopSupported(action)) {
            if (Desktop.Action.OPEN == action) {
                _desktop.open(new File(string));
                return true;
            }
            if (Desktop.Action.EDIT == action) {
                _desktop.edit(new File(string));
                return true;
            }
        }
        return false;
    }

    public static String getStackTrace(Exception exception) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        System.err.println(exception.getMessage());
        printStream.flush();
        printStream.close();
        try {
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = byteArrayOutputStream.toString();
        return string;
    }

    public static String getString(String string) {
        return ASEUtils.getBundleMgr().getString(string);
    }

    public static char getMnemonic(String string) {
        return Character.toUpperCase(ASEUtils.getBundleMgr().getString(string).charAt(0));
    }

    public static String encryptPassword(String string) {
        String string2 = STR_EMPTY;
        for (int i = 0; i < string.length(); ++i) {
            string2 = string2 + (char)(string.charAt(i) + i);
        }
        return string2;
    }

    public static String decryptPassword(String string) {
        String string2 = STR_EMPTY;
        for (int i = 0; i < string.length(); ++i) {
            string2 = string2 + (char)(string.charAt(i) - i);
        }
        return string2;
    }

    public static String[] validCommandIsRoutine(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = stringArray2;
        boolean bl = false;
        if (null == stringArray2 || stringArray2.length == 0) {
            stringArray3 = DEFAULT_COMMAND_ROUTINES;
        }
        for (int i = 0; i < stringArray3.length; ++i) {
            if (stringArray[0].indexOf(stringArray3[i]) == -1) continue;
            bl = true;
            break;
        }
        if (bl) {
            return stringArray;
        }
        return new String[0];
    }

    public static boolean validateQuery(String string) {
        return string != null;
    }
}

