/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.bo.Support;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class BundleManager {
    public static final String PKG_NAME = "com.sybase.aseplugin";
    public static final String BUNDLE_NAME1 = "ASEResourceBundle";
    public static final String BUNDLE_NAME2 = "RLResourceBundle";
    public static final String BUNDLE_NAME3 = "JSResourceBundle";
    private static BundleManager _instance = new BundleManager();
    private ResourceBundle _asBundle = null;
    private ResourceBundle _rlBundle = null;
    private ResourceBundle _jsBundle = null;
    private String _locale = Locale.getDefault().getLanguage();

    private BundleManager() {
        try {
            Locale locale = Locale.getDefault();
            this._asBundle = ResourceBundle.getBundle("com.sybase.aseplugin.res.ASEResourceBundle", locale);
            this._rlBundle = ResourceBundle.getBundle("com.sybase.aseplugin.res.RLResourceBundle", locale);
            this._jsBundle = ResourceBundle.getBundle("com.sybase.aseplugin.res.JSResourceBundle", locale);
        }
        catch (MissingResourceException missingResourceException) {
            Support.showDetailsError(null, this.getClass(), ASEMessageText.toString(missingResourceException), missingResourceException);
        }
    }

    public static BundleManager instance() {
        return _instance;
    }

    public String getString(String string) {
        String string2 = null;
        try {
            if (this._asBundle != null) {
                string2 = this._asBundle.getString(string);
            }
        }
        catch (MissingResourceException missingResourceException) {
            try {
                if (this._rlBundle != null) {
                    string2 = this._rlBundle.getString(string);
                }
            }
            catch (MissingResourceException missingResourceException2) {
                try {
                    if (this._jsBundle != null) {
                        string2 = this._jsBundle.getString(string);
                    }
                }
                catch (MissingResourceException missingResourceException3) {
                    return null;
                }
            }
        }
        return string2;
    }

    public String getLocale() {
        if (this._locale == null || this._locale.length() == 0) {
            this._locale = "en";
        }
        return this._locale;
    }

    public boolean isSupportedAsianLanguage() {
        boolean bl = this.getLocale().equals(new Locale("ja", "", "").getLanguage()) || this.getLocale().equals(new Locale("ko", "", "").getLanguage()) || this.getLocale().equals(new Locale("zh", "", "").getLanguage());
        return bl;
    }
}

