/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Vector;

public class RegisterASEPlugin {
    private String _sybrootDir;
    public static final String[] SC_SHARED_JARS = new String[]{"JComponents1101.jar"};
    public static final String[] DBISQL_JARS = new String[]{"asa.jar", "aseisqlplugin.jar", "commons-logging.jar", "dsparser.jar", "EccpressoFIPSJca.jar", "EccpressoFIPS.jar", "isql.jar", "jconn4.jar", "jini-core.jar", "jini-ext.jar", "jlogon.jar", "jmxremote.jar", "jmxri.jar", "jodbc.jar", "log4j-1.2.6.jar", "planviewer.jar", "uaf-client.jar", "xml4j.jar", "jmxri.jar", "commons-logging.jar", "log4j-1.2.6.jar", "commons-codec-1.2.jar", "sdcadmin-15.0.1.jar"};
    public static final String ASEP_JAR = "ASEPlugin.jar";
    public static final String[] ASEP_JARS = new String[]{"images.jar", "jdom.jar", "DDLGen.jar"};
    public static final String[] AIX_EXTRA_JARS = new String[]{"sunjce_provider.jar"};
    public static final String ASEP_DIR = "ASEP";
    public static final String SHARED_DIR = "shared";
    public static final String DBISQL_DIR = "DBISQL";
    public static final String SDCADMIN_DIR = "SDCADMIN-15_0";
    public static final String ASEP_JPR = "ASEPlugin.jpr";
    public static final String PLUGINFILE = "PluginFile=";
    public static final String ADD_CLASSPATH = "AdditionalClasspath=";
    public static final String PLUGINID = "PluginId=";
    public static final String PLUGINNAME = "PluginName=Adaptive Server Enterprise 15";
    public static final String PROVIDER = "com.sybase.aseplugin.ASEPlugin";
    public static final String PLUGINCLASS = "PluginClass=com.sybase.aseplugin.ASEPlugin";
    public static final String PROVIDERS = "Providers/";
    public static final String SCJ_NAME_TAG = "Providers/ASE155/Name=";
    public static final String SCJ_CLASSPATH_TAG = "Providers/ASE155/Classpath=";
    public static final String SCJ_ADDCLASSPATH_TAG = "Providers/ASE155/AdditionalClasspath=";
    public static final String SCJ_PROVIDER_TAG = "Providers/ASE155/Provider=";
    public static final String SCJ_ID_TAG = "Providers/ASE155/ProviderId=";

    public RegisterASEPlugin(String string) {
        this._sybrootDir = string;
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_SYBROOT_LOCATION"), string);
        System.out.println(aSEMessageText.toString());
    }

    public void registerASEP() {
        try {
            if (this.checkJarsInClassPath(false)) {
                this.createJPRFile();
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            Support.addLogEntry(0, this.getClass().getName(), exception.toString(), exception.getMessage());
        }
    }

    public void createJPRFile() throws IOException {
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_GENERATE_REGISTRATION_FILE"), ASEP_JPR);
        System.out.println(aSEMessageText.toString());
        String string = this._sybrootDir + File.separator + ASEP_DIR + File.separator + "bin" + File.separator + ASEP_JPR;
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        printWriter.println(PLUGINNAME);
        printWriter.println("PluginId=ASE155");
        printWriter.println(PLUGINCLASS);
        String string2 = File.separator;
        printWriter.println(PLUGINFILE + this.getASEPJarPath(this._sybrootDir, string2));
        printWriter.println(ADD_CLASSPATH + this.getClassPath(this._sybrootDir, string2));
        printWriter.flush();
        aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_FILE_CREATED"), string);
        System.out.println(aSEMessageText.toString());
    }

    private String getASEPJarPath(String string, String string2) {
        String string3 = string + string2 + ASEP_DIR + string2 + "lib" + string2 + ASEP_JAR;
        return string3;
    }

    public boolean checkJarsInClassPath(boolean bl) {
        boolean bl2 = true;
        Vector vector = this.getClassPaths(this._sybrootDir, File.separator, false, true);
        for (String string : vector) {
            ASEMessageText aSEMessageText;
            if (!ASEUtils.isExistingFile(string) && !ASEUtils.isExistingDirectory(string)) {
                bl2 = false;
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_FILE_NOT_FOUND"), string);
                System.out.println(aSEMessageText.toString());
                continue;
            }
            if (!bl) continue;
            aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_FILE_VERIFIED"), string);
            System.out.println(aSEMessageText.toString());
        }
        return bl2;
    }

    Vector getClassPaths(String string, String string2) {
        return this.getClassPaths(string, string2, true, false);
    }

    Vector getClassPaths(String string, String string2, boolean bl, boolean bl2) {
        int n;
        Vector<String> vector = new Vector<String>();
        String string3 = string + string2 + ASEP_DIR + string2 + "lib" + string2;
        String string4 = string + string2 + SHARED_DIR + string2 + "java" + string2;
        String string5 = string + string2 + DBISQL_DIR + string2 + "lib" + string2;
        String string6 = string + string2 + SDCADMIN_DIR + string2 + "lib" + string2;
        String string7 = bl ? File.pathSeparator : "";
        for (n = 0; n < SC_SHARED_JARS.length; ++n) {
            vector.add(string4 + SC_SHARED_JARS[n] + string7);
        }
        for (n = 0; n < DBISQL_JARS.length; ++n) {
            vector.add(string5 + DBISQL_JARS[n] + string7);
        }
        for (n = 0; n < ASEP_JARS.length; ++n) {
            vector.add(string3 + ASEP_JARS[n] + string7);
        }
        if (ASEUtils.OS_AIX) {
            for (n = 0; n < AIX_EXTRA_JARS.length; ++n) {
                vector.add(string5 + AIX_EXTRA_JARS[n] + string7);
            }
        }
        if (bl2) {
            vector.add(string3 + ASEP_JAR + string7);
        }
        return vector;
    }

    String getClassPath(String string, String string2) {
        String string3 = "";
        Vector vector = this.getClassPaths(string, string2);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            string3 = string3 + iterator.next();
        }
        return string3;
    }
}

