/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.ProfileKeys;
import com.sybase.aseplugin.Version;
import java.io.File;
import java.util.HashSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class SystemProfileHelper
implements ProfileKeys {
    private static Preferences _systemPref;
    private static HashSet _validKeys;

    public static String getPreference(String string, String string2) {
        return _systemPref.get(string, string2);
    }

    public static void setPreference(String string, String string2) {
        _systemPref.put(string, string2);
    }

    public static boolean getBooleanPreference(String string) {
        return _systemPref.getBoolean(string, true);
    }

    public static void setBooleanPreference(String string, boolean bl) {
        _systemPref.putBoolean(string, bl);
    }

    public static boolean keyExists(Object object) {
        return _validKeys.contains(object);
    }

    static void removeAllPreferences() {
        SystemProfileHelper.removeSystemPreferences();
        SystemProfileHelper.removeASEPPreferences();
        SystemProfileHelper.removeDSPreferences();
    }

    static void removeSystemPreferences() {
        try {
            _systemPref.removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println(backingStoreException);
        }
    }

    static void removeASEPPreferences() {
        SystemProfileHelper.removeUserPreferences("/com/sybase/aseplugin");
    }

    static void removeDSPreferences() {
        SystemProfileHelper.removeUserPreferences("/calm/sybase/util/ds");
    }

    private static void removeUserPreferences(String string) {
        try {
            Preferences.userRoot().node(string).removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println(backingStoreException);
        }
    }

    static {
        String string;
        if (!ASEUtils.OS_WINDOWS && (string = Version.getEnVariable("SYBASE_JRE6")) != null) {
            string = string + File.separator + ".systemPrefs";
            System.setProperty("java.util.prefs.systemRoot", string);
        }
        _systemPref = Preferences.systemRoot().node("/com/sybase/aseplugin/ProfileHelper");
        _validKeys = new HashSet();
        _validKeys.add("Setting.RememberPassword");
        _validKeys.add("Setting.UseUAF");
        _validKeys.add("Clear.Settings");
    }
}

