/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.CodeDetailsPanel;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.ASEBaseCodeItemSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.central.editor.Editor;
import com.sybase.central.editor.EditorEvent;
import com.sybase.central.editor.EditorFrame;
import com.sybase.central.editor.EditorListener;
import com.sybase.central.editor.SCEditorFrame;
import com.sybase.jdbcx.EedInfo;
import java.awt.Container;
import java.awt.Image;
import java.awt.Toolkit;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import sybase.isql.ISQLImages;

public class ASEBaseCodeContainer
extends ASEBaseContainer2
implements EditorListener {
    private static TreeSet<Integer> _createCmds = new TreeSet();
    static final int EDIT_IN_ISQL = 3007;
    protected static int _mdid;
    protected CodeDetailsPanel _codeDetailsPanel = null;
    protected EditorFrame _editor;
    private String _title = "";
    private String _menuText = "";
    private char _mnemonicText;
    private String _toolTipText = "";
    private Image _editorImage;
    private String _findText = "";
    private boolean _saveObject = true;

    public ASEBaseCodeContainer(ASEBaseContainer2 aSEBaseContainer2, ASEBaseCodeItemSO aSEBaseCodeItemSO, Icon icon) {
        super(aSEBaseContainer2, (SOItemInterface)aSEBaseCodeItemSO, icon);
    }

    public ASEBaseCodeItemSO getCodeSO() {
        return (ASEBaseCodeItemSO)this._so;
    }

    void selectErrorPhrase(SQLException sQLException, Editor editor) {
        String string = sQLException.getMessage().trim();
        int n = 0;
        if (sQLException instanceof EedInfo) {
            n = ((EedInfo)sQLException).getLineNumber();
        }
        if (string.endsWith("'.")) {
            boolean bl;
            int n2 = string.lastIndexOf(39, string.length() - 3);
            String string2 = string.substring(n2 + 1, string.length() - 2);
            int n3 = editor.getCaretPosition();
            editor.setCaretPosition(0);
            if (n > 0) {
                editor.goTo(n);
            }
            if (!(bl = editor.find(string2, true, false, false, true))) {
                editor.setCaretPosition(n3);
            }
        }
    }

    @Override
    public SCMenu getContextMenu() {
        ASEMenu aSEMenu = new ASEMenu();
        if (this.isCodeEditorShowing()) {
            aSEMenu.addItems(this.getCodeDetailsPanel().getEditorSCItem().getContextMenu());
        }
        aSEMenu.addItem((SCMenuItem)this.getEditMenuItem());
        aSEMenu.addItem((SCMenuItem)new ASEMenuItem());
        aSEMenu.addItems(super.getContextMenu());
        return aSEMenu;
    }

    @Override
    public ASEMenuItem[] getCreationMenuItems() {
        return this.getParent().getCreationMenuItems();
    }

    @Override
    public ASEToolBarButton[] getCreationButtons() {
        return this.getParent().getCreationButtons();
    }

    private boolean enableEdit() {
        if (!this.enableDelete()) {
            return false;
        }
        boolean bl = this.getCodeSO().getDatabaseSO().getOption("DB_OP_DDL_IN_TRAN");
        return bl;
    }

    private String getDisabledEditHint() {
        if (!this.enableDelete()) {
            return super.getDisabledDeleteHint();
        }
        if (this.enableEdit()) {
            return "";
        }
        return ASEUtils.getString("CONTEXT_MENU_SAVE_OBJECT_MORE_HINT");
    }

    ASEMenuItem getEditMenuItem() {
        ASEMenuItem aSEMenuItem = new ASEMenuItem(3007, ASEUtils.getString("CONTEXT_MENU_EDIT_WITH_DBISQL_TEXT"), ASEUtils.getString("CONTEXT_MENU_EDIT_WITH_DBISQL_HINT") + this.getDisabledEditHint(), ISQLImages.getImageIcon((String)"isql16"), KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        aSEMenuItem.setEnabled(this.enableEdit());
        return aSEMenuItem;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        if (n == 3007) {
            try {
                String string = this.getCodeSO().getCodeForDBISQL();
                Support.getProvider().openDBISQL(jFrame, this.getConnection(), this.getCodeSO().getDatabaseName(), string, false);
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)jFrame, sQLException.getMessage(), sQLException);
            }
        } else if (CodeDetailsPanel.handlesCommand(n)) {
            this.getCodeDetailsPanel().getEditorSCItem().onCommand(jFrame, n, enumeration, n2);
        } else if (_createCmds.contains(n)) {
            this.getParent().onCommand(jFrame, n, enumeration, n2);
        } else {
            super.onCommand(jFrame, n, enumeration, n2);
        }
    }

    @Override
    public void close() {
        if (this._codeDetailsPanel != null) {
            this._codeDetailsPanel.releaseAllResources();
            this._codeDetailsPanel = null;
        }
        super.close();
    }

    @Override
    public Object[] getDetailsPanels() {
        return new Object[]{this.getCodeDetailsPanel()};
    }

    CodeDetailsPanel getCodeDetailsPanel() {
        if (this._codeDetailsPanel == null) {
            this._codeDetailsPanel = new CodeDetailsPanel();
        }
        return this._codeDetailsPanel;
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        return null;
    }

    @Override
    public String getDisplayName(int n) {
        if (n == 0) {
            return this.getCodeSO().getNameWithOwner();
        }
        return super.getDisplayName(n);
    }

    @Override
    public String toString() {
        return this.getCodeSO().getOwner() + "." + this.getCodeSO().getName();
    }

    @Override
    public Vector getItems(int n) {
        return new Vector();
    }

    public void closeEditor() {
        this._editor = null;
        Support.removeOpenEditor(this._title);
    }

    public void editorSaveRequested(EditorEvent editorEvent) {
        this.saveObject(this.isSaveObject());
    }

    public void editorClosed(EditorEvent editorEvent) {
        this.closeEditor();
    }

    void saveObject(boolean bl) {
        try {
            this.getCodeSO().setSQLText(this._editor.getText());
            if (bl) {
                this._so.create();
            }
            this._editor.setChanged(false);
            if (this._so.getName() != null) {
                this._editor.setFileName(ASEMessageText.addSingleQuotes(this._so.getName()));
                ((SCEditorFrame)this._editor).setTitle(this._title);
            }
            ((SCEditorFrame)this._editor).setVisible(false);
            ((SCEditorFrame)this._editor).dispose();
            this.closeEditor();
            this.getParent().refresh();
        }
        catch (SQLException sQLException) {
            String string = sQLException.getMessage();
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)((SCEditorFrame)this._editor), string, sQLException);
            this.selectErrorPhrase(sQLException, this._editor.getEditor());
        }
    }

    public void openEditor(boolean bl) {
        ASEBaseCodeItemSO aSEBaseCodeItemSO = this.getCodeSO();
        String string = aSEBaseCodeItemSO.getName() == null || aSEBaseCodeItemSO.getName().length() == 0 ? ASEUtils.getString("ASE_UNNAMED") : ASEMessageText.addSingleQuotes(aSEBaseCodeItemSO.getName());
        String string2 = aSEBaseCodeItemSO.getSQLText();
        String string3 = this._title + _mdid++;
        this._editor = Support.getExtendedSQLEditor(string3, this._title, this._editorImage, string2, this.getConnection(), this, string);
        this._editor.setSave(this._menuText, this._mnemonicText, this.getCodeDetailsPanel()._saveToolbarImage, this._menuText, this._toolTipText);
        this._editor.setChanged(bl);
        if (aSEBaseCodeItemSO.getName() == null) {
            this._editor.getEditor().find(this._findText, true, false, false, true);
        }
    }

    public void showEditor() {
        if (ASEUtils.OS_WINDOWS) {
            EditorFrame editorFrame = Support.getOpenEditor(this._title);
            if (editorFrame != null) {
                editorFrame.requestFocus();
            } else {
                this.openEditor(false);
            }
        } else {
            this.openEditor(false);
        }
    }

    protected void setTitleImage(String string, Image image) {
        this._title = Support.getFullTitle(string, this._so.getConnection());
        this._editorImage = image;
    }

    public void setMenuToolTipText(String string, char c, String string2, String string3) {
        this._menuText = string;
        this._mnemonicText = c;
        this._toolTipText = string2;
        this._findText = string3;
    }

    public EditorFrame getEditor() {
        return this._editor;
    }

    boolean isCodeEditorShowing() {
        String string = Support.getViewerSupport().getSelectedDetailsTabName();
        return string != null && string.equals(ASEUtils.getString("TABP_CODE"));
    }

    public boolean isSaveObject() {
        return this._saveObject;
    }

    public void setSaveObject(boolean bl) {
        this._saveObject = bl;
    }

    static {
        _createCmds.add(3061);
        _createCmds.add(3078);
        _createCmds.add(3079);
        _createCmds.add(3066);
        _createCmds.add(3068);
        _createCmds.add(3069);
        _createCmds.add(3082);
        _createCmds.add(3070);
        _createCmds.add(3074);
        _mdid = 0;
    }
}

