/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseDetailsContainer;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEContainerHelper;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.SOCtrInterface;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.central.SCContainer3;
import com.sybase.central.SCContainerListener;
import com.sybase.central.SCHeader;
import com.sybase.central.SCItem;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.central.SCToolBarButton;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public abstract class ASEBaseContainer2
extends ASEBaseItem2
implements SCContainer3 {
    private static final ImageIcon OPEN_FOLDER_ICON = new ImageIcon(ASEImages.getFolderOpenedImage());
    private static final ImageIcon CLOSED_FOLDER_ICON = new ImageIcon(ASEImages.getFolderClosedImage());
    private static final String DELIMITOR = "!";
    protected ASEMenu _creationMenu = null;
    protected ASEToolBarButton[] _creationToolBar;
    protected ASEToolBarButton[] _contextToolBar;
    protected Object[] _detailsPanels;
    protected ASEContainerHelper _helper;
    protected SOCtrInterface _ctrSO;
    private String _name;

    public ASEBaseContainer2(String string, ASEBaseContainer2 aSEBaseContainer2) {
        super(aSEBaseContainer2.getSO(), aSEBaseContainer2);
        this._init(string);
    }

    public ASEBaseContainer2(String string, ASEBaseContainer2 aSEBaseContainer2, SOItemInterface sOItemInterface) {
        super(sOItemInterface, aSEBaseContainer2);
        this._init(string);
    }

    public ASEBaseContainer2(ASEBaseContainer2 aSEBaseContainer2, SOItemInterface sOItemInterface, Icon icon) {
        super(sOItemInterface, aSEBaseContainer2, icon);
        this._init(null);
    }

    public ASEBaseContainer2(ASEBaseDetailsContainer aSEBaseDetailsContainer, SOItemInterface sOItemInterface, Icon icon) {
        super(sOItemInterface, aSEBaseDetailsContainer, icon);
        this._init(null);
    }

    public ASEBaseContainer2(String string, ASEBaseContainer2 aSEBaseContainer2, SOItemInterface sOItemInterface, Icon icon) {
        super(sOItemInterface, aSEBaseContainer2, icon);
        this._init(string);
    }

    private void _init(String string) {
        this._name = string;
        this._helper = new ASEContainerHelper(this);
        this.setHeadingInfo(this.getHeadings());
    }

    private boolean isItemContainer() {
        return this._name == null;
    }

    public void setCtrSO(SOCtrInterface sOCtrInterface) {
        this._ctrSO = sOCtrInterface;
    }

    public SOCtrInterface getCtrSO() {
        return this._ctrSO;
    }

    @Override
    public String getId() {
        return this.getClass().getName() + DELIMITOR + this._name;
    }

    @Override
    public SCMenu getContextMenu() {
        if (this.isItemContainer()) {
            return super.getContextMenu();
        }
        return null;
    }

    @Override
    public String getDisplayName(int n) {
        if (this.isItemContainer()) {
            return super.getDisplayName(n);
        }
        return this._name;
    }

    @Override
    public Icon getImage(boolean bl) {
        if (this._image != null) {
            return this._image;
        }
        return bl ? OPEN_FOLDER_ICON : CLOSED_FOLDER_ICON;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        if (this.isItemContainer() || this.isPastableItemContainer()) {
            return super.getEnabledViewerToolBarButtons(enumeration);
        }
        return 0;
    }

    public boolean isPastableItemContainer() {
        return false;
    }

    @Override
    public void releaseResources() {
        this._name = null;
        this._creationToolBar = null;
        this._contextToolBar = null;
        this._detailsPanels = null;
        this._helper.releaseResources();
        this._helper = null;
        this._creationMenu = null;
    }

    public void open(int n) {
        this.open(n, null);
    }

    public void open(int n, Object[] objectArray) {
        Support.clearStatusBarMessage();
        if (this.isOpened()) {
            String string = this._helper.getStatusBarMessage();
            if (string != null) {
                Support.setStatusBarMessage(string);
            }
            this.setFolderPath();
        } else {
            try {
                Vector vector;
                boolean bl = objectArray == null;
                Vector vector2 = vector = bl ? this.getItems(n) : this.getItems(n, objectArray);
                if (vector != null) {
                    this._helper.addItems(vector);
                    if (bl) {
                        this._helper._applyPreferences();
                    }
                    this.setOpened(bl);
                }
            }
            catch (SQLException sQLException) {
                boolean bl = Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                if (!bl) {
                    this.setImageIcon(CLOSED_FOLDER_ICON);
                    this.redisplayItem((SCItem)this);
                }
                if (Support.isConnectionDead(sQLException) && bl) {
                    this.open(n);
                }
            }
            catch (Exception exception) {
                Support.showDetailsError(this.getConnection(), this.getClass(), exception.getMessage(), exception);
            }
        }
    }

    private void setFolderPath() {
        if (this instanceof ServerBO) {
            return;
        }
        if (this.getSO() != null && this.getConnection() != null) {
            this.getConnection().setLastFolderPath(this.getPath());
        }
    }

    private final String getPath() {
        ASEBaseContainer2 aSEBaseContainer2 = this.getParent();
        String string = "";
        string = aSEBaseContainer2 == null ? this.getDisplayName(0) : aSEBaseContainer2.getPath() + "/" + this.getDisplayName(0);
        return string;
    }

    public final boolean isOpened() {
        return this._helper.isOpened();
    }

    public void close() {
        this._helper.close();
        this._detailsPanels = null;
    }

    public boolean onNotify(JFrame jFrame, int n, int n2) {
        return this._helper.onNotify(jFrame, n, n2);
    }

    public ASEMenuItem[] getCreationMenuItems() {
        return null;
    }

    public String getDisabledCreateHint() {
        return ASEUtils.getString("CONTEXT_MENU_DELETE_MORE_SA_ROLE_HINT");
    }

    public boolean includeCreate() {
        if (this.getCtrSO() == null) {
            SOItemInterface sOItemInterface = this.getSO();
            if (sOItemInterface == null) {
                return true;
            }
            return sOItemInterface.includeCreate();
        }
        return this.getCtrSO().includeCreate();
    }

    public boolean enableCreate() {
        if (this.getCtrSO() == null) {
            SOItemInterface sOItemInterface = this.getSO();
            if (sOItemInterface == null) {
                return true;
            }
            return sOItemInterface.enableCreate();
        }
        return this.getCtrSO().enableCreate();
    }

    public SCMenu getCreationMenu() {
        if (!this.includeCreate()) {
            return null;
        }
        ASEMenuItem[] aSEMenuItemArray = this.getCreationMenuItems();
        if (aSEMenuItemArray == null || aSEMenuItemArray.length == 0) {
            return null;
        }
        this._creationMenu = new ASEMenu();
        for (int i = 0; i < aSEMenuItemArray.length; ++i) {
            ASEMenuItem aSEMenuItem = aSEMenuItemArray[i];
            if (this.enableCreate()) {
                this._creationMenu.addItem((SCMenuItem)aSEMenuItem);
                continue;
            }
            ASEMenuItem aSEMenuItem2 = aSEMenuItem.duplicate(this.getDisabledCreateHint());
            aSEMenuItem2.setEnabled(false);
            this._creationMenu.addItem((SCMenuItem)aSEMenuItem2);
        }
        return this._creationMenu;
    }

    public abstract ASEBaseHeader[] getHeadings();

    public SCHeader[] getHeadingInfo() {
        return this._helper.getHeadingInfo();
    }

    public Enumeration getItems() {
        return this._helper.getItems();
    }

    public void addContainerListener(SCContainerListener sCContainerListener) {
        this._helper.addContainerListener(sCContainerListener);
    }

    public void removeContainerListener(SCContainerListener sCContainerListener) {
        this._helper.removeContainerListener(sCContainerListener);
    }

    public Object[] getDetailsPanels() {
        return null;
    }

    public Object[] getDetailsPanels(JFrame jFrame) {
        return this.getDetailsPanels();
    }

    public void columnWidthsChanged(int[] nArray) {
        this._helper.columnWidthsChanged(nArray);
    }

    public Vector getItems(int n) throws Exception {
        return this.getItems(n, null);
    }

    public Vector getItems(int n, Object[] objectArray) throws Exception {
        Vector<ASEBaseItem2> vector = new Vector<ASEBaseItem2>();
        if (this.getCtrSO() == null) {
            return vector;
        }
        List list = this.getCtrSO().open(n, objectArray);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ASEBaseItem2 aSEBaseItem2 = this.getItemBO((ASEBaseItemSO)iterator.next());
            if (aSEBaseItem2 == null) continue;
            vector.add(aSEBaseItem2);
        }
        return vector;
    }

    ASEBaseItem2 getItemBO(ASEBaseItemSO aSEBaseItemSO) {
        return null;
    }

    public int getSortEndIndex() {
        return this._helper.getSortEndIndex();
    }

    public void setSortEndIndex(int n) {
        this._helper.setSortEndIndex(n);
    }

    public void redisplayItem(SCItem sCItem) {
        this._helper.redisplayItem(sCItem);
    }

    public void refreshLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Thread.currentThread().isAlive()) {
                    ASEBaseContainer2.this.refresh();
                }
            }
        });
    }

    public void refresh() {
        this._helper.refresh();
    }

    public void expand() {
        this._helper.expand();
    }

    public void collapse() {
        this._helper.collapse();
    }

    @Override
    public ASEBasePropertiesDialog2 getPropertiesDialog() {
        return null;
    }

    public ASEBaseItem2 getItem(String string) {
        return this._helper.getItem(string);
    }

    public Object getItem(int n) {
        return this._helper.getItem(n);
    }

    public ASEBaseItem2 getItembyFullName(String string) {
        Iterator iterator = this.getIterator(-1);
        while (iterator.hasNext()) {
            String string2;
            ASEBaseItem2 aSEBaseItem2 = (ASEBaseItem2)iterator.next();
            SOItemInterface sOItemInterface = aSEBaseItem2.getSO();
            if (sOItemInterface == null || (string2 = sOItemInterface.getFullyQualifiedName()) == null || !string2.equals(string)) continue;
            return aSEBaseItem2;
        }
        return null;
    }

    public final SCToolBarButton[] getCreationToolBarButtons() {
        if (!this.includeCreate()) {
            return null;
        }
        if (this._creationToolBar != null) {
            return this._creationToolBar;
        }
        this._creationToolBar = this.getCreationButtons();
        if (this._creationToolBar == null || this._creationToolBar.length == 0) {
            return null;
        }
        for (int i = 0; i < this._creationToolBar.length; ++i) {
            ASEToolBarButton aSEToolBarButton = this._creationToolBar[i];
            if (this.enableCreate()) continue;
            String string = aSEToolBarButton.getToolTipText();
            string = string + this.getDisabledCreateHint();
            aSEToolBarButton.setToolTipText(string);
            aSEToolBarButton.setEnabled(false);
        }
        return this._creationToolBar;
    }

    public ASEToolBarButton[] getCreationButtons() {
        return null;
    }

    public ASEToolBarButton[] getContextButtons() {
        return null;
    }

    public SCMenu[] getContextMenuBarMenus() {
        return null;
    }

    public final SCToolBarButton[] getContextToolBarButtons() {
        if (this._contextToolBar != null) {
            return this._contextToolBar;
        }
        this._contextToolBar = this.getContextButtons();
        if (this._contextToolBar == null || this._contextToolBar.length == 0) {
            return null;
        }
        return this._contextToolBar;
    }

    public int[] getVisibleColumns() {
        return this._helper.getVisibleColumns();
    }

    public void setVisibleColumns(int[] nArray) {
        this._helper.setVisibleColumns(nArray);
    }

    public int getSortedColumn() {
        return this._helper.getSortedColumn();
    }

    String getProfileKeyPrefix() {
        return this._helper.getProfileKeyPrefix();
    }

    void setProfileKeyPrefix(String string) {
        this._helper.setProfileKeyPrefix(string);
    }

    void setHeadingInfo(ASEBaseHeader[] aSEBaseHeaderArray) {
        this._helper.setHeadingInfo(aSEBaseHeaderArray, null, -1, true);
    }

    void setHeadingInfo(ASEBaseHeader[] aSEBaseHeaderArray, int[] nArray) {
        this._helper.setHeadingInfo(aSEBaseHeaderArray, nArray, -1, true);
    }

    void setHeadingInfo(ASEBaseHeader[] aSEBaseHeaderArray, int[] nArray, int n) {
        this._helper.setHeadingInfo(aSEBaseHeaderArray, nArray, n, true);
    }

    void setHeadingInfo(ASEBaseHeader[] aSEBaseHeaderArray, int[] nArray, int n, boolean bl) {
        this._helper.setHeadingInfo(aSEBaseHeaderArray, nArray, n, bl);
    }

    void setOpened(boolean bl) {
        this._helper.setOpened(bl);
    }

    long getTimestamp() {
        return this._helper.getTimestamp();
    }

    void setTimestamp() {
        this._helper.setTimestamp();
    }

    void resetTimestamp() {
        this._helper.resetTimestamp();
    }

    ASEBaseItem2 findItem(String string) {
        return this._helper.findItem(string);
    }

    Iterator getIterator(int n) {
        return this._helper.getIterator(n, true);
    }

    Iterator getIterator(int n, boolean bl) {
        return this._helper.getIterator(n, bl);
    }

    int getItemCount() {
        return this._helper.getItemCount();
    }

    String generateCopyName(int n, String string) {
        return this._helper.generateCopyName(n, string);
    }

    void addItem(SCItem sCItem) {
        this._helper.addItem(sCItem, false);
    }

    void addItem(SCItem sCItem, boolean bl) {
        this._helper.addItem(sCItem, bl);
    }

    void removeItem(SCItem sCItem) {
        this._helper.removeItem(sCItem);
    }

    void clearItems() {
        this._helper.clearItems();
    }

    void select() {
        this._helper.select();
    }
}

