/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDetailsContainer;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.ClipboardHelper;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.SybDDLGenerator;
import com.sybase.aseplugin.bo.dlg.ItemsConfirmDialog;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.go.ASEBaseGridBagPanel;
import com.sybase.aseplugin.so.SODBItemInterface;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.central.SCItem;
import com.sybase.central.SCItem3;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.central.viewer.TransferableItems;
import com.sybase.central.viewer.TransferableSCItem;
import com.sybase.util.ClipboardManager;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JFrame;

public abstract class ASEBaseItem2
implements SCItem3 {
    public static final int CMD_EDIT = 3030;
    public static final int CMD_GENERATE_DDL = 3031;
    ASEMenu _contextMenu;
    Icon _image = null;
    SOItemInterface _so;
    ASEBaseContainer2 _parent;
    ASEBaseDetailsContainer _detailsParent;
    boolean _isPasteEnabled = false;
    String _script = null;

    public ASEBaseItem2(SOItemInterface sOItemInterface, ASEBaseContainer2 aSEBaseContainer2, Icon icon) {
        this._so = sOItemInterface;
        this._parent = aSEBaseContainer2;
        this._image = icon;
    }

    public ASEBaseItem2(SOItemInterface sOItemInterface, ASEBaseContainer2 aSEBaseContainer2) {
        this._so = sOItemInterface;
        this._parent = aSEBaseContainer2;
    }

    public ASEBaseItem2(SOItemInterface sOItemInterface, ASEBaseDetailsContainer aSEBaseDetailsContainer, Icon icon) {
        this._so = sOItemInterface;
        this._detailsParent = aSEBaseDetailsContainer;
        this._image = icon;
    }

    public ASEBaseItem2(SOItemInterface sOItemInterface, ASEBaseDetailsContainer aSEBaseDetailsContainer) {
        this._so = sOItemInterface;
        this._detailsParent = aSEBaseDetailsContainer;
    }

    public final ASConnection getConnection() {
        if (this._so == null) {
            return null;
        }
        return this._so.getConnection();
    }

    public void setImageIcon(Icon icon) {
        this._image = icon;
    }

    public final SOItemInterface getSO() {
        return this._so;
    }

    public Object getAttribute(int n) {
        if (this._so == null) {
            return null;
        }
        return this._so.getAttribute(n);
    }

    public String getId() {
        return this.getKey() + "." + this.toString();
    }

    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 101: {
                this.cutItems(jFrame, enumeration);
                break;
            }
            case 102: {
                this.copyItems(jFrame, enumeration);
                break;
            }
            case 103: 
            case 104: 
            case 105: {
                this.pasteItems(jFrame, enumeration, this.getPastableClassNames(), n);
                break;
            }
            case 106: {
                this.deleteItems(jFrame, enumeration);
                break;
            }
            case 100: 
            case 107: {
                this.showDialog(jFrame, this);
                break;
            }
            case 3031: {
                try {
                    this.generateDDL(this.getSO());
                }
                catch (Exception exception) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), (Container)jFrame, exception.getMessage(), exception);
                }
                break;
            }
        }
    }

    ArrayList getBatchList(int n, Enumeration enumeration) {
        ArrayList arrayList = new ArrayList();
        if (this.isOkToBatch(n)) {
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        } else {
            arrayList.add(this);
        }
        return arrayList;
    }

    void copyItems(JFrame jFrame, Enumeration enumeration) {
        ClipboardHelper.getInstance().setDelayedDelete(false);
        ArrayList arrayList = this.getBatchList(102, enumeration);
        this._copyItems(jFrame, arrayList, null);
    }

    void cutItems(JFrame jFrame, Enumeration enumeration) {
        ArrayList arrayList;
        ArrayList arrayList2 = this.getBatchList(101, enumeration);
        if (this._copyItems(jFrame, arrayList2, arrayList = new ArrayList(arrayList2.size()))) {
            this.deleteObjects(arrayList);
            this.getParent().refresh();
        }
    }

    void deleteItems(JFrame jFrame, Enumeration enumeration) {
        this.deleteItems(jFrame, enumeration, true);
    }

    void deleteItems(JFrame jFrame, Enumeration enumeration, boolean bl) {
        ArrayList arrayList = this.getBatchList(106, enumeration);
        ItemsConfirmDialog itemsConfirmDialog = new ItemsConfirmDialog(Support.createDialogSupport(jFrame), ASEUtils.getString("MSG_OBJECTS"), this, arrayList);
        if (!bl) {
            ASEBaseGridBagPanel aSEBaseGridBagPanel = (ASEBaseGridBagPanel)((Object)itemsConfirmDialog.getPageControllers()[0].getJPanel());
            aSEBaseGridBagPanel.setDisplayPreviewButton(false);
        }
        if (itemsConfirmDialog.start(this)) {
            if (this.getParent() != null) {
                this.getParent().refresh();
            } else if (this.getDetailsParent() != null) {
                this.getDetailsParent().refresh();
            }
        }
    }

    public boolean confirmExecution(ArrayList arrayList, int n) {
        return this.deleteObjects(arrayList);
    }

    boolean _copyItems(JFrame jFrame, ArrayList arrayList, ArrayList arrayList2) {
        TransferableItems transferableItems = new TransferableItems();
        StringBuffer stringBuffer = new StringBuffer(512);
        try {
            int n = arrayList.size();
            block3: for (int i = 0; i < n; ++i) {
                Transferable transferable = (Transferable)arrayList.get(i);
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                int n2 = dataFlavorArray.length;
                for (int j = 0; j < n2; ++j) {
                    Object object = transferable.getTransferData(dataFlavorArray[j]);
                    if (!(object instanceof ASEBaseItem2)) continue;
                    ASEBaseItem2 aSEBaseItem2 = (ASEBaseItem2)object;
                    ASEBaseItem2 aSEBaseItem22 = aSEBaseItem2.duplicateItem(jFrame);
                    if (aSEBaseItem22 != null) {
                        transferableItems.addTransferable((Transferable)new TransferableSCItem((SCItem)aSEBaseItem22));
                    }
                    stringBuffer.append(aSEBaseItem2.getItemScript());
                    if (arrayList2 == null) continue block3;
                    arrayList2.add(aSEBaseItem2);
                    continue block3;
                }
            }
            if (!ClipboardManager.setContents((Clipboard)Support.getViewerSupport().getClipboard(), (Transferable)transferableItems, null)) {
                Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_CLIPBOARD_INACCESSIBLE"));
                return false;
            }
            StringSelection stringSelection = new StringSelection(stringBuffer.toString());
            if (!ClipboardManager.setContents((Clipboard)Toolkit.getDefaultToolkit().getSystemClipboard(), (Transferable)stringSelection, (ClipboardOwner)stringSelection)) {
                Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_CLIPBOARD_INACCESSIBLE"));
                return false;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_COPY_FAILED"), unsupportedFlavorException);
            return false;
        }
        catch (IOException iOException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_COPY_FAILED"), iOException);
            return false;
        }
        return true;
    }

    ASEBaseItem2 duplicateItem(JFrame jFrame) {
        return null;
    }

    void pasteItems(JFrame jFrame, Enumeration enumeration, String[] stringArray, int n) {
        try {
            while (enumeration.hasMoreElements()) {
                Transferable transferable = (Transferable)enumeration.nextElement();
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                DataFlavor dataFlavor = this._findPastableDataFlavor(dataFlavorArray, stringArray);
                if (dataFlavor == null || this.pasteItem(jFrame, transferable.getTransferData(dataFlavor), n)) continue;
                return;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_PASTE_FAILED"), unsupportedFlavorException);
        }
        catch (IOException iOException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_PASTE_FAILED"), iOException);
        }
    }

    boolean arePastable(DataFlavor[] dataFlavorArray, String[] stringArray) {
        return this._findPastableDataFlavor(dataFlavorArray, stringArray) != null;
    }

    DataFlavor _findPastableDataFlavor(DataFlavor[] dataFlavorArray, String[] stringArray) {
        if (dataFlavorArray == null || dataFlavorArray.length == 0 || stringArray == null || stringArray.length == 0) {
            return null;
        }
        int n = stringArray.length;
        for (DataFlavor dataFlavor : dataFlavorArray) {
            String string = dataFlavor.getHumanPresentableName();
            for (int i = 0; i < n; ++i) {
                if (!string.equals(stringArray[i])) continue;
                return dataFlavor;
            }
        }
        return null;
    }

    boolean pasteItem(JFrame jFrame, Object object, int n) {
        return false;
    }

    private boolean getPasteEnabled(Enumeration enumeration) {
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return false;
        }
        while (enumeration.hasMoreElements()) {
            Transferable transferable = (Transferable)enumeration.nextElement();
            if (!this.checkItemPastable(this, (TransferableSCItem)transferable)) {
                return false;
            }
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            if (this.arePastable(dataFlavorArray, this.getPastableClassNames())) continue;
            return false;
        }
        return true;
    }

    private boolean checkItemPastable(ASEBaseItem2 aSEBaseItem2, TransferableSCItem transferableSCItem) {
        ASEBaseItem2 aSEBaseItem22 = (ASEBaseItem2)transferableSCItem.getSCItem();
        return ClipboardHelper.getInstance().isPastable(aSEBaseItem22, aSEBaseItem2);
    }

    public boolean deleteObjects(ArrayList arrayList) {
        boolean bl = true;
        Support.getViewerSupport().startWait();
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                ASEBaseItem2 aSEBaseItem2 = (ASEBaseItem2)arrayList.get(i);
                aSEBaseItem2.getSO().remove();
                continue;
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                bl = false;
            }
        }
        Support.getViewerSupport().endWait();
        return bl;
    }

    protected void showDialog(JFrame jFrame, ASEBaseItem2 aSEBaseItem2) {
        ASEBasePropertiesDialog2 aSEBasePropertiesDialog2 = aSEBaseItem2.getPropertiesDialog();
        if (aSEBasePropertiesDialog2 != null) {
            ASEBaseDialog2.showDialog(jFrame, aSEBasePropertiesDialog2);
        }
    }

    public String getKey() {
        return this.getClass().getName();
    }

    public boolean includeDDLGen() {
        return false;
    }

    public boolean includeDelete() {
        SOItemInterface sOItemInterface = this.getSO();
        return sOItemInterface == null ? true : sOItemInterface.includeDelete();
    }

    public boolean enableDelete() {
        SOItemInterface sOItemInterface = this.getSO();
        return sOItemInterface == null ? true : sOItemInterface.enableDelete();
    }

    public String getDisabledDeleteHint() {
        if (this.getSO() instanceof SODBItemInterface) {
            return ASEUtils.getString("CONTEXT_MENU_DELETE_MORE_DB_HINT");
        }
        return ASEUtils.getString("CONTEXT_MENU_DELETE_MORE_SA_ROLE_HINT");
    }

    public ASEMenuItem getDeleteMenuItem() {
        return ASEMenuItem.getDeleteMenuItem(ASEUtils.getString("CONTEXT_MENU_DELETE_TEXT"), ASEUtils.getString("CONTEXT_MENU_DELETE_HINT"), Support.getMnemonic("DELETE_MNEM"), this.enableDelete(), this.getDisabledDeleteHint());
    }

    public boolean includeProperties() {
        return true;
    }

    public boolean includeCut() {
        return false;
    }

    public boolean enableCut() {
        return this.enableDelete();
    }

    public boolean includeCopy() {
        return this.includeDDLGen();
    }

    public boolean enableCopy() {
        return this.enableDDLGen();
    }

    public boolean enableDDLGen() {
        return true;
    }

    public boolean includePaste() {
        return this._isPasteEnabled;
    }

    public String[] getPastableClassNames() {
        return null;
    }

    public boolean enablePaste() {
        return true;
    }

    public SCMenu getContextMenu() {
        ASEMenuItem aSEMenuItem;
        this._contextMenu = new ASEMenu();
        if (this.includeDDLGen()) {
            aSEMenuItem = ASEMenuItem.getDDLGenMenuItem(this.enableDDLGen());
            aSEMenuItem.setEnabled(this.enableDDLGen());
            this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
        }
        if (this.includeCopy()) {
            aSEMenuItem = ASEMenuItem.getCopyMenuItem();
            aSEMenuItem.setEnabled(this.enableCopy());
            this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
        }
        if (this.includeCut()) {
            aSEMenuItem = ASEMenuItem.getCutMenuItem();
            aSEMenuItem.setEnabled(this.enableCut());
            this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
        }
        if (this.includeDelete()) {
            this._contextMenu.addItem((SCMenuItem)this.getDeleteMenuItem());
        }
        if (this.includePaste()) {
            aSEMenuItem = ASEMenuItem.getPasteMenuItem();
            aSEMenuItem.setEnabled(this.enablePaste());
            this._contextMenu.addItem((SCMenuItem)aSEMenuItem);
        }
        if (this.includeProperties()) {
            if (this._contextMenu.getMenuItems().length > 0) {
                this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            }
            this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
        }
        return this._contextMenu;
    }

    public String getDisplayName(int n) {
        Object object = this._so.getAttributes()[n];
        return object == null ? "" : object.toString();
    }

    public Icon getImage(boolean bl) {
        return this._image;
    }

    public int getAttributes() {
        return 0;
    }

    public int queryDropItems(int n, DataFlavor[] dataFlavorArray) {
        return 0;
    }

    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        int n;
        int n2 = n = this.includeDelete() && this.enableDelete() ? 32 : 0;
        int n3 = this.includeProperties() ? 64 : 0;
        n2 |= n3;
        int n4 = this.includeCopy() ? 8 : 0;
        n2 |= n4;
        this._isPasteEnabled = this.getPasteEnabled(enumeration);
        int n5 = this.includePaste() ? 16 : 0;
        n2 |= n5;
        int n6 = this.includeCut() ? 4 : 0;
        return n2 |= n6;
    }

    public void releaseResources() {
        this._contextMenu = null;
        this._image = null;
        this._parent = null;
        this._so = null;
        this._detailsParent = null;
    }

    public Hashtable getPropertyHashtable() {
        return null;
    }

    public String getItemScript() {
        if (this._script != null) {
            return this._script;
        }
        this._script = this.includeDDLGen() && this.getSO().getConnection() != null ? this.generateDDLString(this.getSO()) : this.getDisplayName(0);
        return this._script;
    }

    public boolean isOkToBatch(int n) {
        return n == 101 || n == 102 || n == 106 || n == 103 || n == 104 || n == 105;
    }

    public ASEBaseContainer2 getParent() {
        return this._parent;
    }

    public ASEBaseDetailsContainer getDetailsParent() {
        return this._detailsParent;
    }

    public abstract ASEBasePropertiesDialog2 getPropertiesDialog();

    public String[] getDDLGenParams(SOItemInterface sOItemInterface) {
        return new String[]{"-N" + sOItemInterface.getFullyQualifiedName(), "-T" + sOItemInterface.getType()};
    }

    String[] getDDLParams(SOItemInterface sOItemInterface) {
        String[] stringArray;
        String[] stringArray2 = this.getDDLGenParams(sOItemInterface);
        String string = sOItemInterface.getConnection().getCharacterSet();
        if (string != null) {
            int n = stringArray2.length + 4;
            stringArray = new String[n];
            stringArray[n - 1] = "-J" + string;
        } else {
            int n = stringArray2.length + 3;
            stringArray = new String[n];
        }
        stringArray[0] = "-U" + sOItemInterface.getConnection().getCurrentUser();
        stringArray[1] = "-P" + sOItemInterface.getConnection().getPassword();
        ServerSO serverSO = (ServerSO)ContainerViewBO.getServerBO(this.getConnection()).getSO();
        String string2 = "";
        if (serverSO.isSSL()) {
            string2 = "ssl:";
        }
        stringArray[2] = "-S" + string2 + this.getConnection().getHostNameAndPortNumber();
        System.arraycopy(stringArray2, 0, stringArray, 3, stringArray2.length);
        return stringArray;
    }

    protected void generateDDL(SOItemInterface sOItemInterface) {
        SybDDLGenerator.generateDDL(this.getDDLParams(sOItemInterface), this.getConnection());
    }

    public String generateDDLString(SOItemInterface sOItemInterface) {
        return SybDDLGenerator.generateDDLString(sOItemInterface.getConnection(), this.getDDLParams(sOItemInterface));
    }

    public String toString() {
        return this._so == null ? "" : this._so.getName();
    }

    Object getAncestor(Class clazz) {
        ASEBaseContainer2 aSEBaseContainer2;
        Class<?> clazz2;
        if (clazz == null) {
            return null;
        }
        if (this._detailsParent != null) {
            clazz2 = this._detailsParent.getClass();
            if (clazz.isAssignableFrom(clazz2)) {
                return this._detailsParent;
            }
            aSEBaseContainer2 = this._detailsParent.getParent();
        } else {
            aSEBaseContainer2 = this._parent;
        }
        while (aSEBaseContainer2 != null) {
            clazz2 = aSEBaseContainer2.getClass();
            if (clazz.isAssignableFrom(clazz2)) {
                return aSEBaseContainer2;
            }
            aSEBaseContainer2 = aSEBaseContainer2.getParent();
        }
        return null;
    }

    public int[] getEnabledContextCmdIds() {
        return null;
    }

    void redisplay() {
        if (this._detailsParent != null) {
            this._detailsParent.redisplayItem((SCItem)this);
        } else if (this._parent != null) {
            this._parent.redisplayItem((SCItem)this);
        }
    }
}

