/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.go.ASEBaseGridBagPanel;
import com.sybase.aseplugin.so.SOInterface;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public abstract class ASEBasePage2
implements SCPageController {
    private ASEBaseDialog2 _parentController;
    private boolean _pageModified;
    private JPanel _jpanel;
    protected String _title;
    protected SOItemInterface _so;
    protected ASEBaseGridBagPanel _goPanel;
    private JButton _previewButton;
    private JButton _scheduleButton;

    public ASEBasePage2(ASEBaseDialog2 aSEBaseDialog2, JPanel jPanel, String string) {
        this._parentController = aSEBaseDialog2;
        this._so = this._parentController.getSO();
        this._jpanel = jPanel;
        this._title = string;
        this._init();
    }

    private void _init() {
        if (this.getJPanel() instanceof ASEBaseGridBagPanel) {
            ASEBaseGridBagPanel aSEBaseGridBagPanel = (ASEBaseGridBagPanel)((Object)this.getJPanel());
            this._previewButton = aSEBaseGridBagPanel.getPreviewButton();
            this._scheduleButton = aSEBaseGridBagPanel.getScheduleButton();
            PSAction pSAction = new PSAction(this.getParent().getDialogType());
            this._previewButton.addActionListener(pSAction);
            this._scheduleButton.addActionListener(pSAction);
        }
    }

    public void setPageModified(boolean bl) {
        this._pageModified = bl;
    }

    public ASEBaseDialog2 getParent() {
        return this._parentController;
    }

    public SCContainer2 getParentCtr() {
        return this._parentController.getParent();
    }

    public SCDialogSupport getDialogSupport() {
        return this.getParent().getDialogSupport();
    }

    public JDialog getJDialog() {
        return this.getDialogSupport().getJDialog();
    }

    protected SOInterface getSO() {
        return this._parentController.getSO();
    }

    protected final ASConnection getConnection() {
        if (this._so == null) {
            return null;
        }
        return this._so.getConnection();
    }

    public JPanel getJPanel() {
        return this._jpanel;
    }

    public boolean isModified() {
        return this._pageModified;
    }

    public void onInitDialog() {
    }

    public boolean onWizardBack() {
        return true;
    }

    public abstract int onWizardNext();

    public boolean onWizardFinish() {
        return true;
    }

    public String getPageTitle() {
        return this._title;
    }

    public abstract boolean onOk();

    public boolean onCancel() {
        return true;
    }

    public boolean onSetActive() {
        this.enableComponents();
        this.setComponentFocus();
        return this.showPage();
    }

    public void enableComponents() {
    }

    public boolean showPage() {
        return true;
    }

    private void setComponentFocus() {
        Component component = Support.getTopLeftMostFocusableComponent(this._jpanel);
        if (component != null) {
            component.requestFocus();
        } else {
            component = this.getOtherFocusableComponent();
            if (component != null) {
                component.requestFocus();
            }
        }
    }

    public abstract Component getOtherFocusableComponent();

    public boolean onKillActive() {
        return true;
    }

    public int getEnabledStandardButtons() {
        return 0;
    }

    public void releaseResources() {
        this._previewButton = null;
        this._scheduleButton = null;
        this._parentController = null;
        this._jpanel = null;
        this._so = null;
        this._goPanel = null;
    }

    public abstract String getHelpID();

    public void onHelp() {
        try {
            Support.showHelpIndex(this.getHelpID(), this.getJDialog());
        }
        catch (IOException iOException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), iOException.getMessage(), iOException);
        }
    }

    public final ASEBaseGridBagPanel getGO() {
        return this._goPanel;
    }

    class PSAction
    implements ActionListener {
        int _type;

        public PSAction(int n) {
            this._type = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SCDialogSupport sCDialogSupport = ASEBasePage2.this.getParent().getDialogSupport();
            if (actionEvent.getSource() == ASEBasePage2.this._previewButton) {
                Support.setEnableSQLPreview(true);
                if (this._type == 1) {
                    JButton jButton = sCDialogSupport.getStandardButtonById(0x1000040);
                    jButton.doClick();
                } else if (this._type == 2) {
                    JButton jButton = sCDialogSupport.getStandardButtonById(4);
                    jButton.doClick();
                }
                Support.setEnableSQLPreview(false);
            } else if (actionEvent.getSource() == ASEBasePage2.this._scheduleButton) {
                Support.setEnableScheduling(true);
                if (this._type == 1) {
                    JButton jButton = sCDialogSupport.getStandardButtonById(0x1000040);
                    jButton.doClick();
                } else if (this._type == 2) {
                    JButton jButton = sCDialogSupport.getStandardButtonById(4);
                    jButton.doClick();
                }
                Support.setEnableScheduling(false);
            }
        }
    }
}

