/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.asa.ASAIconTextUserData;
import com.sybase.asa.ASAUtils;
import com.sybase.aseplugin.ProfileHelper;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDetailsContainer;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.so.DateSorter;
import com.sybase.central.SCContainerEvent;
import com.sybase.central.SCContainerListener;
import com.sybase.central.SCHeader;
import com.sybase.central.SCItem;
import com.sybase.central.SCProfile;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;

public class ASEContainerHelper {
    private static final Pattern REGEX_SUFFIX = Pattern.compile("_copy(_[0-9]+)?\\z", 2);
    private static final String STR_DOT_COLUMNS = ".columns";
    private static final String STR_DOT_WIDTHS = ".widths";
    private static final String STR_DOT_SORT = ".sort";
    private static final SCProfile _profile = ProfileHelper.getProfile();
    private boolean _isOpened = false;
    private long _timestamp = 0L;
    private Vector _items;
    private Vector _containerListeners;
    private ASEBaseContainer2 _container;
    private ASEBaseDetailsContainer _detailsContainer;
    private String _profileKeyPrefix;
    private String _columnsProfileKey;
    private String _widthsProfileKey;
    private String _sortProfileKey;
    private ASEBaseHeader[] _header;
    private int[] _defaultVisibleColumns;
    private int[] _visibleColumns;
    private int _defaultSortedColumn;
    private int _sortedColumn;
    private String _statusBarMessage = null;
    private int _sortEndIndex;

    ASEContainerHelper(ASEBaseContainer2 aSEBaseContainer2) {
        this._container = aSEBaseContainer2;
        this._sortEndIndex = -1;
        this._init();
    }

    ASEContainerHelper(ASEBaseDetailsContainer aSEBaseDetailsContainer) {
        this._detailsContainer = aSEBaseDetailsContainer;
        this._init();
    }

    private void _init() {
        if (this._container != null) {
            this.setProfileKeyPrefix(this._container.getClass().getName());
        } else {
            this.setProfileKeyPrefix(this._detailsContainer.getClass().getName());
        }
        this._items = new Vector();
        this._containerListeners = new Vector();
    }

    String getProfileKeyPrefix() {
        return this._profileKeyPrefix;
    }

    void setProfileKeyPrefix(String string) {
        this._profileKeyPrefix = string;
        this._columnsProfileKey = this._profileKeyPrefix + STR_DOT_COLUMNS;
        this._widthsProfileKey = this._profileKeyPrefix + STR_DOT_WIDTHS;
        this._sortProfileKey = this._profileKeyPrefix + STR_DOT_SORT;
    }

    void setHeadingInfo(ASEBaseHeader[] aSEBaseHeaderArray, int[] nArray, int n, boolean bl) {
        int[] nArray2;
        if (aSEBaseHeaderArray == null) {
            return;
        }
        this._header = aSEBaseHeaderArray;
        if (nArray != null) {
            int n2 = nArray.length;
            nArray2 = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray2[i] = this._getHeaderIndexForHeaderId(nArray[i]);
            }
        } else {
            int n3 = aSEBaseHeaderArray.length;
            nArray2 = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray2[i] = i;
            }
        }
        this._defaultVisibleColumns = nArray2;
        this._visibleColumns = nArray2;
        if (n != -1) {
            this._defaultSortedColumn = this._getSortedColumnForHeaderIdAndSortOrder(n, bl);
        }
    }

    String getStatusBarMessage() {
        return this._statusBarMessage;
    }

    void setStatusBarMessage(String string) {
        Support.setStatusBarMessage(string);
        this._statusBarMessage = string;
    }

    boolean isOpened() {
        return this._isOpened;
    }

    void setOpened(boolean bl) {
        this._isOpened = bl;
    }

    long getTimestamp() {
        return this._timestamp;
    }

    void setTimestamp() {
        this._timestamp = System.currentTimeMillis();
    }

    void resetTimestamp() {
        this._timestamp = 0L;
    }

    ASEBaseItem2 findItem(String string) {
        if (!this._isOpened) {
            return null;
        }
        for (ASEBaseItem2 aSEBaseItem2 : this._items) {
            if (!aSEBaseItem2.getDisplayName(0).equalsIgnoreCase(string)) continue;
            return aSEBaseItem2;
        }
        return null;
    }

    boolean selectItem(String string) {
        if (this._detailsContainer != null) {
            return false;
        }
        ASEBaseItem2 aSEBaseItem2 = this.getItem(string);
        if (aSEBaseItem2 == null || !(aSEBaseItem2 instanceof ASEBaseContainer2)) {
            return false;
        }
        return this.selectItem((ASEBaseContainer2)aSEBaseItem2);
    }

    boolean selectItem(ASEBaseContainer2 aSEBaseContainer2) {
        ASEBaseContainer2 aSEBaseContainer22;
        Stack<ASEBaseContainer2> stack = new Stack<ASEBaseContainer2>();
        stack.push(aSEBaseContainer2);
        for (aSEBaseContainer22 = aSEBaseContainer2.getParent(); aSEBaseContainer22 != null; aSEBaseContainer22 = aSEBaseContainer22.getParent()) {
            stack.push(aSEBaseContainer22);
        }
        while (!stack.empty()) {
            aSEBaseContainer22 = (ASEBaseContainer2)stack.pop();
            aSEBaseContainer22.expand();
        }
        this._notifyChangeListeners(7, (SCItem)aSEBaseContainer2);
        return true;
    }

    Object getItem(int n) {
        return this._items.elementAt(n);
    }

    ASEBaseItem2 getItem(String string) {
        for (ASEBaseItem2 aSEBaseItem2 : this._items) {
            if (!aSEBaseItem2.getDisplayName(0).equals(string)) continue;
            return aSEBaseItem2;
        }
        return null;
    }

    Iterator getIterator(int n, boolean bl) {
        if (n != -1) {
            this.sortItems(n, bl);
        }
        return this._items.iterator();
    }

    Vector getIconTextUserDataItems(int n, boolean bl) throws SQLException {
        if (!(this._isOpened && this._timestamp != 0L || this._container != null)) {
            this._detailsContainer.populate();
        }
        if (n != -1) {
            this.sortItems(n, bl);
        }
        Vector<ASAIconTextUserData> vector = new Vector<ASAIconTextUserData>(this._items.size());
        for (ASEBaseItem2 aSEBaseItem2 : this._items) {
            vector.add(new ASAIconTextUserData(aSEBaseItem2.getImage(false), aSEBaseItem2.getDisplayName(0), (Object)aSEBaseItem2));
        }
        return vector;
    }

    int getItemCount() {
        return this._items.size();
    }

    String generateCopyName(int n, String string) {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        Iterator iterator = this._items.iterator();
        Matcher matcher = REGEX_SUFFIX.matcher(string);
        String string2 = matcher.find() ? string.substring(0, matcher.start()) : string;
        String string3 = string2 + "_copy";
        int n3 = string3.length();
        while (iterator.hasNext()) {
            ASEBaseItem2 aSEBaseItem2 = (ASEBaseItem2)iterator.next();
            String string4 = aSEBaseItem2.getDisplayName(n);
            if (string4.equals(string2)) {
                bl = true;
                continue;
            }
            if (string4.equals(string3)) {
                bl2 = true;
                continue;
            }
            if (string4.length() < n3 + 2 || !string4.regionMatches(true, 0, string3, 0, n3) || string4.charAt(n3) != '_') continue;
            try {
                int n4 = Integer.parseInt(string4.substring(n3 + 1));
                n2 = Math.max(n2, n4);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!bl) {
            return string2;
        }
        if (!bl2) {
            return string3;
        }
        return string3 + '_' + String.valueOf(n2 + 1);
    }

    void addItems(Vector vector) {
        this.clearItems();
        this._items.addAll(vector);
    }

    void addItem(SCItem sCItem, boolean bl) {
        this._items.add(sCItem);
        if (bl) {
            this._notifyChangeListeners(1, sCItem);
        }
    }

    void removeItem(SCItem sCItem) {
        this._items.remove(sCItem);
        this._notifyChangeListeners(2, sCItem);
    }

    void clearItems() {
        this._items.clear();
    }

    void sortItems(int n, boolean bl) {
        int n2 = this._getSortedColumnForHeaderIdAndSortOrder(n, bl);
        this.sort(n2);
    }

    void sort(int n) {
        if (n != 0 && this._items.size() > 1) {
            Vector vector = null;
            int n2 = 0;
            if (this._sortEndIndex > 0) {
                vector = new Vector();
                int n3 = this._sortEndIndex - n2;
                int n4 = this._items.size() - n3;
                for (int i = 0; i < n4; ++i) {
                    vector.add(this._items.elementAt(n3));
                    this._items.remove(n3);
                }
            }
            Collections.sort(this._items, new ItemComparator(this._header, Math.abs(n) - 1, n > 0));
            if (vector != null) {
                this._items.addAll(vector);
            }
        }
        this._sortedColumn = n;
    }

    void refresh() {
        if (this._container != null) {
            this._notifyChangeListeners(3, (SCItem)this._container);
        } else {
            this._notifyChangeListeners(3, null);
        }
    }

    void redisplayItem(SCItem sCItem) {
        this._notifyChangeListeners(6, sCItem);
    }

    void expand() {
        this._notifyChangeListeners(4, (SCItem)this._container);
    }

    void collapse() {
        this._notifyChangeListeners(5, (SCItem)this._container);
    }

    void select() {
        this._notifyChangeListeners(7, (SCItem)this._container);
    }

    void open(int n) {
        this._applyPreferences();
        this._isOpened = true;
    }

    void close() {
        this.clearItems();
        this._isOpened = false;
    }

    boolean onNotify(JFrame jFrame, int n, int n2) {
        switch (n) {
            case 205: {
                this.sort(n2);
                _profile.writeString(this._sortProfileKey, String.valueOf(n2));
                return false;
            }
            case 100: {
                boolean bl;
                this.resetStatusBarMessage();
                Support.getViewerSupport().startWait();
                if (this._container != null) {
                    this._container.open(1);
                    bl = this._container.isOpened();
                } else {
                    bl = this._detailsContainer.open();
                }
                Support.getViewerSupport().endWait();
                if (bl) {
                    this._applyPreferences();
                    return true;
                }
                return false;
            }
            case 207: {
                this.resetStatusBarMessage();
                this._applyPreferences();
                return true;
            }
        }
        return true;
    }

    private void resetStatusBarMessage() {
        String string;
        Support.clearStatusBarMessage();
        if (this.isOpened() && (string = this.getStatusBarMessage()) != null) {
            Support.setStatusBarMessage(string);
        }
    }

    SCHeader[] getHeadingInfo() {
        return this._header;
    }

    Enumeration getItems() {
        return this._items.elements();
    }

    void addContainerListener(SCContainerListener sCContainerListener) {
        this._containerListeners.add(sCContainerListener);
    }

    void removeContainerListener(SCContainerListener sCContainerListener) {
        this._containerListeners.remove(sCContainerListener);
    }

    void columnWidthsChanged(int[] nArray) {
        int n;
        int n2 = this._header.length;
        int[] nArray2 = new int[n2];
        int n3 = nArray.length;
        for (n = 0; n < n3; ++n) {
            this._header[this._getHeaderIndexForDisplayIndex(n)].setWidth(nArray[n]);
        }
        for (n = 0; n < n2; ++n) {
            nArray2[n] = this._header[n].getWidth();
        }
        _profile.writeString(this._widthsProfileKey, ASAUtils.buildProfileIntegerList((int[])nArray2));
    }

    int[] getVisibleColumns() {
        return this._visibleColumns;
    }

    void setVisibleColumns(int[] nArray) {
        this._visibleColumns = nArray;
        _profile.writeString(this._columnsProfileKey, ASAUtils.buildProfileIntegerList((int[])nArray));
    }

    int getSortedColumn() {
        return this._sortedColumn;
    }

    void releaseResources() {
    }

    private void _notifyChangeListeners(int n, SCItem sCItem) {
        SCContainerEvent sCContainerEvent = new SCContainerEvent((Object)this, n, sCItem);
        Enumeration enumeration = this._containerListeners.elements();
        while (enumeration.hasMoreElements()) {
            SCContainerListener sCContainerListener = (SCContainerListener)enumeration.nextElement();
            sCContainerListener.containerChanged(sCContainerEvent);
        }
    }

    private int _getHeaderIndexForHeaderId(int n) {
        int n2 = this._header.length;
        for (int i = 0; i < n2; ++i) {
            if (this._header[i].getId() != n) continue;
            return i;
        }
        return -1;
    }

    private int _getSortedColumnForHeaderIdAndSortOrder(int n, boolean bl) {
        int n2 = this._getHeaderIndexForHeaderId(n);
        return bl ? n2 + 1 : -(n2 + 1);
    }

    private int _getHeaderIndexForDisplayIndex(int n) {
        return this._visibleColumns != null ? this._visibleColumns[n] : n;
    }

    void _applyPreferences() {
        this._applyVisibleColumnsPreference();
        this._applyHeaderWidthsPreference();
        this._applySortedColumnPreference();
    }

    private void _applyVisibleColumnsPreference() {
        int n;
        String string;
        if (this._header == null || (string = _profile.readString(this._columnsProfileKey)) == null) {
            return;
        }
        int[] nArray = ASAUtils.parseProfileIntegerList((String)string);
        int n2 = nArray.length;
        if (n2 > (n = this._header.length)) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        int n3 = Math.min(n2, n);
        for (int i = 0; i < n3; ++i) {
            if (nArray[i] <= n - 1) continue;
            this._visibleColumns = this._defaultVisibleColumns;
            return;
        }
        this._visibleColumns = nArray;
    }

    private void _applyHeaderWidthsPreference() {
        int n;
        String string;
        if (this._header == null || (string = _profile.readString(this._widthsProfileKey)) == null) {
            return;
        }
        int[] nArray = ASAUtils.parseProfileIntegerList((String)string);
        int n2 = nArray.length;
        if (n2 > (n = this._header.length)) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        int n3 = Math.min(n2, n);
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray[i];
            if (n4 < 15) {
                n4 = 15;
            } else if (n4 > 4000) {
                n4 = 4000;
            }
            this._header[i].setWidth(n4);
        }
    }

    private void _applySortedColumnPreference() {
        String string;
        if (this._header == null || (string = _profile.readString(this._sortProfileKey)) == null && this._defaultSortedColumn == 0) {
            return;
        }
        int n = this._defaultSortedColumn;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
                if (Math.abs(n) > this._header.length) {
                    n = this._defaultSortedColumn;
                }
            }
            catch (NumberFormatException numberFormatException) {
                n = this._defaultSortedColumn;
            }
        }
        this.sort(n);
    }

    public int getSortEndIndex() {
        return this._sortEndIndex;
    }

    public void setSortEndIndex(int n) {
        this._sortEndIndex = n;
    }

    private static class ItemComparator
    implements Comparator {
        private int _id = 0;
        private boolean _asc = false;
        private ASEBaseHeader[] _hdr = null;

        ItemComparator(ASEBaseHeader[] aSEBaseHeaderArray, int n, boolean bl) {
            this._id = n;
            this._asc = bl;
            this._hdr = aSEBaseHeaderArray;
        }

        public int compare(Object object, Object object2) {
            String string;
            String string2;
            int n = 1;
            switch (this._hdr[this._id].getType()) {
                case 0: {
                    string2 = ((SCItem)object).getDisplayName(this._hdr[this._id].getId());
                    string = ((SCItem)object2).getDisplayName(this._hdr[this._id].getId());
                    if (string2.equals("") && string.equals("")) {
                        return n;
                    }
                    n = string2.toLowerCase().compareTo(string.toLowerCase());
                    break;
                }
                case 1: {
                    string2 = ((SCItem)object).getDisplayName(this._hdr[this._id].getId());
                    string = ((SCItem)object2).getDisplayName(this._hdr[this._id].getId());
                    try {
                        Float f = Float.valueOf(string2);
                        Float f2 = Float.valueOf(string);
                        n = f.compareTo(f2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = string2.toLowerCase().compareTo(string.toLowerCase());
                    }
                    break;
                }
                case 2: {
                    try {
                        DateSorter dateSorter = (DateSorter)((Object)((ASEBaseItem2)object).getSO());
                        DateSorter dateSorter2 = (DateSorter)((Object)((ASEBaseItem2)object2).getSO());
                        Date date = dateSorter.getDate(this._hdr[this._id].getId());
                        Date date2 = dateSorter2.getDate(this._hdr[this._id].getId());
                        n = date.compareTo(date2);
                        break;
                    }
                    catch (Exception exception) {
                        string2 = ((SCItem)object).getDisplayName(this._hdr[this._id].getId());
                        string = ((SCItem)object2).getDisplayName(this._hdr[this._id].getId());
                        n = string2.toLowerCase().compareTo(string.toLowerCase());
                    }
                }
            }
            if (n == 0) {
                string2 = ((SCItem)object).getDisplayName(this._hdr[0].getId());
                string = ((SCItem)object2).getDisplayName(this._hdr[0].getId());
                n = string2.toLowerCase().compareTo(string.toLowerCase());
                if (n == 0) {
                    return 1;
                }
            }
            if (!this._asc) {
                n *= -1;
            }
            return n;
        }
    }
}

