/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEConstants;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import java.awt.Window;
import java.net.MalformedURLException;
import java.net.URL;
import javax.help.BadIDException;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;

class ASEHelpManager
implements ASEConstants {
    private ClassLoader _classloader = null;
    private String _helpJar;
    private String _helpSet;
    private HelpSet _hs = null;
    private HelpBroker _hb = null;
    private String topPageID = "ASEPhelp_meta";

    ASEHelpManager(ClassLoader classLoader, String string, String string2) {
        this._classloader = classLoader;
        this._helpJar = string;
        this._helpSet = string2;
    }

    private void initHelpViewer() {
        try {
            if (this._hs == null) {
                URL uRL = new URL("jar:file:///" + this._helpJar + "!/" + this._helpSet);
                this._hs = new HelpSet(this._classloader, uRL);
                this._hb = this._hs.createHelpBroker();
            }
        }
        catch (HelpSetException helpSetException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_FILE_NOT_FOUND"), this._helpJar);
            Support.showDetailsError(null, this.getClass(), aSEMessageText.toString(), helpSetException);
        }
        catch (MalformedURLException malformedURLException) {
            Support.showDetailsError(null, this.getClass(), malformedURLException.getMessage(), malformedURLException);
        }
    }

    public void showOnlineBooks(Window window) {
        if (this._hs == null) {
            this.initHelpViewer();
        }
        if (this._hs != null && this._hb != null) {
            this.showHelpIndex(this.topPageID, window);
        }
    }

    void showHelpIndex(String string, Window window) {
        if (this._hs == null) {
            this.initHelpViewer();
        }
        if (this._hs != null && this._hb != null) {
            this.showHelp(string, window);
        }
    }

    public void showHelp(String string, Window window) {
        Support.getViewerSupport().startWait();
        try {
            if (window != null) {
                ((DefaultHelpBroker)this._hb).setActivationWindow(window);
            }
            this._hb.setCurrentID(string);
            if (this != Support._helpENManager && Support._helpENManager.getHelpBroker() != null && Support._helpENManager.getHelpBroker().isDisplayed()) {
                Support._helpENManager.getHelpBroker().setDisplayed(false);
            }
            this._hb.setDisplayed(true);
        }
        catch (BadIDException badIDException) {
            Support.addLogEntry(2, null, this.getClass(), badIDException.getMessage(), ASEMessageText.toString(badIDException));
            if (this != Support._helpENManager) {
                this._hb.setDisplayed(false);
                Support._helpENManager.showHelpIndex(string, window);
            }
            if (!string.equals(this.topPageID)) {
                this.showOnlineBooks(window);
            }
            this.showHelp(null, window);
        }
        Support.getViewerSupport().endWait();
    }

    public HelpBroker getHelpBroker() {
        return this._hb;
    }
}

