/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.asa.logon.LogonDialogClient;
import com.sybase.asa.logon.LogonDialogFactory;
import com.sybase.asa.logon.LogonSource;
import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.ase.logon.ASEDatabaseSource;
import com.sybase.aseisqlplugin.ASEISQLPlugin;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEPlugin;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.ProfileHelper;
import com.sybase.aseplugin.Version;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DropDownToolBarButton;
import com.sybase.aseplugin.bo.Modifiable;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.ServerGroupBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TopBO;
import com.sybase.aseplugin.bo.UtilItemBO;
import com.sybase.aseplugin.bo.prop.ProviderProperties;
import com.sybase.aseplugin.so.ASEBaseSO;
import com.sybase.aseplugin.so.ServerGroupSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.so.UtilItemSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ConnectionProps;
import com.sybase.aseplugin.sql.DirectoryService;
import com.sybase.central.SCContainer;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCItem2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuExtender;
import com.sybase.central.SCMenuItem;
import com.sybase.central.SCPageController;
import com.sybase.central.SCProfile;
import com.sybase.central.SCProvider;
import com.sybase.central.SCProvider4;
import com.sybase.central.SCProviderLoader;
import com.sybase.central.SCViewerSupport;
import com.sybase.central.SCViewerSupport4;
import com.sybase.central.editor.EditorFrame;
import com.sybase.central.editor.SCEditorFrame;
import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.util.AppCounter;
import com.sybase.util.ds.Utils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import sybase.isql.isql;

public class ASEProvider
implements SCProvider4,
SCMenuExtender {
    public static final String PROVIDER_ID = "ASE155";
    public static final String ONLINE_HELP_ASETOP = "main.html";
    private static final int CMD_ASEP_HELP = 9999;
    private static TopBO _topBO;
    private static SCViewerSupport4 _viewerSupport;
    private static SCProviderLoader _loader;
    private static Vector _connections;
    private JFrame _frame;
    private ASEMenu _helpMenu;
    private JComponent[] _toolBarJComponents;

    public String getDisplayName() {
        return ASEProvider.getBundleString("DNAME_ASE");
    }

    public static String getBundleString(String string) {
        return ASEUtils.getBundleMgr().getString(string);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public boolean initialize(JFrame jFrame, SCViewerSupport sCViewerSupport) {
        _viewerSupport = (SCViewerSupport4)sCViewerSupport;
        this._frame = jFrame;
        ASEPlugin.setProvider(this);
        Support._viewerSupport = _viewerSupport;
        return true;
    }

    public JComponent[] getToolBarJComponents() {
        if (this._toolBarJComponents == null) {
            this._toolBarJComponents = new JComponent[]{DropDownToolBarButton.createInstance(this)};
        }
        return this._toolBarJComponents;
    }

    public boolean startup(JFrame jFrame, SCProfile sCProfile, SCProviderLoader sCProviderLoader) {
        Object object;
        Object object2;
        ProfileHelper.setProfile(sCProfile);
        _loader = sCProviderLoader;
        _topBO = new TopBO(this);
        _viewerSupport.registerTopLevelContainer((SCContainer)_topBO, (SCProvider)this);
        _viewerSupport.setToolBarJComponents(this.getToolBarJComponents(), (SCProvider)this);
        Enumeration enumeration = _topBO.getItems();
        ASEBaseSO aSEBaseSO = null;
        ASConnection aSConnection = null;
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            if (!(object2 instanceof ServerGroupBO)) continue;
            object = (ServerGroupBO)object2;
            Enumeration enumeration2 = ((ASEBaseContainer2)object).getItems();
            while (enumeration2.hasMoreElements()) {
                ServerBO serverBO;
                ServerSO serverSO;
                boolean bl;
                Object e = enumeration2.nextElement();
                if (!(e instanceof ServerBO) || !(bl = (serverSO = (ServerSO)(serverBO = (ServerBO)e).getSO()).getConnectAtStartup())) continue;
                aSConnection = serverBO.connect(Support.getViewerFrame());
                aSEBaseSO = serverSO.getServerGroup();
            }
        }
        if (aSConnection != null) {
            _topBO.refresh(false);
            if (aSEBaseSO != null) {
                this.selectConnectedServer(aSEBaseSO.getName(), aSConnection);
            }
        }
        if ((object2 = ProfileHelper.getPreference("Setting.LastBrowsed")) != null) {
            object = new File((String)object2);
            Support.setInitDirectory((File)object);
        }
        return true;
    }

    public static TopBO getTopBO() {
        return _topBO;
    }

    private ASConnection handleConnect(Window window, ASEDatabaseSource aSEDatabaseSource, ASEConnectionInfo aSEConnectionInfo, ServerGroupSO serverGroupSO) {
        try {
            ASConnection aSConnection = this.doConnect(aSEConnectionInfo, serverGroupSO);
            return aSConnection;
        }
        catch (SQLException sQLException) {
            if (aSEDatabaseSource != null) {
                aSEDatabaseSource.handleSQLException(sQLException);
                return null;
            }
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_CONNECT_GENERIC"), aSEConnectionInfo.getServerName() == null ? Utils.getHostAndPort((String)aSEConnectionInfo.host, (int)aSEConnectionInfo.port) : aSEConnectionInfo.getServerName());
            String string = aSEMessageText.toString();
            String string2 = "";
            if (sQLException.getSQLState() != null) {
                string2 = sQLException.getSQLState();
            }
            if (string2.equals("JZ00L")) {
                string = string + "\n" + ASEUtils.getString("ERR_LOGIN_FAILED");
            } else if (string2.equals("JZ006")) {
                string = string + "\n" + ASEUtils.getString("ERR_CONNECTION_FAILED");
            }
            Support.showDetailsError(null, this.getClass(), (Container)window, string, sQLException);
            return null;
        }
    }

    public ASConnection showLogonDialog(Window window, ConnectionProps connectionProps, boolean bl, ServerGroupSO serverGroupSO, ASEConnectionInfo aSEConnectionInfo) {
        class ASELogonDialogClient
        implements LogonDialogClient {
            private ASEConnectionInfo _resultInfo;
            private ServerGroupSO _group;
            private boolean _dropConnection;
            private ASConnection _conn = null;

            public ASELogonDialogClient(ServerGroupSO serverGroupSO, boolean bl, ASEConnectionInfo aSEConnectionInfo) {
                this._group = serverGroupSO;
                this._dropConnection = bl;
                this._resultInfo = aSEConnectionInfo;
            }

            public ASConnection getConnection() {
                return this._conn;
            }

            public boolean handleOK(JDialog jDialog, LogonSource logonSource) {
                boolean bl;
                ASEDatabaseSource aSEDatabaseSource = (ASEDatabaseSource)logonSource;
                this._conn = ASEProvider.this.handleConnect(jDialog, aSEDatabaseSource, (ASEConnectionInfo)logonSource.getConnectionInfo(), this._group);
                boolean bl2 = bl = this._conn != null;
                if (bl) {
                    if (this._resultInfo != null) {
                        this._resultInfo.merge((ASEConnectionInfo)logonSource.getConnectionInfo());
                    }
                    if (this._dropConnection) {
                        ASEProvider.this.removeServerConnection(this._conn);
                    }
                }
                return bl;
            }
        }
        ASELogonDialogClient aSELogonDialogClient = new ASELogonDialogClient(serverGroupSO, bl, aSEConnectionInfo);
        LogonSource[] logonSourceArray = new LogonSource[]{this.createASELogonSource(connectionProps.getConnectionInfo())};
        LogonDialogFactory.create((Window)window, null, (Image)ASEImages.getASEPluginSmallImage(), (LogonSource[])logonSourceArray, (int)0, (LogonDialogClient)aSELogonDialogClient, (int)0);
        return aSELogonDialogClient.getConnection();
    }

    private LogonSource createASELogonSource(ASEConnectionInfo aSEConnectionInfo) {
        ASEDatabaseSource aSEDatabaseSource = new ASEDatabaseSource();
        aSEDatabaseSource.setInitialConnectionInfo((AbstractConnectionInfo)aSEConnectionInfo);
        aSEDatabaseSource.setClassLoader(this.getClass().getClassLoader());
        aSEDatabaseSource.setHelpFolder(ASEISQLPlugin.getHelpFolder(), ASEISQLPlugin.getHelpPrefix(), ASEISQLPlugin.getHelpSuffix());
        return aSEDatabaseSource;
    }

    public ASConnection connect(Window window, ServerGroupSO serverGroupSO) {
        return this.connect(window, serverGroupSO, null);
    }

    public ASConnection connect(Window window, ServerGroupSO serverGroupSO, ASEConnectionInfo aSEConnectionInfo) {
        boolean bl;
        ASConnection aSConnection = null;
        boolean bl2 = false;
        boolean bl3 = bl = !ProfileHelper.getRememberPassword();
        if (!(bl || aSEConnectionInfo == null || !aSEConnectionInfo.canAttemptConnection() || aSEConnectionInfo.getPassword() != null && aSEConnectionInfo.getPassword().equals("enternewpassword"))) {
            aSConnection = this.handleConnect(window, null, aSEConnectionInfo, serverGroupSO);
            bl2 = true;
        }
        if (aSConnection == null) {
            ConnectionProps connectionProps;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (aSEConnectionInfo != null && (bl2 || bl || aSEConnectionInfo.getPassword() != null && aSEConnectionInfo.getPassword().equals("enternewpassword"))) {
                aSEConnectionInfo.setPassword(null);
            }
            if ((aSConnection = this.showLogonDialog(window, connectionProps = aSEConnectionInfo == null ? new ConnectionProps() : new ConnectionProps(aSEConnectionInfo), false, serverGroupSO, null)) != null) {
                // empty if block
            }
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return aSConnection;
    }

    public void connect(JFrame jFrame) {
        ASConnection aSConnection = this.connect(jFrame, _topBO.getDefaultServerGroup());
        if (aSConnection != null) {
            this.handleRefreshConnect(_topBO.getDefaultServerGroup().getName(), aSConnection);
        }
    }

    public boolean isOkToShutdown(JFrame jFrame) {
        while (_connections.size() > 0) {
            ASConnection aSConnection = (ASConnection)_connections.elementAt(0);
            boolean bl = this.removeServerConnection(aSConnection);
            if (bl) continue;
            return false;
        }
        return true;
    }

    boolean closeOpenWindows(ASConnection aSConnection) {
        return this.closeOpenWindows(aSConnection, false);
    }

    boolean closeOpenWindows(ASConnection aSConnection, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        if (aSConnection != null && !aSConnection.isDead() && !bl) {
            object3 = null;
            object2 = Support.getOpenWindows(aSConnection);
            while (object2.hasMoreElements()) {
                object = (Modifiable)object2.nextElement();
                if (object == null || !object.isModified()) continue;
                object3 = object.getWindow();
                break;
            }
            if (object3 != null && Support.showQuestionYesNo(ASEUtils.getString("MSG_SOME_WINDOWS_MODIFIED")) != 0) {
                ((Component)object3).requestFocus();
                return false;
            }
        }
        object3 = Support.getOpenWindows(aSConnection);
        while (object3.hasMoreElements()) {
            object2 = (Modifiable)object3.nextElement();
            object = object2.getWindow();
            if (object == null) continue;
            SwingUtilities.invokeLater(new Runnable((Window)object){
                final /* synthetic */ Window val$win;
                {
                    this.val$win = window;
                }

                @Override
                public void run() {
                    if (Thread.currentThread().isAlive()) {
                        this.val$win.dispatchEvent(new WindowEvent(this.val$win, 201));
                    }
                }
            });
        }
        return true;
    }

    boolean closeOpenEditors(ASConnection aSConnection) {
        Enumeration enumeration = Support.getOpenEditors(aSConnection);
        while (enumeration.hasMoreElements()) {
            final EditorFrame editorFrame = (EditorFrame)enumeration.nextElement();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Thread.currentThread().isAlive()) {
                        ((SCEditorFrame)editorFrame).dispatchEvent((AWTEvent)new WindowEvent((Window)((SCEditorFrame)editorFrame), 201));
                    }
                }
            });
        }
        return true;
    }

    public void shutdown() {
        ServerGroupSO.removeCutServers();
        _topBO.removeUAConnections();
        _viewerSupport.unregisterTopLevelContainer((SCContainer)Support.getTopBO());
    }

    public void disconnect(JFrame jFrame, Object object) {
        boolean bl;
        ASConnection aSConnection = (ASConnection)object;
        if (aSConnection != null && (bl = this.removeServerConnection(aSConnection))) {
            this.handleRefreshDisconnect(aSConnection);
        }
    }

    private boolean removeServerConnectionsByRealServerName(String string, boolean bl) {
        List list = _topBO.getConnectionsByRealServerName(string);
        boolean bl2 = false;
        for (ASConnection aSConnection : list) {
            bl2 = this.removeServerConnection(aSConnection) || bl2;
        }
        return bl2;
    }

    protected boolean removeServerConnections(ServerSO serverSO) {
        return this.removeServerConnections(serverSO, false);
    }

    protected boolean removeServerConnections(ServerSO serverSO, boolean bl) {
        boolean bl2 = this.removeServerConnections(serverSO.getName(), bl);
        boolean bl3 = false;
        if (serverSO.getConnection() != null) {
            bl3 = this.removeServerConnectionsByRealServerName(serverSO.getServerServerName(), bl);
        }
        if (bl2 || bl3) {
            this.refreshAfterConnectionRemoved(serverSO.getName());
            return true;
        }
        return false;
    }

    private boolean removeServerConnections(String string, boolean bl) {
        List list = _topBO.getConnections(string);
        boolean bl2 = false;
        for (ASConnection aSConnection : list) {
            bl2 = this.removeServerConnection(aSConnection, bl) || bl2;
        }
        return bl2;
    }

    private void refreshAfterConnectionRemoved(String string) {
        _topBO.refreshLater();
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_CONNECTION_CLOSED"), string);
        Support.setStatusBarMessage(aSEMessageText.toString());
    }

    protected boolean handleDeadServer(String string) {
        if (_topBO.getConnections(string).size() == 0) {
            return true;
        }
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_CONNECTION_ALREADY_CLOSED"), string);
        int n = Support.showQuestionYesNo(aSEMessageText.toString() + "\n" + ASEUtils.getString("MSG_TRY_RECONNECT"));
        if (n == 0) {
            do {
                Support.getViewerSupport().startWait();
                if (this.restoreServerConnections(string, 5)) {
                    Support.getViewerSupport().endWait();
                    return true;
                }
                Support.getViewerSupport().endWait();
            } while (Support.showQuestionYesNo((aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_RECONNECT_FAILED"), string)).toString()) == 0);
        }
        if (this.removeServerConnections(string, true)) {
            this.refreshAfterConnectionRemoved(string);
        }
        return false;
    }

    protected boolean restoreServerConnections(String string, int n) {
        List list = _topBO.getConnections(string);
        for (ASConnection aSConnection : list) {
            try {
                aSConnection.executeCommand("print 'What's up, doc?'", false);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            int n2 = 0;
            while (aSConnection.isDead()) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_RECONNECTING"), string);
                Support.setStatusBarMessage(aSEMessageText.toString());
                try {
                    aSConnection.open();
                    Support.clearStatusBarMessage();
                    return true;
                }
                catch (SQLException sQLException) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (n2 == n) {
                        Support.clearStatusBarMessage();
                        return false;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                ++n2;
            }
        }
        Support.clearStatusBarMessage();
        return true;
    }

    protected boolean removeServerConnection(ASConnection aSConnection) {
        return this.removeServerConnection(aSConnection, false);
    }

    protected boolean removeServerConnection(ASConnection aSConnection, boolean bl) {
        if (aSConnection == null || !this.closeOpenEditors(aSConnection) || !this.closeOpenWindows(aSConnection, bl)) {
            return false;
        }
        if (aSConnection.hasSQLListener()) {
            aSConnection.getSQLListener().stopTracing();
            aSConnection.unsetSQLListener();
        }
        ASConnection.removeShutdownServer(aSConnection.getServerName());
        _topBO.removeConnection(aSConnection);
        _connections.removeElement(aSConnection);
        _viewerSupport.unregisterConnection((Object)aSConnection);
        try {
            aSConnection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return true;
    }

    protected void handleRefreshDisconnect(ASConnection aSConnection) {
        ServerBO serverBO = ContainerViewBO.getServerBO(aSConnection);
        if (serverBO != null) {
            _topBO.setNeedUpdate(false);
            serverBO.getParent().refresh();
            _topBO.setNeedUpdate(true);
        } else {
            _topBO.refresh(false);
        }
    }

    protected void handleRefreshConnect(String string, ASConnection aSConnection) {
        ServerGroupBO serverGroupBO = ContainerViewBO.getServerGroupBO(string);
        if (serverGroupBO == null) {
            _topBO.refresh(false);
        } else {
            _topBO.setNeedUpdate(false);
            serverGroupBO.refresh();
            _topBO.setNeedUpdate(true);
        }
        this.selectConnectedServer(string, aSConnection);
    }

    protected void markShutDown(ServerSO serverSO) {
        _topBO.markShutDown(serverSO);
    }

    private ASConnection doConnect(ASEConnectionInfo aSEConnectionInfo) throws SQLException {
        return this.doConnect(aSEConnectionInfo, _topBO.getDefaultServerGroup());
    }

    private ASConnection doConnect(ASEConnectionInfo aSEConnectionInfo, ServerGroupSO serverGroupSO) throws SQLException {
        String string = aSEConnectionInfo.getUserName();
        String string2 = aSEConnectionInfo.getServerName();
        String string3 = aSEConnectionInfo.host;
        String string4 = String.valueOf(aSEConnectionInfo.port);
        Support.getViewerSupport().startWait();
        int n = this.getConnectionId(string2 == null ? string3 + ":" + string4 : string2, string);
        ASConnection aSConnection = null;
        try {
            aSConnection = _topBO.addConnection(this._frame, aSEConnectionInfo, this, n, serverGroupSO);
            if (aSConnection != null) {
                _viewerSupport.registerConnection((SCProvider)this, aSConnection.getDisplayName(), aSConnection.getHostNameAndPortNumber(), (Object)aSConnection);
            }
            DirectoryService.initServerEntries();
        }
        catch (SQLException sQLException) {
            Support.getViewerSupport().endWait();
            throw sQLException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Support.showDetailsError(aSConnection, this.getClass(), ASEUtils.getString("ERR_NO_JDBC_DRIVER"), classNotFoundException);
        }
        Support.getViewerSupport().endWait();
        if (aSConnection == null) {
            return null;
        }
        _connections.addElement(aSConnection);
        return aSConnection;
    }

    private void selectConnectedServer(String string, ASConnection aSConnection) {
        if (aSConnection == null) {
            return;
        }
        Enumeration enumeration = _topBO.getItems();
        while (enumeration.hasMoreElements()) {
            ServerGroupBO serverGroupBO;
            Object e = enumeration.nextElement();
            if (!(e instanceof ServerGroupBO) || !(serverGroupBO = (ServerGroupBO)e).getDisplayName(0).equals(string)) continue;
            String string2 = aSConnection.getDisplayName();
            ASEBaseContainer2 aSEBaseContainer2 = (ASEBaseContainer2)serverGroupBO.findItem(string2);
            ASEBaseContainer2 aSEBaseContainer22 = null;
            if (aSEBaseContainer2 == null) continue;
            aSEBaseContainer2.expand();
            if (!ProfileHelper.getRememberPath()) {
                aSEBaseContainer2.select();
                return;
            }
            aSEBaseContainer22 = aSEBaseContainer2;
            ServerGroupSO serverGroupSO = (ServerGroupSO)serverGroupBO.getSO();
            String string3 = serverGroupSO.getServerLastFolder(aSConnection.getServerName(), aSConnection.getCurrentUser());
            if (string3 != null) {
                String[] stringArray = string3.split("/");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = stringArray[i];
                    aSEBaseContainer22.open(1);
                    ASEBaseItem2 aSEBaseItem2 = aSEBaseContainer22.findItem(string4);
                    if (aSEBaseItem2 == null || !(aSEBaseItem2 instanceof ASEBaseContainer2)) break;
                    aSEBaseContainer22 = (ASEBaseContainer2)aSEBaseItem2;
                    aSEBaseContainer22.expand();
                }
            }
            if (aSEBaseContainer22 == null) continue;
            aSEBaseContainer22.select();
        }
    }

    public boolean supportsConnectionProfiles() {
        return true;
    }

    private ConnectionProps getInfoFromProfile(SCProfile sCProfile, boolean bl) {
        ASEConnectionInfo aSEConnectionInfo;
        String string = sCProfile.readEncryptedString("ConnectionInfo");
        ASEConnectionInfo aSEConnectionInfo2 = aSEConnectionInfo = string != null ? ConnectionProps.getNewConnectionInfo(string) : ConnectionProps.getNewConnectionInfo();
        if (bl) {
            aSEConnectionInfo.setPassword("");
        }
        return new ConnectionProps(aSEConnectionInfo);
    }

    public boolean editConnection(JFrame jFrame, SCProfile sCProfile) {
        ConnectionProps connectionProps = this.getInfoFromProfile(sCProfile, true);
        ASEConnectionInfo aSEConnectionInfo = ConnectionProps.getNewConnectionInfo();
        this.showLogonDialog(jFrame, connectionProps, true, null, aSEConnectionInfo);
        boolean bl = false;
        if (aSEConnectionInfo.canAttemptConnection()) {
            sCProfile.writeEncryptedString("ConnectionInfo", aSEConnectionInfo.getConnectionString());
            bl = true;
        }
        return bl;
    }

    public boolean restoreConnection(JFrame jFrame, SCProfile sCProfile) {
        ConnectionProps connectionProps = this.getInfoFromProfile(sCProfile, false);
        try {
            ASConnection aSConnection = this.doConnect(connectionProps.getConnectionInfo());
            if (aSConnection != null) {
                this.handleRefreshConnect(_topBO.getDefaultServerGroup().getName(), aSConnection);
                return true;
            }
        }
        catch (SQLException sQLException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_CONNECT_GENERIC"), ServerSO.getServerName(connectionProps.getConnectionInfo()));
            String string = "";
            if (sQLException.getSQLState() != null) {
                string = sQLException.getSQLState();
            }
            String string2 = aSEMessageText.toString();
            if (string.equals("JZ00L")) {
                string2 = string2 + "\n" + ASEUtils.getString("ERR_LOGIN_FAILED");
            } else if (string.equals("JZ006")) {
                string2 = string2 + "\n" + ASEUtils.getString("ERR_CONNECTION_FAILED");
            }
            Support.showDetailsError(null, this.getClass(), (Container)this._frame, string2, sQLException);
        }
        return false;
    }

    public SCMenu getHelpMenu() {
        if (this._helpMenu != null) {
            return this._helpMenu;
        }
        this._helpMenu = new ASEMenu();
        ASEMenuItem aSEMenuItem = new ASEMenuItem(9999, ASEUtils.getString("CONTEXT_MENU_ASEPLUGIN_ONLINE_HELP"), ASEUtils.getString("CONTEXT_MENU_CMD_ONLINE_HELP_HINT"));
        this._helpMenu.addItem((SCMenuItem)aSEMenuItem);
        return this._helpMenu;
    }

    public void onHelpCommand(JFrame jFrame, int n) {
        switch (n) {
            case 9999: {
                try {
                    Support.showOnlineBooks(this._frame);
                }
                catch (IOException iOException) {
                    Support.showDetailsError(null, this.getClass(), iOException.getMessage(), iOException);
                }
                break;
            }
        }
    }

    private boolean isSameConnection(ASConnection aSConnection, String string, String string2) {
        String string3 = aSConnection.getDisplayName();
        String string4 = ASConnection.getConnectionDisplayName(string, string2, aSConnection.getId());
        boolean bl = string3.equals(string4);
        return bl;
    }

    public int getConnectionId(String string, String string2) {
        if (_connections.size() == 0) {
            return 0;
        }
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < _connections.size(); ++i) {
            ASConnection aSConnection = (ASConnection)_connections.elementAt(i);
            if (aSConnection == null || !this.isSameConnection(aSConnection, string, string2)) continue;
            bl = true;
            int n2 = aSConnection.getId();
            if (n >= n2) continue;
            n = n2;
        }
        return bl ? n + 1 : n;
    }

    public String getDisplayVersion() {
        return Version.getVersionNumber();
    }

    public String getCopyrightMessage() {
        String string = Version.getVersionString();
        if (string != null && string.length() > 0) {
            string = string + "\n\n";
        }
        string = string + ASEUtils.getString("ABOUT_ASEP_DLG_SENT_COPYRIGHT");
        return string;
    }

    public static SCProviderLoader getLoader() {
        return _loader;
    }

    public SCMenu getContextExtensionMenu(String[] stringArray) {
        return null;
    }

    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, Object object) {
    }

    public SCPageController[] getPropertyExtensionPages(SCItem2 sCItem2, SCDialogSupport sCDialogSupport) {
        return null;
    }

    public static File getSybaseOrSybrootDir() {
        File file = ASEProvider.getSybaseDir();
        if (file == null) {
            try {
                file = ASEProvider.getSybrootDir();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file;
    }

    public static File getSybaseDir() {
        File file = Utils.getSybaseDir();
        if (file == null) {
            ASEProvider.warnNoSybase();
        }
        return file;
    }

    public static String getSybasePath() {
        String string = Utils.getSybasePath();
        if (string == null) {
            ASEProvider.warnNoSybase();
        }
        return string;
    }

    private static void warnNoSybase() {
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_ENV_VARIABLE_NOT_DEFINED"), "SYBASE");
        Support.addLogEntry(1, null, ASEProvider.class, aSEMessageText.toString(), aSEMessageText.toString());
    }

    public static File getSybrootDir() throws IOException {
        Object object;
        File file = null;
        String string = System.getProperty("SYBROOT");
        if (string == null) {
            string = Utils.getEnVariable((String)"SYBROOT");
        }
        if (string == null && ((String)(object = _loader.getProviderDirectory())).indexOf("ASEP") != -1) {
            string = ((String)object).substring(0, ((String)object).indexOf("ASEP") - 1);
        }
        if (string == null) {
            object = new ASEMessageText(ASEUtils.getString("ERR_ENV_VARIABLE_NOT_DEFINED"), "SYBROOT");
            throw new IOException(((ASEMessageText)object).toString());
        }
        if (!ASEUtils.isExistingDirectory(string)) {
            object = new ASEMessageText(ASEUtils.getString("ERR_DIRECTORY_NOT_FOUND"), string);
            throw new IOException(((ASEMessageText)object).toString());
        }
        file = new File(string);
        return file;
    }

    public static String getSybrootPath() throws IOException {
        File file = ASEProvider.getSybrootDir();
        String string = ASEUtils.getCanonicalPath(file);
        return string;
    }

    public static String findDirName(String string, String string2, String string3) {
        return ASEProvider.findDirName(string, new String[]{string2}, string3);
    }

    public static String findDirName(String string, String[] stringArray, String string2) {
        String string3 = null;
        if (string == null) {
            return string3;
        }
        String[] stringArray2 = ASEUtils.getFileListFromDirectory(string);
        if (stringArray2 == null) {
            return string3;
        }
        block0: for (int i = 0; i < stringArray2.length; ++i) {
            String string4 = stringArray2[i];
            for (int j = 0; j < stringArray.length; ++j) {
                String string5;
                String string6 = stringArray[j];
                if (string4.length() < string6.length() || (string5 = string4.substring(0, string6.length())).compareToIgnoreCase(string6) != 0) continue;
                string3 = string4;
                continue block0;
            }
        }
        return string3 == null ? string2 : string3;
    }

    public void openDBISQL(Container container, ASConnection aSConnection, String string, String string2, boolean bl) {
        ASEConnectionInfo aSEConnectionInfo = null;
        if (aSConnection != null) {
            aSEConnectionInfo = new ASEConnectionInfo(aSConnection.getConnectionInfo(string, "DBISQL"));
        }
        isql.openISQL((AppCounter)_viewerSupport.getAppCounter(), aSEConnectionInfo, (String)string2, (boolean)bl, (int)1);
    }

    public void openDBISQL(Container container, ConnectionProps connectionProps, String string, boolean bl) {
        boolean bl2 = !ProfileHelper.getRememberPassword();
        ASEConnectionInfo aSEConnectionInfo = connectionProps == null ? new ASEConnectionInfo() : new ASEConnectionInfo(connectionProps.getConnectionInfo());
        aSEConnectionInfo.setApplicationName("DBISQL");
        if (aSEConnectionInfo.getPassword() != null && aSEConnectionInfo.getPassword().equals("enternewpassword") || bl2) {
            aSEConnectionInfo.setPassword(null);
        }
        isql.openISQL((AppCounter)_viewerSupport.getAppCounter(), (AbstractConnectionInfo)aSEConnectionInfo, (String)string, (boolean)bl, (int)1);
    }

    public void runScript(Container container, ASConnection aSConnection, String string, String string2) throws Exception {
        if (!ASEUtils.isExistingFile(string2)) {
            return;
        }
        ASEConnectionInfo aSEConnectionInfo = null;
        if (aSConnection != null) {
            aSEConnectionInfo = new ASEConnectionInfo(aSConnection.getConnectionInfo(string, "DBISQL"));
        }
        isql.runScript((Object)Support.getViewerFrame(), (AbstractConnectionInfo)aSEConnectionInfo, (File)new File(string2), null, (boolean)true);
    }

    public void openUtil(String string, String string2) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        Vector<String> vector = new Vector<String>();
        vector.add(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(new String(stringTokenizer.nextToken()));
        }
        String[] stringArray = vector.toArray(new String[0]);
        String[] stringArray2 = ASEProvider.validateCommand(stringArray);
        process = runtime.exec(stringArray2);
        final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        final StringBuffer stringBuffer = new StringBuffer();
        new Thread(){

            @Override
            public void run() {
                String string = null;
                stringBuffer.setLength(0);
                try {
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string).append("\n");
                    }
                }
                catch (Exception exception) {
                    stringBuffer.append(exception.getLocalizedMessage());
                }
            }
        };
        process.getOutputStream().close();
        process.getErrorStream().close();
        process.getInputStream().close();
        String string3 = string;
        if (stringBuffer != null) {
            string3 = string3 + "\n" + ASEUtils.getString("LABC_ERROR_MSG") + ":\n";
            string3 = string3 + stringBuffer.toString();
        }
        this.logCommand(string, string3);
    }

    public boolean hasDirectoryServiceEditor() {
        return ASEUtils.isExistingFile(this.getDirectoryServiceEditorPath());
    }

    public boolean hasServerConfig() {
        return ASEUtils.isExistingFile(this.getServerConfigPath());
    }

    public String getServerConfigPath() {
        String string = ASEUtils.OS_WINDOWS ? "syconfig.exe" : "asecfg";
        String string2 = ASEProvider.getSybasePath();
        String string3 = ASEProvider.findDirName(string2, new String[]{"ASE-15_0", "ASE-"}, "ASE*");
        String string4 = string2 + File.separator + string3 + File.separator + "bin" + File.separator + string;
        return string4;
    }

    public String getDirectoryServiceEditorPath() {
        String string = ASEUtils.OS_WINDOWS ? "dsedit.exe" : "dsedit";
        String string2 = ASEProvider.getSybasePath();
        String string3 = ASEProvider.findDirName(string2, new String[]{"OCS-15_0", "OCS-"}, "OCS*");
        String string4 = string2 + File.separator + string3 + File.separator + "bin" + File.separator + string;
        return string4;
    }

    public void logCommand(String string, String[] stringArray) {
        this.logCommand(string, Utility.stringArrayToString(stringArray, " ", null));
    }

    public void logCommand(String string, String string2) {
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_COMMAND_FOR_APPLICATION"), string);
        Support.addLogEntry(2, null, this.getClass(), aSEMessageText.toString(), string2);
    }

    public SCMenu getTopLevelMenu() {
        ASEMenu aSEMenu = new ASEMenu(ASEUtils.getString("DNAME_ASE"));
        String string = ASEUtils.getString("CONTEXT_MENU_PREFERENCES_TEXT");
        String string2 = ASEUtils.getString("CONTEXT_MENU_PREFERENCES_HINT");
        int n = 107;
        aSEMenu.addItem((SCMenuItem)new ASEMenuItem(n, string, string2, Support.getMnemonic("CONTEXT_MENU_PREFERENCES_MNEM"), ASEMenuItem.PROPERTIES_ICON));
        aSEMenu.addItem((SCMenuItem)new ASEMenuItem());
        _topBO.getUtilitiesDetailsBO().populate();
        Enumeration enumeration = _topBO.getUtilitiesDetailsBO().getItems();
        while (enumeration.hasMoreElements()) {
            UtilItemBO utilItemBO = (UtilItemBO)enumeration.nextElement();
            string = ((UtilItemSO)utilItemBO.getSO()).getName();
            string2 = ((UtilItemSO)utilItemBO.getSO()).getHint();
            n = utilItemBO.getCmdId();
            if (string.equals(ASEUtils.getString("MSG_ADD_NEW_UTILITY"))) continue;
            aSEMenu.addItem((SCMenuItem)new ASEMenuItem(n, string, string2, '\u0000', (ImageIcon)utilItemBO.getImage(true)));
        }
        return aSEMenu;
    }

    public void onCommand(JFrame jFrame, int n, Object object) {
        if (n == 107) {
            ProviderProperties providerProperties = new ProviderProperties((SCContainer2)_topBO, ASEUtils.getString("CONTEXT_MENU_PREFERENCES_TEXT"));
            ASEBaseDialog2.showDialog(jFrame, providerProperties);
        } else {
            _topBO.getUtilitiesDetailsBO().openUtility(jFrame, n);
        }
    }

    public void bottomJComponentVisibilityChanged(boolean bl) {
    }

    public String getProviderConnectionsMenuItemText() {
        return ASEUtils.getString("CONN_MENU_ASE");
    }

    public Icon getProviderIcon() {
        return TopBO.ASE_ICON;
    }

    public boolean startupCompleted(String[] stringArray) {
        return false;
    }

    public boolean supportsConnecting() {
        return true;
    }

    public static String[] validateCommand(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (null == stringArray[i] || stringArray[i].trim().length() <= 0) continue;
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    static {
        _connections = new Vector();
    }
}

