/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.RLImages;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.PublicationBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.ArticleProp;
import com.sybase.aseplugin.so.ArticleSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class ArticleBO
extends ASEBaseItem2 {
    static final int NAME_COL = 0;
    static final int TYPE_COL = 1;
    static final int OWNER_COL = 2;
    public static final ImageIcon PRIMARY_ARTICLE_TABLE_ICON = new ImageIcon(RLImages.getPArtTableSmallImage());
    public static final ImageIcon PRIMARY_ARTICLE_PROC_ICON = new ImageIcon(RLImages.getPArtProcSmallImage());
    public static final ImageIcon NEW_PRIMARY_ARTICLE_ICON = new ImageIcon(RLImages.getNewPrimaryArticleImage());

    ArticleBO(PublicationBO publicationBO, ArticleSO articleSO) {
        super((SOItemInterface)articleSO, publicationBO);
    }

    public String getDDB() {
        return ((ArticleSO)this.getSO()).getDDB();
    }

    @Override
    public Icon getImage(boolean bl) {
        if (((ArticleSO)this.getSO()).isTable()) {
            return PRIMARY_ARTICLE_TABLE_ICON;
        }
        return PRIMARY_ARTICLE_PROC_ICON;
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getSO().getDisplayName();
            }
            case 1: {
                return ((ArticleSO)this.getSO()).getTypeString();
            }
            case 2: {
                return ((ArticleSO)this.getSO()).getOwner();
            }
        }
        return "";
    }

    @Override
    public SCMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ASEMenu();
            this._contextMenu.addItem((SCMenuItem)this.getDeleteMenuItem());
            this._contextMenu.addItem((SCMenuItem)new ASEMenuItem());
            this._contextMenu.addItem((SCMenuItem)ASEMenuItem.getPropertiesMenuItem());
        }
        return this._contextMenu;
    }

    @Override
    public boolean isOkToBatch(int n) {
        return true;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 106: {
                int n3 = Support.showQuestionYesNo(jFrame, ASEUtils.getString("MSG_DELETE_OBJECT_QUESTION"));
                if (n3 != 0) break;
                Support.getViewerSupport().startWait();
                while (enumeration.hasMoreElements()) {
                    try {
                        ArticleBO articleBO = (ArticleBO)enumeration.nextElement();
                        articleBO.getSO().remove();
                    }
                    catch (SQLException sQLException) {
                        Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                    }
                }
                Support.getViewerSupport().endWait();
                ((PublicationBO)this.getParent()).refresh();
                break;
            }
            default: {
                super.onCommand(jFrame, n, enumeration, n2);
            }
        }
    }

    @Override
    public ASEBasePropertiesDialog2 getPropertiesDialog() {
        return new ArticleProp((ArticleSO)this.getSO(), (SCContainer2)this.getParent());
    }
}

