/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.BackupServersCtrBO;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.RemoteServerBO;
import com.sybase.aseplugin.bo.RemoteServersCtrBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.BackupServerProperties;
import com.sybase.aseplugin.bo.prop.BackupServerProperties2;
import com.sybase.aseplugin.so.BackupServerSO;
import com.sybase.aseplugin.so.BackupServerSO2;
import com.sybase.aseplugin.so.BackupServerSOBase;
import com.sybase.aseplugin.so.RemoteServerSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.central.SCContainer2;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JFrame;

public class BackupServerBO
extends ASEBaseItem2 {
    public static void refreshRemoteServers(ASConnection aSConnection) {
        ServerBO serverBO = ContainerViewBO.getServerBO(aSConnection);
        RemoteServersCtrBO remoteServersCtrBO = (RemoteServersCtrBO)serverBO.getItem(ASEUtils.getString("DNAME_REMOTESERVERS"));
        remoteServersCtrBO.refresh();
    }

    public BackupServerBO(BackupServersCtrBO backupServersCtrBO, BackupServerSOBase backupServerSOBase) {
        super((SOItemInterface)backupServerSOBase, backupServersCtrBO, (Icon)RemoteServerBO.REMOTE_SERVER_ICON);
    }

    public BackupServerBO(BackupServersCtrBO backupServersCtrBO, BackupServerSO backupServerSO) {
        super((SOItemInterface)backupServerSO, backupServersCtrBO, (Icon)RemoteServerBO.REMOTE_SERVER_ICON);
    }

    @Override
    public ASEBasePropertiesDialog2 getPropertiesDialog() {
        if (this.getSO() instanceof BackupServerSO2) {
            return new BackupServerProperties2((BackupServerSO2)this.getSO(), this.getParent());
        }
        return new BackupServerProperties((BackupServerSO)this.getSO(), (SCContainer2)this.getParent());
    }

    @Override
    public boolean deleteObjects(ArrayList arrayList) {
        boolean bl = true;
        Support.getViewerSupport().startWait();
        RemoteServerBO remoteServerBO = ContainerViewBO.getRemoteServerBO(ContainerViewBO.getServerBO(this.getConnection()), "SYB_BACKUP");
        RemoteServerSO remoteServerSO = null;
        if (remoteServerBO != null) {
            remoteServerSO = (RemoteServerSO)remoteServerBO.getSO();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                ASEBaseItem2 aSEBaseItem2 = (ASEBaseItem2)arrayList.get(i);
                BackupServerSOBase backupServerSOBase = (BackupServerSOBase)aSEBaseItem2.getSO();
                if (remoteServerSO != null && remoteServerSO.testConnection()) {
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_SHUTDOWN_AND_DELETE_BACKUP_SERVER"), backupServerSOBase.getName());
                    if (Support.showQuestionYesNo(aSEMessageText.toString()) == 1) continue;
                    try {
                        this.getConnection().executeCommand(SQLs.getString("shutdown {0} with nowait", "SYB_BACKUP"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                backupServerSOBase.removeServer();
                BackupServerBO.refreshRemoteServers(this.getConnection());
                continue;
            }
            catch (Exception exception) {
                Support.showDetailsError(this.getConnection(), this.getClass(), exception.getMessage(), exception);
                bl = false;
            }
        }
        Support.getViewerSupport().endWait();
        return bl;
    }

    @Override
    void deleteItems(JFrame jFrame, Enumeration enumeration) {
        super.deleteItems(jFrame, enumeration, false);
    }
}

