/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDetailsContainer;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.BackupServerBO;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.MonitorServersDetailsBO;
import com.sybase.aseplugin.bo.RemoteServerBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.XPServersDetailsBO;
import com.sybase.aseplugin.bo.wiz.BackupServerWizard;
import com.sybase.aseplugin.bo.wiz.BackupServerWizard2;
import com.sybase.aseplugin.bo.wiz.MonitorServerWizard;
import com.sybase.aseplugin.bo.wiz.XPServerWizard;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.BackupServerSO;
import com.sybase.aseplugin.so.BackupServerSO2;
import com.sybase.aseplugin.so.BackupServerSOBase;
import com.sybase.aseplugin.so.BackupServersCtrSO;
import com.sybase.aseplugin.so.MonitorServerSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.so.XPServerSO;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.ua.AuthorizationException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;

public class BackupServersCtrBO
extends ASEBaseContainer2 {
    public static final String HEADER_HOST = ASEUtils.getString("AUXILIARY_SERVER_HOSTS_HEADER_HOST");
    public static final String HEADER_INSTANCE = ASEUtils.getString("AUXILIARY_SERVER_HOSTS_HEADER_INSTANCE");
    public static final String HEADER_PORT = ASEUtils.getString("AUXILIARY_SERVER_HOSTS_HEADER_PORT");
    public static final String HEADER_ERROR_FILE = ASEUtils.getString("AUXILIARY_SERVER_HOSTS_HEADER_ERROR_FILE");
    private ServerSO _serverSO = (ServerSO)ContainerViewBO.getServerBO(this.getConnection()).getSO();
    private boolean _isExists;
    private Vector _items;

    public BackupServersCtrBO(ServerBO serverBO) {
        super(ASEUtils.getString("DNAME_AUXILIARY_SERVERS"), (ASEBaseContainer2)serverBO);
    }

    @Override
    public Object[] getDetailsPanels(JFrame jFrame) {
        if (this._detailsPanels == null) {
            this._detailsPanels = new Object[]{Support.createDetailsListPanel(ASEUtils.getString("DISP_BACKUP_SERVER_PANEL_NAME")), Support.createDetailsListPanel(ASEUtils.getString("DISP_XP_SERVER_PANEL_NAME"), new XPServersDetailsBO(this)), Support.createDetailsListPanel(ASEUtils.getString("DISP_MONITOR_SERVER_PANEL_NAME"), new MonitorServersDetailsBO(this))};
        }
        return this._detailsPanels;
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        return new ASEBaseHeader[]{new ASEBaseHeader(ASEUtils.getString("AUXILIARY_SERVER_SERVER_NAME_HEADER"), 0, 200)};
    }

    private boolean checkUAF() {
        ServerBO serverBO = ContainerViewBO.getServerBO(this.getConnection());
        ServerSO serverSO = (ServerSO)serverBO.getSO();
        if (!serverSO.isUAFMonitored()) {
            Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("ERR_AUXILIARY_SERVER_CHECK_UAF"));
            return false;
        }
        return true;
    }

    private boolean checkSARole() {
        if (!this.getConnection().hasRole("sa_role")) {
            Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("MSG_NEED_SA_ROLE_AUXILIARY_SERVER"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getItems(int n, Object[] objectArray) {
        if (!this.checkSARole()) {
            return null;
        }
        if (!this.checkUAF()) {
            return null;
        }
        BackupServersCtrSO backupServersCtrSO = new BackupServersCtrSO(this.getConnection(), this._serverSO);
        this._items = new Vector();
        List list = null;
        try {
            Support.getViewerSupport().startWait();
            list = backupServersCtrSO.open(0, null);
        }
        catch (Exception exception) {
            Support.showDetailsError(this.getParent().getConnection(), this.getClass(), exception.getMessage(), exception);
        }
        finally {
            Support.getViewerSupport().endWait();
        }
        boolean bl = this._isExists = list != null && list.size() > 0;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                this._items.add(new BackupServerBO(this, (BackupServerSOBase)list.get(i)));
            }
        }
        BackupServersCtrBO.refreshToolBar(this, this._isExists);
        return this._items;
    }

    @Override
    public Vector getItems(int n) {
        return this.getItems(n, null);
    }

    public static void refreshToolBar(ASEBaseContainer2 aSEBaseContainer2, boolean bl) {
        if (bl) {
            aSEBaseContainer2._creationToolBar = null;
            Support.refreshToolBarJComponents();
        }
    }

    public static void refreshToolBar(ASEBaseDetailsContainer aSEBaseDetailsContainer, boolean bl) {
        if (bl) {
            aSEBaseDetailsContainer._creationToolBar = null;
            Support.refreshToolBarJComponents();
        }
    }

    public static ASEToolBarButton[] getCreationButtons(String string, boolean bl) {
        if (bl) {
            return null;
        }
        ASEToolBarButton aSEToolBarButton = null;
        if (string.equals(ASEUtils.getString("DISP_BACKUP_SERVER_PANEL_NAME"))) {
            aSEToolBarButton = new ASEToolBarButton(3087, RemoteServerBO.NEW_REMOTE_SERVER_ICON, ASEUtils.getString("BACKUP_SERVER_SERVER_CONFIGURE_TEXT"), ASEUtils.getString("BACKUP_SERVER_SERVER_CONFIGURE_HINT_TEXT"));
        } else if (string.equals(ASEUtils.getString("DISP_XP_SERVER_PANEL_NAME"))) {
            aSEToolBarButton = new ASEToolBarButton(3088, RemoteServerBO.NEW_REMOTE_SERVER_ICON, ASEUtils.getString("XP_SERVER_SERVER_CONFIGURE_TEXT"), ASEUtils.getString("XP_SERVER_SERVER_CONFIGURE_HINT_TEXT"));
        } else if (string.equals(ASEUtils.getString("DISP_MONITOR_SERVER_PANEL_NAME"))) {
            aSEToolBarButton = new ASEToolBarButton(3089, RemoteServerBO.NEW_REMOTE_SERVER_ICON, ASEUtils.getString("MONITOR_SERVER_SERVER_CONFIGURE_TEXT"), ASEUtils.getString("MONITOR_SERVER_SERVER_CONFIGURE_HINT_TEXT"));
        }
        return new ASEToolBarButton[]{aSEToolBarButton};
    }

    public static ASEToolBarButton[] getCreationButtons(boolean bl) {
        String string = Support.getViewerSupport().getSelectedDetailsTabName();
        return BackupServersCtrBO.getCreationButtons(string, bl);
    }

    public static ASEMenuItem getContextMenuItems(String string, boolean bl) {
        if (bl) {
            return null;
        }
        ASEMenuItem aSEMenuItem = null;
        if (string.equals(ASEUtils.getString("DISP_BACKUP_SERVER_PANEL_NAME"))) {
            aSEMenuItem = new ASEMenuItem(3087, ASEUtils.getString("BACKUP_SERVER_SERVER_CONFIGURE_TEXT"), ASEUtils.getString("BACKUP_SERVER_SERVER_CONFIGURE_HINT_TEXT"), ASEUtils.getMnemonic("AUXILIARY_SERVER_CONFIGURE_MNEM"), RemoteServerBO.NEW_REMOTE_SERVER_ICON);
        } else if (string.equals(ASEUtils.getString("DISP_XP_SERVER_PANEL_NAME"))) {
            aSEMenuItem = new ASEMenuItem(3088, ASEUtils.getString("XP_SERVER_SERVER_CONFIGURE_TEXT"), ASEUtils.getString("XP_SERVER_SERVER_CONFIGURE_HINT_TEXT"), ASEUtils.getMnemonic("AUXILIARY_SERVER_CONFIGURE_MNEM"), RemoteServerBO.NEW_REMOTE_SERVER_ICON);
        } else if (string.equals(ASEUtils.getString("DISP_MONITOR_SERVER_PANEL_NAME"))) {
            aSEMenuItem = new ASEMenuItem(3089, ASEUtils.getString("MONITOR_SERVER_SERVER_CONFIGURE_TEXT"), ASEUtils.getString("MONITOR_SERVER_SERVER_CONFIGURE_HINT_TEXT"), ASEUtils.getMnemonic("AUXILIARY_SERVER_CONFIGURE_MNEM"), RemoteServerBO.NEW_REMOTE_SERVER_ICON);
        }
        return aSEMenuItem;
    }

    public static SCMenu getAuxContextMenu(boolean bl) {
        String string = Support.getViewerSupport().getSelectedDetailsTabName();
        ASEMenuItem aSEMenuItem = BackupServersCtrBO.getContextMenuItems(string, bl);
        if (aSEMenuItem == null) {
            return null;
        }
        ASEMenu aSEMenu = new ASEMenu();
        aSEMenu.addItem((SCMenuItem)aSEMenuItem);
        return aSEMenu;
    }

    @Override
    public SCMenu getContextMenu() {
        return BackupServersCtrBO.getAuxContextMenu(this._isExists);
    }

    @Override
    public ASEToolBarButton[] getCreationButtons() {
        return BackupServersCtrBO.getCreationButtons(this._isExists);
    }

    private boolean canCreateAuxServer() {
        ServerBO serverBO = ContainerViewBO.getServerBO(this.getConnection());
        ServerSO serverSO = (ServerSO)serverBO.getSO();
        try {
            if (serverSO.isLocalInstallation() && !serverBO.supportInLocalInstallation()) {
                Support.showDetailsError(this.getConnection(), this.getClass(), ASEUtils.getString("SDC_CLUSTER_INVALID_LDAP_IN_LOCAL_MODE_ERROR"), new UnsupportedOperationException(ASEUtils.getString("SDC_CLUSTER_INVALID_LDAP_IN_LOCAL_MODE_ERROR_DETAILS")));
                return false;
            }
        }
        catch (AuthorizationException authorizationException) {
            Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("MSG_NEED_AGENT_AUTHENTICATION"));
        }
        catch (Exception exception) {
            Support.showError(this.getConnection(), this.getClass(), exception.toString());
        }
        return true;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        if (n == 3087 && this.canCreateAuxServer()) {
            if (this._serverSO.isSupportMBS()) {
                BackupServerSO2 backupServerSO2 = new BackupServerSO2(this.getConnection(), this.getSO(), this._serverSO);
                ASEBaseDialog2.showDialog(jFrame, new BackupServerWizard2(backupServerSO2, this));
            } else {
                BackupServerSO backupServerSO = new BackupServerSO(this.getConnection(), this.getSO(), this._serverSO);
                ASEBaseDialog2.showDialog(jFrame, new BackupServerWizard(backupServerSO, this));
            }
        } else if (n == 3088 && this.canCreateAuxServer()) {
            XPServerSO xPServerSO = new XPServerSO(this.getConnection(), this.getSO(), this._serverSO);
            ASEBaseDialog2.showDialog(jFrame, new XPServerWizard(xPServerSO, this));
        } else if (n == 3089 && this.canCreateAuxServer()) {
            MonitorServerSO monitorServerSO = new MonitorServerSO(this.getConnection(), this.getSO(), this._serverSO);
            ASEBaseDialog2.showDialog(jFrame, new MonitorServerWizard(monitorServerSO, this));
        }
        super.onCommand(jFrame, n, enumeration, n2);
    }
}

