/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.prop.ASEBasePropertiesDialog2;
import com.sybase.aseplugin.bo.prop.CacheProperties;
import com.sybase.aseplugin.so.ASEBaseSO;
import com.sybase.aseplugin.so.CacheSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.central.SCContainer2;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class CacheBO
extends ASEBaseItem2 {
    public static final ImageIcon CACHE_ICON = new ImageIcon(ASEImages.getCacheSmallImage());
    public static final ImageIcon NEW_CACHE_ICON = new ImageIcon(ASEImages.getNewCacheImage());
    private static final int CACHE_LOCALTEMPDB_WAINING = 19776;
    private static final int CACHE_TEMPDB_WAINING = 19120;

    public CacheBO(CacheSO cacheSO, ASEBaseContainer2 aSEBaseContainer2) {
        super((SOItemInterface)cacheSO, aSEBaseContainer2, (Icon)CACHE_ICON);
    }

    @Override
    public ASEBasePropertiesDialog2 getPropertiesDialog() {
        return new CacheProperties((CacheSO)this.getSO(), (SCContainer2)this.getParent());
    }

    @Override
    public boolean includeDelete() {
        CacheSO cacheSO = (CacheSO)this.getSO();
        return !cacheSO.getName().equals("default data cache") && !cacheSO.isDeletePending();
    }

    @Override
    public boolean includeDDLGen() {
        return true;
    }

    @Override
    public String[] getDDLGenParams(SOItemInterface sOItemInterface) {
        CacheSO cacheSO = (CacheSO)sOItemInterface;
        if (cacheSO.getConnection().isCluster() && cacheSO.getCacheScope() == CacheSO.CACHE_SCOPE_SDC_LOCAL) {
            return new String[]{"-N" + cacheSO.getConnection().getServerName() + "." + cacheSO.getFullyQualifiedName(), "-T" + cacheSO.getType()};
        }
        return super.getDDLGenParams(sOItemInterface);
    }

    @Override
    public boolean deleteObjects(ArrayList arrayList) {
        boolean bl = true;
        Support.getViewerSupport().startWait();
        String string = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            try {
                CacheBO cacheBO = (CacheBO)arrayList.get(i);
                object = (CacheSO)cacheBO.getSO();
                Vector vector = ((CacheSO)object).getBindingObjets();
                Vector vector2 = (Vector)vector.get(0);
                Vector vector3 = (Vector)vector.get(1);
                Vector vector4 = (Vector)vector.get(2);
                if (vector != null && (vector2.size() > 0 || vector3.size() > 0 || vector4.size() > 0)) {
                    String string2;
                    String string3;
                    Object object2;
                    Vector vector5;
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_UNBIND_CACHE_BEFORE_DELETE"), ((ASEBaseSO)object).getName());
                    int n = Support.showQuestionYesNo(aSEMessageText.toString());
                    if (n != 0) continue;
                    Vector vector6 = ((CacheSO)object).getDBList();
                    for (int j = 0; j < vector6.size(); ++j) {
                        vector5 = (Vector)vector6.elementAt(j);
                        try {
                            ((CacheSO)object).unbindDB(((JLabel)vector5.elementAt(0)).getText());
                            continue;
                        }
                        catch (SQLException sQLException) {
                            if (sQLException.getErrorCode() == 19776 || sQLException.getErrorCode() == 19120) {
                                Support.showInfo(this.getConnection(), this.getClass(), sQLException.getMessage());
                                continue;
                            }
                            throw sQLException;
                        }
                    }
                    Vector vector7 = ((CacheSO)object).getTableList();
                    for (int j = 0; j < vector7.size(); ++j) {
                        Vector vector8 = (Vector)vector7.elementAt(j);
                        object2 = ((JLabel)vector8.elementAt(0)).getText();
                        string3 = (String)vector8.elementAt(1);
                        string2 = (String)vector8.elementAt(2);
                        ((CacheSO)object).unbindTable((String)object2, string3, string2);
                    }
                    vector5 = ((CacheSO)object).getIndexList();
                    for (int j = 0; j < vector5.size(); ++j) {
                        object2 = (Vector)vector5.elementAt(j);
                        string3 = ((JLabel)((Vector)object2).elementAt(0)).getText();
                        string2 = (String)((Vector)object2).elementAt(1);
                        String string4 = (String)((Vector)object2).elementAt(2);
                        String string5 = (String)((Vector)object2).elementAt(4);
                        ((CacheSO)object).unbindIndex(string3, string2, string4, string5);
                    }
                    ((CacheSO)object).remove();
                    continue;
                }
                cacheBO.getSO().remove();
                continue;
            }
            catch (SQLWarning sQLWarning) {
                object = sQLWarning.getMessage();
                if (((String)object).endsWith("\n")) {
                    string = string + (String)object;
                    continue;
                }
                string = string + (String)object + "\n";
                continue;
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
                bl = false;
            }
        }
        if (string.length() > 0) {
            Support.showWarning(this.getConnection(), this.getClass(), string);
        }
        Support.getViewerSupport().endWait();
        return bl;
    }
}

