/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseDialog2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.CacheBO;
import com.sybase.aseplugin.bo.SDCInstanceBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.CacheWizard;
import com.sybase.aseplugin.go.ASEToolBarButton;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.CacheSO;
import com.sybase.aseplugin.so.CachesCtrSO;
import java.util.Enumeration;
import javax.swing.JFrame;

public class CachesCtrBO
extends ASEBaseContainer2 {
    private final int COL_NAME = 0;
    private final int COL_STATUS = 1;
    private final int COL_RUNNING_SIZE = 2;
    private final int COL_CONFIGURATED_SIZE = 3;
    private int _cacheCtrScope = CacheSO.CACHE_SCOPE_SMP;

    public CachesCtrBO(ServerBO serverBO) {
        super(ASEUtils.getString("DNAME_CACHES"), (ASEBaseContainer2)serverBO);
        this.setCtrSO(new CachesCtrSO(this.getConnection()));
    }

    public CachesCtrBO(String string, ServerBO serverBO) {
        super(string, (ASEBaseContainer2)serverBO);
        if (string.equals(ASEUtils.getString("DNAME_CACHES_GLOBAL"))) {
            this._cacheCtrScope = CacheSO.CACHE_SCOPE_SDC_GLOBAL;
        } else if (string.equals(ASEUtils.getString("DNAME_CACHES_LOCAL"))) {
            this._cacheCtrScope = CacheSO.CACHE_SCOPE_SDC_LOCAL;
        }
        CachesCtrSO cachesCtrSO = new CachesCtrSO(this.getConnection());
        cachesCtrSO.setCacheScope(this._cacheCtrScope);
        this.setCtrSO(cachesCtrSO);
    }

    @Override
    public ASEBaseHeader[] getHeadings() {
        return new ASEBaseHeader[]{new ASEBaseHeader(ASEUtils.getString("DISP_NAME_TEXT"), 0, 170), new ASEBaseHeader(ASEUtils.getString("DISP_STATUS_TEXT"), 1, 80), new ASEBaseHeader(ASEUtils.getString("DISP_RUNNING_SIZE_MB_TEXT"), 2, 80, 1), new ASEBaseHeader(ASEUtils.getString("DISP_CONFIGURATED_SIZE_MB_TEXT"), 3, 80, 1)};
    }

    @Override
    public ASEBaseItem2 getItemBO(ASEBaseItemSO aSEBaseItemSO) {
        return new CacheBO((CacheSO)aSEBaseItemSO, (ASEBaseContainer2)this);
    }

    @Override
    public ASEMenuItem[] getCreationMenuItems() {
        String string = ASEUtils.getString("MSG_CACHE_TYPE");
        String string2 = ASEUtils.getString("CREATION_HINT_NEW_CACHE");
        if (this.getParent() instanceof SDCInstanceBO) {
            string = ASEUtils.getString("MSG_CACHE_TYPE_SDC_LOCAL");
            string2 = ASEUtils.getString("CREATION_HINT_NEW_CACHE_SDC_LOCAL");
        }
        ASEMenuItem aSEMenuItem = new ASEMenuItem(3061, string, string2, Support.getMnemonic("CREATION_MNEM_NEW_CACHE"), CacheBO.CACHE_ICON);
        return new ASEMenuItem[]{aSEMenuItem};
    }

    @Override
    public ASEToolBarButton[] getCreationButtons() {
        String string = ASEUtils.getString("MSG_CACHE_TYPE");
        String string2 = ASEUtils.getString("CREATION_HINT_NEW_CACHE");
        if (this.getParent() instanceof SDCInstanceBO) {
            string = ASEUtils.getString("MSG_CACHE_TYPE_SDC_LOCAL");
            string2 = ASEUtils.getString("CREATION_HINT_NEW_CACHE_SDC_LOCAL");
        }
        ASEToolBarButton aSEToolBarButton = new ASEToolBarButton(3061, CacheBO.NEW_CACHE_ICON, string, string2);
        return new ASEToolBarButton[]{aSEToolBarButton};
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        if (n == 3061) {
            String string;
            CacheSO cacheSO = new CacheSO(this.getConnection());
            if (cacheSO.getConnection().isCluster()) {
                if (this.getParent() instanceof SDCInstanceBO) {
                    string = ASEUtils.getString("MSG_ADD_CACHE_LOCAL");
                    cacheSO.setCacheScope(CacheSO.CACHE_SCOPE_SDC_LOCAL);
                } else {
                    string = ASEUtils.getString("MSG_ADD_CACHE_GLOBAL");
                    cacheSO.setCacheScope(CacheSO.CACHE_SCOPE_SDC_GLOBAL);
                }
            } else {
                string = ASEUtils.getString("MSG_ADD_CACHE");
                cacheSO.setCacheScope(CacheSO.CACHE_SCOPE_SMP);
            }
            ASEBaseDialog2.showDialog(jFrame, new CacheWizard(cacheSO, this, string));
        }
    }
}

