/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.LoginBO;
import com.sybase.aseplugin.bo.LoginsCtrBO;
import com.sybase.aseplugin.bo.RoleBO;
import com.sybase.aseplugin.bo.RolesCtrBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.ServerGroupBO;
import com.sybase.aseplugin.so.ASEBaseSO;
import com.sybase.aseplugin.so.LoginSO;
import com.sybase.aseplugin.so.RoleSO;
import java.util.ArrayList;
import java.util.HashMap;

public final class ClipboardHelper {
    private static final int UnkownType = -1;
    private static final int LoginBOType = 0;
    private static final int RoleBOType = 1;
    private ArrayList delayedDeleteList = null;
    private ASEBaseItem2 _srcItem = null;
    private ASEBaseItem2 _destItem = null;
    private boolean _isDestItemContainer = false;
    private int _itemType = -1;
    private boolean _enableDelayedDelete = false;
    private HashMap _pastableTypeMap = null;
    private static ClipboardHelper _instance = null;

    public static ClipboardHelper getInstance() {
        if (_instance == null) {
            _instance = new ClipboardHelper();
            _instance.initPastableTypeMap();
        }
        return _instance;
    }

    private ClipboardHelper() {
    }

    public void setDelayedDelete(boolean bl) {
        this._enableDelayedDelete = bl;
    }

    public boolean getDelayedDelete() {
        return this._enableDelayedDelete;
    }

    public void setClipboardStart(ASEBaseItem2 aSEBaseItem2, ArrayList arrayList) {
        this._srcItem = aSEBaseItem2;
        this.setDelayedDelete(true);
        if (this.delayedDeleteList != null && this.delayedDeleteList.size() > 0) {
            this.delayedDeleteList.clear();
        }
        this.delayedDeleteList = arrayList;
        this._itemType = this._srcItem instanceof LoginBO ? 0 : (this._srcItem instanceof RoleBO ? 1 : -1);
    }

    public boolean setClipboardProccessing(ASEBaseItem2 aSEBaseItem2, ASEBaseItem2 aSEBaseItem22, boolean bl) {
        this.setClipBoardEnd(aSEBaseItem22, aSEBaseItem2, bl);
        boolean bl2 = false;
        if (!this.isDeleteOver()) {
            bl2 = this.deleteSrcItem();
        }
        this.refreshSrcDestItemContainer();
        return bl2;
    }

    private void setClipBoardEnd(ASEBaseItem2 aSEBaseItem2, ASEBaseItem2 aSEBaseItem22, boolean bl) {
        this._srcItem = aSEBaseItem2;
        this._destItem = aSEBaseItem22;
        this._isDestItemContainer = bl;
    }

    private boolean isDeleteOver() {
        return this.delayedDeleteList.size() == 0;
    }

    private boolean deleteSrcItem() {
        for (int i = 0; i < this.delayedDeleteList.size(); ++i) {
            Object object;
            boolean bl = false;
            switch (this._itemType) {
                case 0: {
                    object = (LoginSO)((LoginBO)this._srcItem).getSO();
                    LoginSO loginSO = (LoginSO)((LoginBO)this.delayedDeleteList.get(i)).getSO();
                    bl = ((ASEBaseSO)object).getName() == loginSO.getName();
                    break;
                }
                case 1: {
                    RoleSO roleSO = (RoleSO)((RoleBO)this._srcItem).getSO();
                    RoleSO roleSO2 = (RoleSO)((RoleBO)this.delayedDeleteList.get(i)).getSO();
                    bl = roleSO.getName() == roleSO2.getName();
                    break;
                }
                case -1: {
                    return false;
                }
            }
            if (!bl) continue;
            object = new ArrayList(1);
            ((ArrayList)object).add(this.delayedDeleteList.get(i));
            this.delayedDeleteList.remove(i);
            return this._destItem.deleteObjects((ArrayList)object);
        }
        return false;
    }

    private void refreshSrcDestItemContainer() {
        if (this._isDestItemContainer) {
            ((ASEBaseContainer2)this._destItem).refresh();
        } else {
            this._destItem.getParent().refresh();
        }
        this._srcItem.getParent().refresh();
    }

    private void initPastableTypeMap() {
        this._pastableTypeMap = new HashMap();
        this._pastableTypeMap.put(new Long(40L), new long[]{40L, 139L});
        this._pastableTypeMap.put(new Long(24L), new long[]{24L, 124L});
        this._pastableTypeMap.put(new Long(35L), new long[]{35L, 134L});
    }

    public boolean isPastable(ASEBaseItem2 aSEBaseItem2, ASEBaseItem2 aSEBaseItem22) {
        long l = this.getASEBaseItem2Type(aSEBaseItem2);
        long l2 = this.getASEBaseItem2Type(aSEBaseItem22);
        if (l == -1L || l2 == -1L) {
            return false;
        }
        long[] lArray = (long[])this._pastableTypeMap.get(new Long(l));
        for (int i = 0; i < lArray.length; ++i) {
            if (l2 != lArray[i]) continue;
            return true;
        }
        return false;
    }

    private long getASEBaseItem2Type(ASEBaseItem2 aSEBaseItem2) {
        if (aSEBaseItem2 instanceof ServerBO) {
            return 40L;
        }
        if (aSEBaseItem2 instanceof ServerGroupBO) {
            return 139L;
        }
        if (aSEBaseItem2 instanceof LoginBO) {
            return 24L;
        }
        if (aSEBaseItem2 instanceof LoginsCtrBO) {
            return 124L;
        }
        if (aSEBaseItem2 instanceof RoleBO) {
            return 35L;
        }
        if (aSEBaseItem2 instanceof RolesCtrBO) {
            return 134L;
        }
        return -1L;
    }

    class ASEBaseItemType {
        public static final long UnKnown = -1L;
        private static final long LoginBO = 24L;
        private static final long RoleBO = 35L;
        private static final long ServerBO = 40L;
        private static final long LoginsCtrBO = 124L;
        private static final long RolesCtrBO = 134L;
        private static final long ServerGroupBO = 139L;

        ASEBaseItemType() {
        }
    }
}

