/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo;

import com.sybase.asa.ASAEditor;
import com.sybase.asa.ASAToolBarButton;
import com.sybase.asa.QueryEditor.ASEQueryEditor;
import com.sybase.asa.QueryEditor.DefaultASEQueryModel;
import com.sybase.asa.QueryEditor.DefaultQueryModel;
import com.sybase.asa.QueryEditor.QueryEditorDialog;
import com.sybase.asa.QueryEditor.QueryModel;
import com.sybase.aseisqlplugin.ASEISQLPlugin;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseCodeContainer;
import com.sybase.aseplugin.bo.ASEMenu;
import com.sybase.aseplugin.bo.ASEMenuItem;
import com.sybase.aseplugin.bo.DefaultBO;
import com.sybase.aseplugin.bo.RuleBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.UserDefinedWebServiceBO;
import com.sybase.aseplugin.bo.dlg.PrintingDialog;
import com.sybase.aseplugin.go.ASEEditor;
import com.sybase.aseplugin.so.ASEBaseCodeItemSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.central.DefaultSCDetailsContainer;
import com.sybase.central.DefaultSCItem3;
import com.sybase.central.SCContainer;
import com.sybase.central.SCDetailsContainer;
import com.sybase.central.SCDetailsPanel4;
import com.sybase.central.SCItem;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.central.SCProvider;
import com.sybase.central.SCToolBarButton;
import com.sybase.central.SCViewerManager;
import com.sybase.central.editor.Editor;
import com.sybase.central.editor.PrinterJobListener;
import com.sybase.central.editor.SCEditor;
import com.sybase.util.ClipboardManager;
import com.sybase.util.DialogUtils;
import com.sybase.util.ImageLoader;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

class CodeDetailsPanel
extends JPanel
implements SCDetailsPanel4,
CaretListener,
FocusListener {
    static final int SAVE = 3001;
    static final int REVERT = 3002;
    static final int PRINT = 3003;
    static final int FIND_REPLACE = 3004;
    static final int FIND_NEXT = 3005;
    static final int QUERY_EDITOR = 3006;
    private static TreeSet<Integer> _cmds = new TreeSet();
    private SCViewerManager _viewerManager = null;
    private String _panelName = "";
    private ASEBaseCodeContainer _container = null;
    private CodeDetailsContainer _codeDetailsContainer = null;
    private boolean _isOpen = false;
    private ASAEditor _editor = null;
    private boolean _hasFocus = false;
    private JPanel _statusBarPanel = new JPanel();
    private JLabel _lineTextLabel = new JLabel("1");
    private JLabel _columnTextLabel = new JLabel("1");
    private String _codeName;
    private EditorSCItem _editorSCItem = new EditorSCItem();
    private boolean _readOnly;
    ImageIcon _saveImage = new ImageIcon(ASEImages.getSaveToDBSmallImage());
    ImageIcon _queryEditorImage = new ImageIcon(ASEImages.getQueryEditorSmallImage());
    ImageIcon _findImage = ImageLoader.getImageIcon(ImageLoader.class, (String)"find", (int)1004);
    ImageIcon _saveToolbarImage = ASEUtils.OS_MAC_OS_X ? new ImageIcon(ASEImages.getSaveToDBLargeImage()) : this._saveImage;
    ImageIcon _queryEditorToolbarImage = ASEUtils.OS_MAC_OS_X ? new ImageIcon(ASEImages.getQueryEditorLargeImage()) : this._queryEditorImage;
    ASAToolBarButton _saveToolBarButton = new ASAToolBarButton(3001, (Icon)this._saveToolbarImage, ASEUtils.getString("BBTN_SAVE"));
    ASAToolBarButton _printToolBarButton = new ASAToolBarButton(3003, (Icon)ImageLoader.getImageIcon(ImageLoader.class, (String)"print", (int)1000), ASEUtils.getString("EDIT_TTIP_PRINT"));
    ASAToolBarButton _findToolBarButton = new ASAToolBarButton(3004, (Icon)ImageLoader.getImageIcon(ImageLoader.class, (String)"find", (int)1000), ASEUtils.getString("CONTEXT_MENU_FIND_REPLACE_TEXT"));
    ASAToolBarButton _queryToolBarButton = new ASAToolBarButton(3006, (Icon)this._queryEditorToolbarImage, ASEUtils.getString("EDIT_TTIP_QUERY_EDITOR"));

    static boolean handlesCommand(int n) {
        return _cmds.contains(new Integer(n));
    }

    CodeDetailsPanel() {
        this._panelName = ASEUtils.getString("TABP_CODE");
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        flowLayout.setHgap(10);
        flowLayout.setVgap(0);
        JLabel jLabel = new JLabel(ASEUtils.getString("EDIT_LABC_LINE"));
        JLabel jLabel2 = new JLabel(ASEUtils.getString("EDIT_LABC_COLUMN"));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createBevelBorder(1));
        jPanel.setLayout(flowLayout);
        jPanel.add(jLabel);
        jPanel.add(this._lineTextLabel);
        jPanel.add(jLabel2);
        jPanel.add(this._columnTextLabel);
        JLabel jLabel3 = new JLabel("");
        this._statusBarPanel.add(jLabel3);
        this._statusBarPanel.add(jPanel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this._statusBarPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
    }

    public void redisplayItem(SCItem sCItem) {
    }

    public void addItem(SCItem sCItem) {
    }

    public void deleteItem(SCItem sCItem) {
    }

    public void setSCDetailsContainer(SCDetailsContainer sCDetailsContainer) {
    }

    public void selectFirstItem() {
    }

    public void selectAllItems() {
    }

    public void invertSelectedItems() {
    }

    public SCDetailsContainer getSCDetailsContainer() {
        return this._codeDetailsContainer;
    }

    EditorSCItem getEditorSCItem() {
        return this._editorSCItem;
    }

    public JComponent getJComponent() {
        return this;
    }

    public boolean onKillActiveNotification() {
        if (this._editor == null || !this._editor.isChanged()) {
            return true;
        }
        this._editor.removeCaretListener((CaretListener)this);
        this._hasFocus = false;
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("PROC_QUES_CONFIRM_SAVE"), this._codeName);
        int n = Support.showQuestionYesNoCancel(aSEMessageText.toString());
        if (n == 0) {
            return this.save(this._viewerManager.getViewerFrame());
        }
        if (n == 1) {
            this.revert();
            this._container.redisplay();
            return true;
        }
        return false;
    }

    public void setViewerManager(SCViewerManager sCViewerManager) {
        this._viewerManager = sCViewerManager;
    }

    public void onOpen(SCContainer sCContainer) {
        if (this._isOpen) {
            return;
        }
        this._isOpen = true;
        this._container = (ASEBaseCodeContainer)sCContainer;
        this._codeName = this._container.getCodeSO().getDisplayName();
        this._codeDetailsContainer = new CodeDetailsContainer("SQL", null);
        this._editor = new ASEEditor(true);
        this._editor.addCaretListener((CaretListener)this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this._editor.getScrollPane(), gridBagConstraints);
        this.revert();
        DatabaseSO databaseSO = this._container.getCodeSO().getDatabaseSO();
        boolean bl = databaseSO.getOption("DB_OP_DDL_IN_TRAN");
        this._readOnly = !bl;
        this._editor.setEditable(bl);
        if (this._readOnly) {
            String string = ASEUtils.getString("CONTEXT_MENU_SAVE_OBJECT_MORE_HINT");
            String string2 = ASEUtils.getString("BBTN_SAVE") + " (" + string + ")";
            this._saveToolBarButton.setToolTipText(string2);
            string2 = ASEUtils.getString("EDIT_TTIP_QUERY_EDITOR") + " (" + string + ")";
            this._queryToolBarButton.setToolTipText(string2);
        }
    }

    public void setPanelName(String string) {
        this._panelName = string;
    }

    public String getPanelName() {
        return this._panelName;
    }

    public void releaseAllResources() {
        this._saveToolBarButton.releaseResources();
        this._printToolBarButton.releaseResources();
        this._findToolBarButton.releaseResources();
        this._queryToolBarButton.releaseResources();
        this._saveToolBarButton = null;
        this._printToolBarButton = null;
        this._findToolBarButton = null;
        this._queryToolBarButton = null;
        if (this._editor != null) {
            this._editor.removeFocusListener((FocusListener)this);
            this._editor.removeCaretListener((CaretListener)this);
            this._editor.destroy();
            this._editor = null;
        }
        this._container = null;
        this._viewerManager = null;
        DialogUtils.removeComponents((Container)this);
        this._statusBarPanel = null;
        this._lineTextLabel = null;
        this._columnTextLabel = null;
    }

    public void onSetActive() {
        this._editor.addFocusListener((FocusListener)this);
        Support.getViewerSupport().setStatusBarJComponent((JComponent)this._statusBarPanel, (SCProvider)Support.getProvider());
    }

    public void onKillActive() {
        Support.getViewerSupport().setStatusBarJComponent(null, (SCProvider)Support.getProvider());
        if (this._editor != null) {
            this._editor.removeFocusListener((FocusListener)this);
        }
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.updateLineAndColumnLabel(caretEvent.getDot());
        this.updateItem();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.updateItem();
        if (this._editor != null) {
            this._editor.addCaretListener((CaretListener)this);
        }
        this._hasFocus = true;
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this._editor != null) {
            this._editor.removeCaretListener((CaretListener)this);
        }
        this._hasFocus = false;
    }

    private void updateLineAndColumnLabel(int n) {
        Point point = this._editor.getCaretLineAndColumn(n);
        this._columnTextLabel.setText(Integer.toString(point.x));
        this._lineTextLabel.setText(Integer.toString(point.y));
    }

    public void releaseResources() {
    }

    public void refresh() {
    }

    void updateItem() {
        if (this._viewerManager != null && this._codeDetailsContainer != null) {
            this._viewerManager.setSelectedDetailsItems(new SCItem[]{this._editorSCItem});
        }
    }

    void updateUndoRedoState() {
        if (this._hasFocus) {
            this.updateItem();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean save(JFrame jFrame) {
        this._editor.removeCaretListener((CaretListener)this);
        this._hasFocus = false;
        ASEBaseCodeItemSO aSEBaseCodeItemSO = this._container.getCodeSO();
        try {
            aSEBaseCodeItemSO.getConnection().executeCommand("begin tran");
            aSEBaseCodeItemSO.remove();
            aSEBaseCodeItemSO.setSQLText(this._editor.getText());
            aSEBaseCodeItemSO.create();
            aSEBaseCodeItemSO.getConnection().executeCommand("commit tran");
            this._editor.setChanged(false);
            this._container.getParent().refresh();
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(aSEBaseCodeItemSO.getConnection(), this.getClass(), (Container)jFrame, sQLException.getMessage(), sQLException);
            this._container.selectErrorPhrase(sQLException, (Editor)this._editor);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                aSEBaseCodeItemSO.getConnection().executeCommand("rollback tran");
            }
            catch (SQLException sQLException) {}
        }
        return true;
    }

    void revert() {
        ASEBaseCodeItemSO aSEBaseCodeItemSO = this._container.getCodeSO();
        try {
            this._editor.setText(aSEBaseCodeItemSO.getCreateCode());
            this._editor.setChanged(false);
            this.updateItem();
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(aSEBaseCodeItemSO.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
        }
    }

    static {
        _cmds.add(new Integer(3001));
        _cmds.add(new Integer(3002));
        _cmds.add(new Integer(3003));
        _cmds.add(new Integer(3004));
        _cmds.add(new Integer(3005));
        _cmds.add(new Integer(3006));
    }

    class EditorSCItem
    extends DefaultSCItem3 {
        EditorSCItem() {
        }

        public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
            switch (n) {
                case 101: {
                    if (CodeDetailsPanel.this._editor == null) break;
                    CodeDetailsPanel.this._editor.cutActionPerformed();
                    break;
                }
                case 102: {
                    if (CodeDetailsPanel.this._editor == null) break;
                    CodeDetailsPanel.this._editor.copyActionPerformed();
                    break;
                }
                case 103: {
                    if (CodeDetailsPanel.this._editor == null) break;
                    CodeDetailsPanel.this._editor.pasteActionPerformed();
                    break;
                }
                case 106: {
                    if (CodeDetailsPanel.this._editor == null) break;
                    CodeDetailsPanel.this._editor.deleteSelection();
                    break;
                }
                case 109: {
                    if (CodeDetailsPanel.this._editor != null && CodeDetailsPanel.this._editor.getUndoManager().canUndo()) {
                        CodeDetailsPanel.this._editor.getUndoManager().undo();
                    }
                    CodeDetailsPanel.this.updateUndoRedoState();
                    break;
                }
                case 108: {
                    if (CodeDetailsPanel.this._editor != null && CodeDetailsPanel.this._editor.getUndoManager().canRedo()) {
                        CodeDetailsPanel.this._editor.getUndoManager().redo();
                    }
                    CodeDetailsPanel.this.updateUndoRedoState();
                    break;
                }
                case 3001: {
                    CodeDetailsPanel.this.save(jFrame);
                    break;
                }
                case 3002: {
                    CodeDetailsPanel.this.revert();
                    break;
                }
                case 3003: {
                    PrintingDialog.create(jFrame, CodeDetailsPanel.this._codeName, (SCEditor)CodeDetailsPanel.this._editor);
                    break;
                }
                case 3004: {
                    CodeDetailsPanel.this._editor.findReplaceActionPerformed();
                    break;
                }
                case 3005: {
                    CodeDetailsPanel.this._editor.findNextActionPerformed();
                    break;
                }
                case 3006: {
                    QueryEditorDialog queryEditorDialog = null;
                    DefaultQueryModel defaultQueryModel = null;
                    if (CodeDetailsPanel.this._editor == null || CodeDetailsPanel.this._editor.getDocument() == null) break;
                    String string = CodeDetailsPanel.this._editor.getSelectedText();
                    if (string != null && string.length() > 0) {
                        try {
                            defaultQueryModel = new DefaultASEQueryModel(string);
                        }
                        catch (Exception exception) {
                            if (Support.showQuestionYesNo(jFrame, ASEUtils.getString("ERRM_QUERY_PARSE_FAILED")) != 0) {
                                return;
                            }
                            defaultQueryModel = new DefaultASEQueryModel();
                        }
                    } else {
                        defaultQueryModel = new DefaultQueryModel();
                    }
                    queryEditorDialog = new QueryEditorDialog((Frame)jFrame, CodeDetailsPanel.this._container.getSO().getConnection().getConnection(), ASEISQLPlugin.getHelpFolder(), ASEISQLPlugin.getHelpPrefix(), ASEISQLPlugin.getHelpSuffix(), ASEQueryEditor.class);
                    queryEditorDialog.setModel((QueryModel)defaultQueryModel);
                    int n3 = queryEditorDialog.open();
                    if (n3 != 0) break;
                    CodeDetailsPanel.this._editor.replaceSelection(queryEditorDialog.getModel().getSQLQuery());
                }
            }
        }

        public SCMenu getContextMenu() {
            ASEMenu aSEMenu = new ASEMenu();
            boolean bl = false;
            if (CodeDetailsPanel.this._editor != null) {
                bl = CodeDetailsPanel.this._editor.isChanged();
            }
            ASEMenuItem aSEMenuItem = new ASEMenuItem(3001, ASEUtils.getString("BBTN_SAVE"), ASEUtils.getString("CONTEXT_MENU_SAVE_OBJECT_HINT") + (CodeDetailsPanel.this._readOnly ? ASEUtils.getString("CONTEXT_MENU_SAVE_OBJECT_MORE_HINT") : ""), CodeDetailsPanel.this._saveImage, KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            aSEMenuItem.setEnabled(bl);
            aSEMenu.addItem((SCMenuItem)aSEMenuItem);
            aSEMenuItem = new ASEMenuItem(3002, ASEUtils.getString("CONTEXT_MENU_REVERT_TEXT"), ASEUtils.getString("CONTEXT_MENU_REVERT_HINT"));
            aSEMenuItem.setEnabled(bl);
            aSEMenu.addItem((SCMenuItem)aSEMenuItem);
            aSEMenu.addItem((SCMenuItem)new ASEMenuItem());
            aSEMenu.addItem((SCMenuItem)new ASEMenuItem(3003, ASEUtils.getString("CONTEXT_MENU_PRINT_TEXT"), ASEUtils.getString("CONTEXT_MENU_PRINT_HINT"), null, KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())));
            aSEMenu.addItem((SCMenuItem)new ASEMenuItem());
            ASEMenu aSEMenu2 = new ASEMenu(ASEUtils.getString("CONTEXT_MENU_SEARCH_TEXT"));
            aSEMenu2.addItem((SCMenuItem)new ASEMenuItem(3004, ASEUtils.getString("CONTEXT_MENU_FIND_REPLACE_TEXT"), ASEUtils.getString("CONTEXT_MENU_FIND_REPLACE_HINT"), CodeDetailsPanel.this._findImage, KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())));
            aSEMenu2.addItem((SCMenuItem)new ASEMenuItem(3005, ASEUtils.getString("CONTEXT_MENU_FIND_AGAIN_TEXT"), ASEUtils.getString("CONTEXT_MENU_FIND_AGAIN_HINT"), null, KeyStroke.getKeyStroke(114, 0)));
            aSEMenu.addItem((SCMenuItem)aSEMenu2);
            aSEMenuItem = new ASEMenuItem(3006, ASEUtils.getString("CONTEXT_MENU_QUERY_EDITOR_TEXT"), ASEUtils.getString("CONTEXT_MENU_QUERY_EDITOR_HINT") + (CodeDetailsPanel.this._readOnly ? ASEUtils.getString("CONTEXT_MENU_SAVE_OBJECT_MORE_HINT") : ""), CodeDetailsPanel.this._queryEditorImage, null);
            if (CodeDetailsPanel.this._readOnly) {
                aSEMenuItem.setEnabled(false);
            }
            aSEMenu.addItem((SCMenuItem)aSEMenuItem);
            aSEMenu.addItem((SCMenuItem)new ASEMenuItem());
            return aSEMenu;
        }

        public int[] getEnabledContextCmdIds() {
            int[] nArray;
            boolean bl = false;
            if (CodeDetailsPanel.this._editor != null) {
                bl = CodeDetailsPanel.this._editor.isChanged();
            }
            if (CodeDetailsPanel.this._container instanceof DefaultBO || CodeDetailsPanel.this._container instanceof RuleBO || CodeDetailsPanel.this._container instanceof UserDefinedWebServiceBO) {
                int[] nArray2;
                if (bl) {
                    int[] nArray3 = new int[3];
                    nArray3[0] = 3001;
                    nArray3[1] = 3003;
                    nArray2 = nArray3;
                    nArray3[2] = 3004;
                } else {
                    int[] nArray4 = new int[2];
                    nArray4[0] = 3003;
                    nArray2 = nArray4;
                    nArray4[1] = 3004;
                }
                return nArray2;
            }
            if (CodeDetailsPanel.this._readOnly) {
                return new int[]{3003, 3004};
            }
            if (bl) {
                int[] nArray5 = new int[4];
                nArray5[0] = 3001;
                nArray5[1] = 3003;
                nArray5[2] = 3004;
                nArray = nArray5;
                nArray5[3] = 3006;
            } else {
                int[] nArray6 = new int[3];
                nArray6[0] = 3003;
                nArray6[1] = 3004;
                nArray = nArray6;
                nArray6[2] = 3006;
            }
            return nArray;
        }

        public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
            String string = "";
            if (CodeDetailsPanel.this._editor != null) {
                string = CodeDetailsPanel.this._editor.getSelectedText();
            }
            ClipboardManager clipboardManager = ClipboardManager.getContents((Clipboard)Toolkit.getDefaultToolkit().getSystemClipboard());
            boolean bl = false;
            if (clipboardManager != null) {
                Transferable transferable = clipboardManager.contents;
                if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    bl = true;
                }
            } else {
                Support.showError(null, ((Object)((Object)this)).getClass(), ASEUtils.getString("ERRM_CLIPBOARD_INACCESSIBLE"));
            }
            int n = 0;
            if (string != null && string.length() > 0) {
                n |= 0x2C;
            }
            if (bl) {
                n |= 0x10;
            }
            if (CodeDetailsPanel.this._editor != null && CodeDetailsPanel.this._editor.getUndoManager().canUndo()) {
                n |= 0x80;
            }
            if (CodeDetailsPanel.this._editor != null && CodeDetailsPanel.this._editor.getUndoManager().canRedo()) {
                n |= 0x100;
            }
            return n;
        }

        public String getItemScript() {
            if (CodeDetailsPanel.this._editor != null) {
                return CodeDetailsPanel.this._editor.getSelectedText();
            }
            return super.getItemScript();
        }
    }

    class CodeDetailsContainer
    extends DefaultSCDetailsContainer
    implements UndoableEditListener,
    PrinterJobListener {
        CodeDetailsContainer(String string, SCContainer sCContainer) {
            super(string, sCContainer);
        }

        public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
            CodeDetailsPanel.this._container.onCommand(jFrame, n, enumeration, n2);
        }

        public SCToolBarButton[] getContextToolBarButtons() {
            SCToolBarButton[] sCToolBarButtonArray = new SCToolBarButton[]{CodeDetailsPanel.this._saveToolBarButton, CodeDetailsPanel.this._printToolBarButton, null, CodeDetailsPanel.this._findToolBarButton, CodeDetailsPanel.this._queryToolBarButton};
            return sCToolBarButtonArray;
        }

        public int[] getEnabledContextCmdIds() {
            return CodeDetailsPanel.this._editorSCItem.getEnabledContextCmdIds();
        }

        public SCMenu getContextMenu() {
            return CodeDetailsPanel.this._container.getContextMenu();
        }

        public SCMenu getCreationMenu() {
            return CodeDetailsPanel.this._container.getCreationMenu();
        }

        public SCToolBarButton[] getCreationToolBarButtons() {
            return CodeDetailsPanel.this._container.getCreationButtons();
        }

        void print() {
            PrintingDialog.create(Support.getViewerFrame(), CodeDetailsPanel.this._codeName, (SCEditor)CodeDetailsPanel.this._editor);
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            CodeDetailsPanel.this.updateUndoRedoState();
        }

        public void printingStarted() {
        }

        public void printingStopped() {
        }

        public void printingPage(int n) {
        }
    }
}

